/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.security.policyevaluator.PolicyCache;
import org.openmetadata.service.security.policyevaluator.RoleCache;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectContext {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectContext.class);
    protected final User user;

    protected SubjectContext(User user) {
        this.user = user;
    }

    public boolean isAdmin() {
        return Boolean.TRUE.equals(this.user.getIsAdmin());
    }

    public boolean isBot() {
        return Boolean.TRUE.equals(this.user.getIsBot());
    }

    public boolean isOwner(EntityReference owner) {
        if (owner == null) {
            return false;
        }
        if (owner.getType().equals("user") && owner.getName().equals(this.user.getName())) {
            return true;
        }
        if (owner.getType().equals("team")) {
            for (EntityReference userTeam : this.user.getTeams()) {
                if (!userTeam.getName().equals(owner.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUserUnderTeam(String parentTeam) {
        return this.isInTeam(parentTeam, this.user.getTeams());
    }

    public boolean isTeamAsset(String parentTeam, EntityReference owner) {
        if (owner.getType().equals("user")) {
            SubjectContext subjectContext = SubjectCache.getInstance().getSubjectContext(owner.getName());
            return subjectContext.isUserUnderTeam(parentTeam);
        }
        if (owner.getType().equals("team")) {
            Team team = SubjectCache.getInstance().getTeam(owner.getId());
            return this.isInTeam(parentTeam, List.of(team.getEntityReference()));
        }
        return false;
    }

    private boolean isInTeam(String parentTeam, List<EntityReference> teams) {
        Stack stack = new Stack();
        CommonUtil.listOrEmpty(teams).forEach(stack::push);
        while (!stack.empty()) {
            Team parent = SubjectCache.getInstance().getTeam(((EntityReference)stack.pop()).getId());
            if (parent.getName().equals(parentTeam)) {
                return true;
            }
            CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
        }
        return false;
    }

    public Iterator<PolicyContext> getPolicies() {
        return new UserPolicyIterator(this.user, new ArrayList<UUID>());
    }

    public Iterator<PolicyContext> getResourcePolicies(EntityReference owner) {
        if (owner.getType().equals("user")) {
            SubjectContext subjectContext = SubjectCache.getInstance().getSubjectContext(owner.getName());
            return subjectContext.getPolicies();
        }
        if (owner.getType().equals("team")) {
            Team team = SubjectCache.getInstance().getTeam(owner.getId());
            ArrayList<UUID> teamsVisited = new ArrayList<UUID>();
            return new TeamPolicyIterator(team.getId(), teamsVisited);
        }
        return Collections.emptyIterator();
    }

    public List<EntityReference> getTeams() {
        return this.user.getTeams();
    }

    public User getUser() {
        return this.user;
    }

    static class UserPolicyIterator
    implements Iterator<PolicyContext> {
        private final User user;
        private int iteratorIndex = 0;
        private final List<Iterator<PolicyContext>> iterators = new ArrayList<Iterator<PolicyContext>>();

        UserPolicyIterator(User user, List<UUID> teamsVisited) {
            this.user = user;
            if (user.getRoles() != null) {
                this.iterators.add(new RolePolicyIterator("user", user.getName(), user.getRoles()));
            }
            for (EntityReference team : user.getTeams()) {
                this.iterators.add(new TeamPolicyIterator(team.getId(), teamsVisited));
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.iterators.size()) {
                if (this.iterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            LOG.debug("Subject {} policy iteration done" + this.user.getName());
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterators.get(this.iteratorIndex).next();
        }
    }

    static class TeamPolicyIterator
    implements Iterator<PolicyContext> {
        private int iteratorIndex = 0;
        private final List<Iterator<PolicyContext>> iterators = new ArrayList<Iterator<PolicyContext>>();

        TeamPolicyIterator(UUID teamId, List<UUID> teamsVisited) {
            Team team = SubjectCache.getInstance().getTeam(teamId);
            if (!teamsVisited.contains(teamId)) {
                teamsVisited.add(teamId);
                if (team.getDefaultRoles() != null) {
                    this.iterators.add(new RolePolicyIterator("team", team.getName(), team.getDefaultRoles()));
                }
                if (team.getPolicies() != null) {
                    this.iterators.add(new PolicyIterator("team", team.getName(), null, team.getPolicies()));
                }
                for (EntityReference parentTeam : CommonUtil.listOrEmpty((List)team.getParents())) {
                    this.iterators.add(new TeamPolicyIterator(parentTeam.getId(), teamsVisited));
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.iterators.size()) {
                if (this.iterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterators.get(this.iteratorIndex).next();
        }
    }

    static class RolePolicyIterator
    implements Iterator<PolicyContext> {
        private final String entityType;
        private final String entityName;
        private int iteratorIndex = 0;
        private final List<PolicyIterator> policyIterators = new ArrayList<PolicyIterator>();

        RolePolicyIterator(String entityType, String entityName, List<EntityReference> roles) {
            this.entityType = entityType;
            this.entityName = entityName;
            for (EntityReference role : CommonUtil.listOrEmpty(roles)) {
                this.policyIterators.add(new PolicyIterator(entityType, entityName, role.getName(), RoleCache.getInstance().getRole(role.getId()).getPolicies()));
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.policyIterators.size()) {
                if (this.policyIterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            LOG.debug("iteration over roles attached to entity {}:{} is completed", (Object)this.entityType, (Object)this.entityName);
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.policyIterators.get(this.iteratorIndex).next();
        }
    }

    static class PolicyIterator
    implements Iterator<PolicyContext> {
        private final String entityType;
        private final String entityName;
        private final String roleName;
        private int policyIndex = 0;
        private final List<EntityReference> policies;

        PolicyIterator(String entityType, String entityName, String roleName, List<EntityReference> policy) {
            this.entityType = entityType;
            this.entityName = entityName;
            this.roleName = roleName;
            this.policies = CommonUtil.listOrEmpty(policy);
        }

        @Override
        public boolean hasNext() {
            if (this.policyIndex >= this.policies.size()) {
                LOG.debug("iteration over policy attached to entity {}:{} role {} is completed", new Object[]{this.entityType, this.entityName, this.roleName});
            }
            return this.policyIndex < this.policies.size();
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EntityReference policy = this.policies.get(this.policyIndex++);
            return new PolicyContext(this.entityType, this.entityName, this.roleName, policy.getName(), PolicyCache.getInstance().getPolicyRules(policy.getId()));
        }
    }

    static class PolicyContext {
        private final String entityType;
        private final String entityName;
        private final String roleName;
        private final String policyName;
        private final List<CompiledRule> rules;

        PolicyContext(String entityType, String entityName, String role, String policy, List<CompiledRule> rules) {
            this.entityType = entityType;
            this.entityName = entityName;
            this.roleName = role;
            this.policyName = policy;
            this.rules = rules;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public List<CompiledRule> getRules() {
            return this.rules;
        }
    }
}

