/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringMap;
import org.openmetadata.schema.auth.LogoutRequest;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenCacheManager.class);
    private static final JwtTokenCacheManager instance = new JwtTokenCacheManager();
    private final ExpiringMap<String, LogoutRequest> tokenEventMap = ExpiringMap.builder().variableExpiration().maxSize(1000).build();

    private JwtTokenCacheManager() {
    }

    public static JwtTokenCacheManager getInstance() {
        return instance;
    }

    public void markLogoutEventForToken(LogoutRequest logoutRequest) {
        String token = logoutRequest.getToken();
        if (this.tokenEventMap.containsKey((Object)token)) {
            LOG.info(String.format("Log out token for user [%s] is already present in the cache", logoutRequest.getUsername()));
        } else {
            Date tokenExpiryDate = JWTTokenGenerator.getInstance().getTokenExpiryFromJWT(token);
            long ttlForToken = this.getTTLForToken(tokenExpiryDate);
            LOG.info(String.format("Logout token cache set for [%s] with a TTL of [%s] seconds. Token is due expiry at [%s]", logoutRequest.getUsername(), ttlForToken, tokenExpiryDate));
            this.tokenEventMap.put((Object)token, (Object)logoutRequest, ttlForToken, TimeUnit.SECONDS);
        }
    }

    public LogoutRequest getLogoutEventForToken(String token) {
        return (LogoutRequest)this.tokenEventMap.get((Object)token);
    }

    private long getTTLForToken(Date date) {
        long secondAtExpiry = date.toInstant().getEpochSecond();
        long secondAtLogout = Instant.now().getEpochSecond();
        return Math.max(0L, secondAtExpiry - secondAtLogout);
    }
}

