/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.slack.SlackAttachment;
import org.openmetadata.service.slack.SlackMessage;
import org.openmetadata.service.slack.TeamsMessage;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public final class ChangeEventParser {
    public static final String FEED_ADD_MARKER = "<!add>";
    public static final String FEED_REMOVE_MARKER = "<!remove>";
    public static final String FEED_BOLD = "**%s**";
    public static final String SLACK_BOLD = "*%s* ";
    public static final String FEED_SPAN_ADD = "<span class=\"diff-added\">";
    public static final String FEED_SPAN_REMOVE = "<span class=\"diff-removed\">";
    public static final String FEED_SPAN_CLOSE = "</span>";
    public static final String FEED_LINE_BREAK = " <br/> ";
    public static final String SLACK_LINE_BREAK = "\n";

    private ChangeEventParser() {
    }

    public static String getBold(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: 
            case TEAMS: {
                return FEED_BOLD;
            }
            case SLACK: {
                return SLACK_BOLD;
            }
        }
        return "INVALID";
    }

    public static String getLineBreak(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: 
            case TEAMS: {
                return FEED_LINE_BREAK;
            }
            case SLACK: {
                return SLACK_LINE_BREAK;
            }
        }
        return "INVALID";
    }

    public static String getAddMarker(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_ADD;
            }
            case TEAMS: {
                return "**";
            }
            case SLACK: {
                return "*";
            }
        }
        return "INVALID";
    }

    public static String getAddMarkerClose(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_CLOSE;
            }
            case TEAMS: {
                return "** ";
            }
            case SLACK: {
                return "* ";
            }
        }
        return "INVALID";
    }

    public static String getRemoveMarker(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_REMOVE;
            }
            case TEAMS: {
                return "~~";
            }
            case SLACK: {
                return "~";
            }
        }
        return "INVALID";
    }

    public static String getRemoveMarkerClose(PUBLISH_TO publishTo) {
        switch (publishTo) {
            case FEED: {
                return FEED_SPAN_CLOSE;
            }
            case TEAMS: {
                return "~~ ";
            }
            case SLACK: {
                return "~ ";
            }
        }
        return "INVALID";
    }

    public static String getEntityUrl(PUBLISH_TO publishTo, ChangeEvent event) {
        EntityInterface entity = (EntityInterface)event.getEntity();
        URI urlInstance = entity.getHref();
        String fqn = event.getEntityFullyQualifiedName();
        if (Objects.nonNull(urlInstance)) {
            String scheme = urlInstance.getScheme();
            String host = urlInstance.getHost();
            if (publishTo == PUBLISH_TO.SLACK) {
                return String.format("<%s://%s/%s/%s|%s>", scheme, host, event.getEntityType(), fqn, fqn);
            }
            if (publishTo == PUBLISH_TO.TEAMS) {
                return String.format("[%s](%s://%s/%s/%s)", fqn, scheme, host, event.getEntityType(), fqn);
            }
        }
        return "";
    }

    public static SlackMessage buildSlackMessage(ChangeEvent event) {
        SlackMessage slackMessage = new SlackMessage();
        slackMessage.setUsername(event.getUserName());
        if (event.getEntity() != null) {
            String headerTxt = "%s posted on " + event.getEntityType() + " %s";
            String headerText = String.format(headerTxt, event.getUserName(), ChangeEventParser.getEntityUrl(PUBLISH_TO.SLACK, event));
            slackMessage.setText(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PUBLISH_TO.SLACK, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<SlackAttachment> attachmentList = new ArrayList<SlackAttachment>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            SlackAttachment attachment = new SlackAttachment();
            ArrayList<String> mark = new ArrayList<String>();
            mark.add("text");
            attachment.setMarkdownIn(mark);
            attachment.setText(entry.getValue());
            attachmentList.add(attachment);
        }
        slackMessage.setAttachments(attachmentList.toArray(new SlackAttachment[0]));
        return slackMessage;
    }

    public static TeamsMessage buildTeamsMessage(ChangeEvent event) {
        TeamsMessage teamsMessage = new TeamsMessage();
        teamsMessage.setSummary("Change Event From OMD");
        TeamsMessage.Section teamsSections = new TeamsMessage.Section();
        if (event.getEntity() != null) {
            String headerTxt = "%s posted on " + event.getEntityType() + " %s";
            String headerText = String.format(headerTxt, event.getUserName(), ChangeEventParser.getEntityUrl(PUBLISH_TO.TEAMS, event));
            teamsSections.setActivityTitle(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessages(PUBLISH_TO.TEAMS, event.getChangeDescription(), (EntityInterface)event.getEntity());
        ArrayList<TeamsMessage.Section> attachmentList = new ArrayList<TeamsMessage.Section>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            TeamsMessage.Section section = new TeamsMessage.Section();
            section.setActivityTitle(teamsSections.getActivityTitle());
            section.setActivityText(entry.getValue());
            attachmentList.add(section);
        }
        teamsMessage.setSections(attachmentList);
        return teamsMessage;
    }

    public static Map<MessageParser.EntityLink, String> getFormattedMessages(PUBLISH_TO publishTo, ChangeDescription changeDescription, EntityInterface entity) {
        List fieldsUpdated = changeDescription.getFieldsUpdated();
        Map<MessageParser.EntityLink, String> messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, fieldsUpdated, CHANGE_TYPE.UPDATE);
        List fieldsAdded = changeDescription.getFieldsAdded();
        List fieldsDeleted = changeDescription.getFieldsDeleted();
        messages.putAll(ChangeEventParser.mergeAddtionsDeletion(publishTo, entity, fieldsAdded, fieldsDeleted));
        return messages;
    }

    private static Map<MessageParser.EntityLink, String> getFormattedMessagesForAllFieldChange(PUBLISH_TO publishTo, EntityInterface entity, List<FieldChange> fields, CHANGE_TYPE changeType) {
        HashMap<MessageParser.EntityLink, String> messages = new HashMap<MessageParser.EntityLink, String>();
        for (FieldChange field : fields) {
            String message;
            String fieldName = field.getName();
            String newFieldValue = ChangeEventParser.getFieldValue(field.getNewValue());
            String oldFieldValue = ChangeEventParser.getFieldValue(field.getOldValue());
            MessageParser.EntityLink link = ChangeEventParser.getEntityLink(fieldName, entity);
            if (link.getEntityType().equals("testCase") && link.getFieldName().equals("testCaseResult")) {
                message = ChangeEventParser.handleTestCaseResult(publishTo, entity, link, field.getOldValue(), field.getNewValue());
                messages.put(link, message);
                continue;
            }
            if (fieldName.equals("failureDetails")) continue;
            message = ChangeEventParser.createMessageForField(publishTo, link, changeType, fieldName, oldFieldValue, newFieldValue);
            messages.put(link, message);
        }
        return messages;
    }

    public static String getFieldValue(Object fieldValue) {
        if (fieldValue == null || fieldValue.toString().isEmpty()) {
            return "";
        }
        try {
            JsonValue json = JsonUtils.readJson(fieldValue.toString());
            if (json.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray jsonArray = json.asJsonArray();
                ArrayList<String> labels = new ArrayList<String>();
                for (JsonValue item : jsonArray) {
                    if (item.getValueType() == JsonValue.ValueType.OBJECT) {
                        Set keys = item.asJsonObject().keySet();
                        if (keys.contains("tagFQN")) {
                            labels.add(item.asJsonObject().getString("tagFQN"));
                            continue;
                        }
                        if (keys.contains("displayName")) {
                            labels.add(item.asJsonObject().getString("displayName"));
                            continue;
                        }
                        if (!keys.contains("name")) continue;
                        labels.add(item.asJsonObject().getString("name"));
                        continue;
                    }
                    if (item.getValueType() != JsonValue.ValueType.STRING) continue;
                    String label = item.toString().replaceAll("^\"|\"$", "");
                    labels.add(label.strip());
                }
                return String.join((CharSequence)", ", labels);
            }
            if (json.getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject jsonObject = json.asJsonObject();
                Set keys = jsonObject.asJsonObject().keySet();
                if (keys.contains("displayName")) {
                    return jsonObject.asJsonObject().getString("displayName");
                }
                if (keys.contains("name")) {
                    return jsonObject.asJsonObject().getString("name");
                }
            }
        }
        catch (JsonParsingException jsonParsingException) {
            // empty catch block
        }
        return fieldValue.toString();
    }

    private static Map<MessageParser.EntityLink, String> mergeAddtionsDeletion(PUBLISH_TO publishTo, EntityInterface entity, List<FieldChange> addedFields, List<FieldChange> deletedFields) {
        Map<MessageParser.EntityLink, String> messages = new HashMap<MessageParser.EntityLink, String>();
        if (addedFields.isEmpty() || deletedFields.isEmpty()) {
            if (!addedFields.isEmpty()) {
                messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, addedFields, CHANGE_TYPE.ADD);
            } else if (!deletedFields.isEmpty()) {
                messages = ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, deletedFields, CHANGE_TYPE.DELETE);
            }
            return messages;
        }
        for (FieldChange field : deletedFields) {
            Optional<FieldChange> addedField = addedFields.stream().filter(f -> f.getName().equals(field.getName())).findAny();
            if (addedField.isPresent()) {
                String fieldName = field.getName();
                MessageParser.EntityLink link = ChangeEventParser.getEntityLink(fieldName, entity);
                String message = ChangeEventParser.createMessageForField(publishTo, link, CHANGE_TYPE.UPDATE, fieldName, field.getOldValue(), addedField.get().getNewValue());
                messages.put(link, message);
                addedFields = addedFields.stream().filter(f -> !f.equals(addedField.get())).collect(Collectors.toList());
                continue;
            }
            messages.putAll(ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, Collections.singletonList(field), CHANGE_TYPE.DELETE));
        }
        if (!addedFields.isEmpty()) {
            messages.putAll(ChangeEventParser.getFormattedMessagesForAllFieldChange(publishTo, entity, addedFields, CHANGE_TYPE.ADD));
        }
        return messages;
    }

    public static MessageParser.EntityLink getEntityLink(String fieldName, EntityInterface entity) {
        EntityReference entityReference = entity.getEntityReference();
        String entityType = entityReference.getType();
        String entityFQN = entityReference.getFullyQualifiedName();
        String arrayFieldName = null;
        String arrayFieldValue = null;
        if (fieldName.contains(".")) {
            String[] fieldNameParts = FullyQualifiedName.split(fieldName);
            fieldName = fieldNameParts[0];
            if (fieldNameParts.length == 3) {
                arrayFieldName = fieldNameParts[1];
                arrayFieldValue = fieldNameParts[2];
            } else if (fieldNameParts.length == 2) {
                arrayFieldName = fieldNameParts[1];
            }
        }
        return new MessageParser.EntityLink(entityType, entityFQN, fieldName, arrayFieldName, arrayFieldValue);
    }

    private static String createMessageForField(PUBLISH_TO publishTo, MessageParser.EntityLink link, CHANGE_TYPE changeType, String fieldName, Object oldFieldValue, Object newFieldValue) {
        String arrayFieldName = link.getArrayFieldName();
        String arrayFieldValue = link.getArrayFieldValue();
        String message = null;
        String updatedField = fieldName;
        if (arrayFieldValue != null) {
            updatedField = String.format("%s.%s", arrayFieldName, arrayFieldValue);
        } else if (arrayFieldName != null) {
            updatedField = String.format("%s.%s", fieldName, arrayFieldName);
        }
        switch (changeType) {
            case ADD: {
                String fieldValue = ChangeEventParser.getFieldValue(newFieldValue);
                if ("followers".equals(updatedField)) {
                    message = String.format("Followed " + ChangeEventParser.getBold(publishTo) + " `%s`", link.getEntityType(), link.getEntityFQN());
                    break;
                }
                if (fieldValue == null || fieldValue.isEmpty()) break;
                message = String.format("Added " + ChangeEventParser.getBold(publishTo) + ": `%s`", updatedField, fieldValue);
                break;
            }
            case UPDATE: {
                message = ChangeEventParser.getUpdateMessage(publishTo, updatedField, oldFieldValue, newFieldValue);
                break;
            }
            case DELETE: {
                if ("followers".equals(updatedField)) {
                    message = String.format("Unfollowed %s `%s`", link.getEntityType(), link.getEntityFQN());
                    break;
                }
                message = String.format("Deleted " + ChangeEventParser.getBold(publishTo), updatedField);
                break;
            }
        }
        return message;
    }

    private static String getPlainTextUpdateMessage(PUBLISH_TO publishTo, String updatedField, String oldValue, String newValue) {
        String diff = ChangeEventParser.getPlaintextDiff(publishTo, oldValue, newValue);
        if (CommonUtil.nullOrEmpty((String)diff)) {
            return "";
        }
        String field = String.format("Updated %s: %s", ChangeEventParser.getBold(publishTo), diff);
        return String.format(field, updatedField);
    }

    private static String getObjectUpdateMessage(PUBLISH_TO publishTo, String updatedField, JsonObject oldJson, JsonObject newJson) {
        ArrayList<String> labels = new ArrayList<String>();
        Set keys = newJson.keySet();
        for (String key : keys) {
            if (((JsonValue)newJson.get((Object)key)).equals(oldJson.get((Object)key))) continue;
            labels.add(String.format("%s: %s", key, ChangeEventParser.getPlaintextDiff(publishTo, ((JsonValue)oldJson.get((Object)key)).toString(), ((JsonValue)newJson.get((Object)key)).toString())));
        }
        String updates = String.join((CharSequence)ChangeEventParser.getLineBreak(publishTo), labels);
        if (newJson.containsKey((Object)"name")) {
            updatedField = String.format("%s.%s", updatedField, newJson.getString("name"));
        }
        String format = String.format("Updated %s:%s%s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getLineBreak(publishTo), updates);
        return String.format(format, updatedField);
    }

    private static String getUpdateMessage(PUBLISH_TO publishTo, String updatedField, Object oldValue, Object newValue) {
        if (newValue == null) {
            return "";
        }
        if (oldValue == null || oldValue.toString().isEmpty()) {
            String format = String.format("Updated %s to %s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getFieldValue(newValue));
            return String.format(format, updatedField);
        }
        if (updatedField.contains("tags") || updatedField.contains("owner")) {
            return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, ChangeEventParser.getFieldValue(oldValue), ChangeEventParser.getFieldValue(newValue));
        }
        if (!newValue.toString().isEmpty()) {
            try {
                JsonValue newJson = JsonUtils.readJson(newValue.toString());
                JsonValue oldJson = JsonUtils.readJson(oldValue.toString());
                if (newJson.getValueType() == JsonValue.ValueType.ARRAY) {
                    JsonArray newJsonArray = newJson.asJsonArray();
                    JsonArray oldJsonArray = oldJson.asJsonArray();
                    if (newJsonArray.size() == 1 && oldJsonArray.size() == 1) {
                        JsonValue newItem = (JsonValue)newJsonArray.get(0);
                        JsonValue oldItem = (JsonValue)oldJsonArray.get(0);
                        if (newItem.getValueType() == JsonValue.ValueType.OBJECT) {
                            JsonObject newJsonItem = newItem.asJsonObject();
                            JsonObject oldJsonItem = oldItem.asJsonObject();
                            return ChangeEventParser.getObjectUpdateMessage(publishTo, updatedField, oldJsonItem, newJsonItem);
                        }
                        return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, newItem.toString(), oldItem.toString());
                    }
                    return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, ChangeEventParser.getFieldValue(oldValue), ChangeEventParser.getFieldValue(newValue));
                }
                if (newJson.getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject newJsonObject = newJson.asJsonObject();
                    JsonObject oldJsonObject = oldJson.asJsonObject();
                    return ChangeEventParser.getObjectUpdateMessage(publishTo, updatedField, oldJsonObject, newJsonObject);
                }
            }
            catch (JsonParsingException jsonParsingException) {
                // empty catch block
            }
        }
        return ChangeEventParser.getPlainTextUpdateMessage(publishTo, updatedField, oldValue.toString(), newValue.toString());
    }

    public static String handleTestCaseResult(PUBLISH_TO publishTo, EntityInterface entity, MessageParser.EntityLink link, Object oldValue, Object newValue) {
        String testCaseName = entity.getName();
        TestCaseResult result = (TestCaseResult)newValue;
        TestCase testCaseEntity = (TestCase)entity;
        if (result != null) {
            String format = String.format("Test Case %s is %s in %s/%s", ChangeEventParser.getBold(publishTo), ChangeEventParser.getBold(publishTo), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN(), testCaseEntity.getTestSuite().getName());
            return String.format(format, testCaseName, result.getTestCaseStatus());
        }
        String format = String.format("Test Case %s is updated in %s/%s", ChangeEventParser.getBold(publishTo), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN(), testCaseEntity.getTestSuite().getName());
        return String.format(format, testCaseName);
    }

    public static String getPlaintextDiff(PUBLISH_TO publishTo, String oldValue, String newValue) {
        String addMarker = FEED_ADD_MARKER;
        String removeMarker = FEED_REMOVE_MARKER;
        DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(true).mergeOriginalRevised(true).inlineDiffByWord(true).oldTag(f -> removeMarker).newTag(f -> addMarker).build();
        List rows = generator.generateDiffRows(List.of(oldValue), List.of(newValue));
        String diff = null;
        for (DiffRow row : rows) {
            if (diff == null) {
                diff = row.getOldLine();
                continue;
            }
            diff = String.format("%s%n%s", diff, row.getOldLine());
        }
        String spanAdd = ChangeEventParser.getAddMarker(publishTo);
        String spanAddClose = ChangeEventParser.getAddMarkerClose(publishTo);
        String spanRemove = ChangeEventParser.getRemoveMarker(publishTo);
        String spanRemoveClose = ChangeEventParser.getRemoveMarkerClose(publishTo);
        if (diff != null) {
            diff = ChangeEventParser.replaceMarkers(diff, addMarker, spanAdd, spanAddClose);
            diff = ChangeEventParser.replaceMarkers(diff, removeMarker, spanRemove, spanRemoveClose);
        }
        return diff;
    }

    private static String replaceMarkers(String diff, String marker, String openTag, String closeTag) {
        int index = 0;
        while (diff.contains(marker)) {
            String replacement = index % 2 == 0 ? openTag : closeTag;
            diff = diff.replaceFirst(marker, replacement);
            ++index;
        }
        return diff;
    }

    public static enum PUBLISH_TO {
        FEED,
        SLACK,
        TEAMS;

    }

    public static enum CHANGE_TYPE {
        UPDATE,
        ADD,
        DELETE;

    }
}

