/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHolder.class);
    private static ConfigurationHolder INSTANCE = null;
    private final ConcurrentHashMap<ConfigurationType, Object> CONFIG_MAP = new ConcurrentHashMap();

    public void init(OpenMetadataApplicationConfig config) {
        try {
            block9: for (Field field : OpenMetadataApplicationConfig.class.getDeclaredFields()) {
                ConfigurationType configTypeForEnum;
                String configType;
                if (!field.isAnnotationPresent(JsonProperty.class) || (configType = field.getAnnotation(JsonProperty.class).value()) == null || configType.equals("") || (configTypeForEnum = ConfigurationType.fromValue(configType)) == null) continue;
                switch (configTypeForEnum) {
                    case AUTHORIZER_CONFIG: {
                        this.CONFIG_MAP.put(ConfigurationType.AUTHORIZER_CONFIG, config.getAuthorizerConfiguration());
                        continue block9;
                    }
                    case AUTHENTICATION_CONFIG: {
                        this.CONFIG_MAP.put(ConfigurationType.AUTHENTICATION_CONFIG, config.getAuthenticationConfiguration());
                        continue block9;
                    }
                    case SMTP_CONFIG: {
                        this.CONFIG_MAP.put(ConfigurationType.SMTP_CONFIG, config.getSmtpSettings());
                        continue block9;
                    }
                    case ELASTICSEARCH_CONFIG: {
                        if (config.getElasticSearchConfiguration() == null) continue block9;
                        this.CONFIG_MAP.put(ConfigurationType.ELASTICSEARCH_CONFIG, config.getElasticSearchConfiguration());
                        continue block9;
                    }
                    case LOGIN_CONFIG: {
                        this.CONFIG_MAP.put(ConfigurationType.LOGIN_CONFIG, config.getLoginSettings());
                        continue block9;
                    }
                    default: {
                        LOG.error("Invalid Setting Type Given.");
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in initialising Configuration Holder : Reason : {}", (Object)ex.getMessage());
        }
    }

    public static synchronized ConfigurationHolder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationHolder();
        }
        return INSTANCE;
    }

    public <T> T getConfig(ConfigurationType configType, Class<T> clz) throws RuntimeException {
        Object config = this.CONFIG_MAP.get((Object)configType);
        return JsonUtils.convertValue(config, clz);
    }

    public static enum ConfigurationType {
        AUTHORIZER_CONFIG("authorizerConfiguration"),
        AUTHENTICATION_CONFIG("authenticationConfiguration"),
        SMTP_CONFIG("email"),
        ELASTICSEARCH_CONFIG("elasticsearch"),
        LOGIN_CONFIG("login");

        private final String value;

        private ConfigurationType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConfigurationType fromValue(String text) {
            for (ConfigurationType b : ConfigurationType.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

