/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.openmetadata.schema.email.EmailRequest;
import org.openmetadata.schema.email.SmtpSettings;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EmailUtil.class);
    public static final String USERNAME = "userName";
    public static final String ENTITY = "entity";
    public static final String SUPPORT_URL = "supportUrl";
    public static final String EMAIL_TEMPLATE_BASEPATH = "/emailTemplates";
    private static final String EMAIL_VERIFICATION_SUBJECT = "%s: Verify your Email Address (Action Required)";
    public static final String EMAIL_VERIFICATION_LINKKEY = "userEmailTokenVerificationLink";
    public static final String EMAIL_VERIFICATION_TEMPLATE_PATH = "email-verification.ftl";
    private static final String PASSWORD_RESET_SUBJECT = "%s: Reset your Password";
    public static final String PASSWORD_RESET_LINKKEY = "userResetPasswordLink";
    public static final String EXPIRATION_TIME_KEY = "expirationTime";
    public static final String DEFAULT_EXPIRATION_TIME = "60";
    public static final String PASSWORD = "password";
    public static final String APPLICATION_LOGIN_LINK = "applicationLoginLink";
    public static final String PASSWORD_RESET_TEMPLATE_FILE = "reset-link.ftl";
    private static final String ACCOUNT_STATUS_SUBJECT = "%s: Change in Account Status";
    public static final String ACTION_KEY = "action";
    public static final String ACTION_STATUS_KEY = "actionStatus";
    public static final String ACCOUNT_STATUS_TEMPLATE_FILE = "account-activity-change.ftl";
    private static final String INVITE_SUBJECT = "Welcome to %s";
    public static final String INVITE_RANDOM_PWD = "invite-randompwd.ftl";
    public static final String INVITE_CREATE_PWD = "invite-createPassword.ftl";
    private static EmailUtil INSTANCE = null;
    private SmtpSettings defaultSmtpSettings = null;
    private Mailer mailer = null;
    private Configuration templateConfiguration = null;

    private EmailUtil(SmtpSettings smtpServerSettings) {
        try {
            this.defaultSmtpSettings = smtpServerSettings;
            this.mailer = this.createMailer(smtpServerSettings);
            this.templateConfiguration = new Configuration(Configuration.VERSION_2_3_28);
        }
        catch (Exception ex) {
            LOG.error("Error in instantiating [MAILER] : Reason {} ", (Object)ex.getMessage());
        }
    }

    private Mailer createMailer(SmtpSettings smtpServerSettings) {
        TransportStrategy strategy = TransportStrategy.SMTP;
        switch (smtpServerSettings.getTransportationStrategy()) {
            case SMTP: {
                strategy = TransportStrategy.SMTP;
                break;
            }
            case SMPTS: {
                strategy = TransportStrategy.SMTPS;
                break;
            }
            case SMTP_TLS: {
                strategy = TransportStrategy.SMTP_TLS;
            }
        }
        return MailerBuilder.withSMTPServer((String)smtpServerSettings.getServerEndpoint(), (Integer)smtpServerSettings.getServerPort(), (String)smtpServerSettings.getUsername(), (String)smtpServerSettings.getPassword()).withTransportStrategy(strategy).buildMailer();
    }

    public static EmailUtil getInstance() {
        return INSTANCE;
    }

    public Email buildEmailWithSender(EmailRequest request) {
        EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
        if (request.getSenderMail() != null && !request.getSenderMail().equals("") && request.getRecipientMails() != null && request.getRecipientMails().size() != 0 && request.getSubject() != null && !request.getSubject().equals("")) {
            if (request.getSenderName() != null && !request.getSenderName().equals("")) {
                emailBuilder.from(request.getSenderName(), request.getSenderMail());
            } else {
                emailBuilder.from(request.getSenderMail());
            }
            request.getRecipientMails().forEach(pair -> {
                if (pair.getName() != null && !pair.getName().equals("")) {
                    emailBuilder.to(pair.getName(), pair.getEmail());
                } else {
                    emailBuilder.to(pair.getEmail());
                }
            });
            if (request.getCcMails() != null) {
                request.getCcMails().forEach(pair -> {
                    if (pair.getName() != null && !pair.getName().equals("")) {
                        emailBuilder.cc(pair.getName(), pair.getEmail());
                    } else {
                        emailBuilder.cc(pair.getEmail());
                    }
                });
            }
            if (request.getBccMails() != null) {
                request.getBccMails().forEach(pair -> {
                    if (pair.getName() != null && !pair.getName().equals("")) {
                        emailBuilder.bcc(pair.getName(), pair.getEmail());
                    } else {
                        emailBuilder.bcc(pair.getEmail());
                    }
                });
            }
            if (request.getSubject() != null) {
                emailBuilder.withSubject(request.getSubject());
            }
            if (request.getContent() != null) {
                if (request.getContentType() == EmailRequest.ContentType.HTML) {
                    emailBuilder.withHTMLText(request.getContent());
                } else {
                    emailBuilder.withPlainText(request.getContent());
                }
            }
        } else {
            throw new RuntimeException("Email Request is missing Required Details");
        }
        return emailBuilder.buildEmail();
    }

    public Email buildEmailWithDefaultSender(EmailRequest request) {
        EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
        if (request.getRecipientMails() != null && request.getRecipientMails().size() != 0 && request.getSubject() != null && !request.getSubject().equals("")) {
            emailBuilder.from(this.defaultSmtpSettings.getUsername());
            request.getRecipientMails().forEach(pair -> {
                if (pair.getName() != null && !pair.getName().equals("")) {
                    emailBuilder.to(pair.getName(), pair.getEmail());
                } else {
                    emailBuilder.to(pair.getEmail());
                }
            });
            if (request.getCcMails() != null) {
                request.getCcMails().forEach(pair -> {
                    if (pair.getName() != null && !pair.getName().equals("")) {
                        emailBuilder.cc(pair.getName(), pair.getEmail());
                    } else {
                        emailBuilder.cc(pair.getEmail());
                    }
                });
            }
            if (request.getBccMails() != null) {
                request.getBccMails().forEach(pair -> {
                    if (pair.getName() != null && !pair.getName().equals("")) {
                        emailBuilder.bcc(pair.getName(), pair.getEmail());
                    } else {
                        emailBuilder.bcc(pair.getEmail());
                    }
                });
            }
            if (request.getSubject() != null) {
                emailBuilder.withSubject(request.getSubject());
            }
            if (request.getContent() != null) {
                if (request.getContentType() == EmailRequest.ContentType.HTML) {
                    emailBuilder.withHTMLText(request.getContent());
                } else {
                    emailBuilder.withPlainText(request.getContent());
                }
            }
        } else {
            throw new RuntimeException("Email Request is missing Required Details");
        }
        return emailBuilder.buildEmail();
    }

    public void sendMail(String subject, Map<String, String> model, String to, String baseTemplatePackage, String templatePath) throws IOException, TemplateException {
        EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
        emailBuilder.withSubject(subject);
        emailBuilder.to(to);
        emailBuilder.from(this.defaultSmtpSettings.getUsername());
        this.templateConfiguration.setClassForTemplateLoading(this.getClass(), baseTemplatePackage);
        Template template = this.templateConfiguration.getTemplate(templatePath);
        StringWriter stringWriter = new StringWriter();
        template.process(model, (Writer)stringWriter);
        String mailContent = stringWriter.toString();
        emailBuilder.withHTMLText(mailContent);
        this.sendMail(emailBuilder.buildEmail());
    }

    public void sendMail(Email email) {
        if (this.mailer != null) {
            this.mailer.sendMail(email, true);
        }
    }

    public void testConnection() {
        this.mailer.testConnection();
    }

    public void sendMailWithSmtp(Email email, SmtpSettings settings) {
        this.createMailer(settings).sendMail(email);
    }

    public String getEmailVerificationSubject() {
        return String.format(EMAIL_VERIFICATION_SUBJECT, this.defaultSmtpSettings.getEmailingEntity());
    }

    public String getPasswordResetSubject() {
        return String.format(PASSWORD_RESET_SUBJECT, this.defaultSmtpSettings.getEmailingEntity());
    }

    public String getAccountStatusChangeSubject() {
        return String.format(ACCOUNT_STATUS_SUBJECT, this.defaultSmtpSettings.getEmailingEntity());
    }

    public String getEmailInviteSubject() {
        return String.format(INVITE_SUBJECT, this.defaultSmtpSettings.getEmailingEntity());
    }

    public String getEmailingEntity() {
        return this.defaultSmtpSettings.getEmailingEntity();
    }

    public String getSupportUrl() {
        return this.defaultSmtpSettings.getSupportUrl();
    }

    public String getOMUrl() {
        return this.defaultSmtpSettings.getOpenMetadataUrl();
    }

    public static class EmailUtilBuilder {
        private EmailUtilBuilder() {
        }

        public static EmailUtil build(SmtpSettings smtpServerSettings) {
            if (INSTANCE == null) {
                INSTANCE = new EmailUtil(smtpServerSettings);
            }
            return INSTANCE;
        }
    }
}

