/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.filter.EventFilter;
import org.openmetadata.schema.filter.Filters;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FilterUtil.class);
    private static final String TEST_CASE_RESULT = "testCaseResult";
    private static final String WILDCARD_FILTER = "all";

    private FilterUtil() {
    }

    public static boolean shouldProcessRequest(ChangeEvent changeEvent, Map<String, Map<EventType, Filters>> filtersMap) {
        if (filtersMap != null && !filtersMap.isEmpty()) {
            String entityType = changeEvent.getEntityType();
            EventType eventType = changeEvent.getEventType();
            Map<EventType, Filters> filtersOfEntity = filtersMap.get(entityType);
            if (filtersOfEntity == null || filtersOfEntity.size() == 0) {
                return FilterUtil.handleWithWildCardFilter(filtersMap.get(WILDCARD_FILTER), eventType, FilterUtil.getUpdateField(changeEvent));
            }
            Filters sf = filtersOfEntity.get(eventType);
            if (sf == null) {
                return false;
            }
            if (entityType.equals("testCase")) {
                return FilterUtil.handleTestCaseFilter(changeEvent, sf);
            }
            return FilterUtil.checkIfFilterContainField(sf, FilterUtil.getUpdateField(changeEvent));
        }
        return false;
    }

    private static boolean handleTestCaseFilter(ChangeEvent changeEvent, Filters sf) {
        List<FieldChange> fieldChanges = FilterUtil.getAllFieldChange(changeEvent);
        for (FieldChange fieldChange : fieldChanges) {
            if (!fieldChange.getName().equals(TEST_CASE_RESULT) || fieldChange.getNewValue() == null) continue;
            TestCaseResult testCaseResult = (TestCaseResult)fieldChange.getNewValue();
            TestCaseStatus status = testCaseResult.getTestCaseStatus();
            String statusField = TEST_CASE_RESULT + status.toString();
            if (sf.getInclude().contains(statusField)) {
                return true;
            }
            if (!sf.getExclude().contains(statusField)) continue;
            return false;
        }
        return sf.getInclude().contains(WILDCARD_FILTER);
    }

    public static boolean handleWithWildCardFilter(Map<EventType, Filters> wildCardFilter, EventType type, List<String> updatedField) {
        if (wildCardFilter != null && !wildCardFilter.isEmpty()) {
            Filters f = wildCardFilter.get(type);
            return FilterUtil.checkIfFilterContainField(f, updatedField);
        }
        return false;
    }

    public static boolean checkIfFilterContainField(Filters f, List<String> updatedField) {
        if (f != null) {
            for (String changed : updatedField) {
                if (f.getExclude().contains(changed)) {
                    return false;
                }
                if (!f.getInclude().contains(changed)) continue;
                return true;
            }
            return f.getInclude().contains(WILDCARD_FILTER);
        }
        return false;
    }

    public static List<String> getUpdateField(ChangeEvent changeEvent) {
        if (changeEvent.getEventType() == EventType.ENTITY_CREATED || changeEvent.getEventType() == EventType.ENTITY_DELETED || changeEvent.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            return List.of(changeEvent.getEntityType());
        }
        return FilterUtil.getChangedFields(FilterUtil.getAllFieldChange(changeEvent));
    }

    public static List<FieldChange> getAllFieldChange(ChangeEvent changeEvent) {
        ArrayList<FieldChange> allFieldChange = new ArrayList<FieldChange>();
        ChangeDescription description = changeEvent.getChangeDescription();
        if (description != null) {
            allFieldChange.addAll(description.getFieldsAdded());
            allFieldChange.addAll(description.getFieldsUpdated());
            allFieldChange.addAll(description.getFieldsDeleted());
        }
        return allFieldChange;
    }

    public static List<String> getChangedFields(List<FieldChange> field) {
        ArrayList<String> updatedFields = new ArrayList<String>();
        field.forEach(f -> {
            String updatedField = f.getName();
            if (updatedField.contains(".")) {
                String[] arr = updatedField.split("\\.");
                updatedFields.add(arr[arr.length - 1]);
            } else {
                updatedFields.add(updatedField);
            }
        });
        return updatedFields;
    }

    public static Settings updateEntityFilter(Settings oldValue, String entityType, List<Filters> filters) {
        List existingEntityFilter = (List)oldValue.getConfigValue();
        EventFilter entititySpecificFilter = null;
        int position = 0;
        for (EventFilter e : existingEntityFilter) {
            if (e.getEntityType().equals(entityType)) {
                entititySpecificFilter = e;
                break;
            }
            ++position;
        }
        filters.sort(EntityUtil.compareFilters);
        if (entititySpecificFilter != null) {
            entititySpecificFilter.setFilters(filters);
            existingEntityFilter.set(position, entititySpecificFilter);
        } else {
            entititySpecificFilter = new EventFilter();
            entititySpecificFilter.setEntityType(entityType);
            entititySpecificFilter.setFilters(filters);
            existingEntityFilter.add(entititySpecificFilter);
        }
        existingEntityFilter.sort(EntityUtil.compareEventFilters);
        oldValue.setConfigValue((Object)existingEntityFilter);
        return oldValue;
    }

    public static List<EventFilter> getEventFilterFromSettings(Settings setting) throws IOException {
        String json = JsonUtils.pojoToJson(setting.getConfigValue());
        return JsonUtils.readValue(json, new TypeReference<ArrayList<EventFilter>>(){});
    }
}

