/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.util.List;
import org.openmetadata.api.configuration.airflow.SSLConfig;
import org.openmetadata.schema.api.configuration.airflow.AirflowConfiguration;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.BotType;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.schema.teams.authn.JWTAuthMechanism;
import org.openmetadata.schema.teams.authn.SSOAuthMechanism;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataServerConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataServerConnectionBuilder.class);
    OpenMetadataServerConnection.AuthProvider authProvider;
    String bot;
    Object securityConfig;
    private final OpenMetadataServerConnection.VerifySSL verifySSL;
    private final String openMetadataURL;
    private final String clusterName;
    private final SecretsManagerProvider secretsManagerProvider;
    private final Object airflowSSLConfig;
    BotRepository botRepository;
    UserRepository userRepository;
    private final SecretsManager secretsManager;

    public OpenMetadataServerConnectionBuilder(SecretsManager secretsManager, OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        this.secretsManager = secretsManager;
        OpenMetadataServerConnection.AuthProvider authProvider = this.authProvider = "basic".equals(openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider()) ? OpenMetadataServerConnection.AuthProvider.OPENMETADATA : OpenMetadataServerConnection.AuthProvider.fromValue((String)openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider());
        if (!OpenMetadataServerConnection.AuthProvider.NO_AUTH.equals((Object)this.authProvider)) {
            this.botRepository = (BotRepository)BotRepository.class.cast(Entity.getEntityRepository("bot"));
            this.userRepository = (UserRepository)UserRepository.class.cast(Entity.getEntityRepository("user"));
            User botUser = this.retrieveBotUser();
            if (secretsManager.isLocal()) {
                this.securityConfig = this.extractSecurityConfig(botUser);
            }
            this.authProvider = this.extractAuthProvider(botUser);
        }
        AirflowConfiguration airflowConfiguration = openMetadataApplicationConfig.getAirflowConfiguration();
        this.openMetadataURL = airflowConfiguration.getMetadataApiEndpoint();
        this.clusterName = openMetadataApplicationConfig.getClusterName();
        this.secretsManagerProvider = secretsManager.getSecretsManagerProvider();
        this.verifySSL = OpenMetadataServerConnection.VerifySSL.fromValue((String)airflowConfiguration.getVerifySSL());
        this.airflowSSLConfig = this.getAirflowSSLConfig(OpenMetadataServerConnection.VerifySSL.fromValue((String)airflowConfiguration.getVerifySSL()), airflowConfiguration.getSslConfig());
    }

    private OpenMetadataServerConnection.AuthProvider extractAuthProvider(User botUser) {
        AuthenticationMechanism.AuthType authType = botUser.getAuthenticationMechanism().getAuthType();
        switch (authType) {
            case SSO: {
                return OpenMetadataServerConnection.AuthProvider.fromValue((String)JsonUtils.convertValue(botUser.getAuthenticationMechanism().getConfig(), SSOAuthMechanism.class).getSsoServiceType().value());
            }
            case JWT: {
                return OpenMetadataServerConnection.AuthProvider.OPENMETADATA;
            }
        }
        throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authType.value()));
    }

    private Object extractSecurityConfig(User botUser) {
        AuthenticationMechanism authMechanism = botUser.getAuthenticationMechanism();
        switch (botUser.getAuthenticationMechanism().getAuthType()) {
            case SSO: {
                return JsonUtils.convertValue(authMechanism.getConfig(), SSOAuthMechanism.class).getAuthConfig();
            }
            case JWT: {
                JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
                return new OpenMetadataJWTClientConfig().withJwtToken(jwtAuthMechanism.getJWTToken());
            }
        }
        throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authMechanism.getAuthType().value()));
    }

    public OpenMetadataServerConnection build() {
        return new OpenMetadataServerConnection().withAuthProvider(this.authProvider).withHostPort(this.openMetadataURL).withSecurityConfig(this.securityConfig).withVerifySSL(this.verifySSL).withClusterName(this.clusterName).withSecretsManagerProvider(this.secretsManagerProvider).withSslConfig(this.airflowSSLConfig);
    }

    private User retrieveBotUser() {
        User botUser = this.retrieveIngestionBotUser(BotType.INGESTION_BOT.value());
        if (botUser == null) {
            throw new IllegalArgumentException("Please, verify that the ingestion-bot is present.");
        }
        return botUser;
    }

    private User retrieveIngestionBotUser(String botName) {
        try {
            Bot bot1 = (Bot)this.botRepository.getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
            if (bot1.getBotUser() == null) {
                return null;
            }
            User user = (User)this.userRepository.getByName(null, bot1.getBotUser().getFullyQualifiedName(), new EntityUtil.Fields(List.of("authenticationMechanism")));
            if (user.getAuthenticationMechanism() != null) {
                user.getAuthenticationMechanism().setConfig(this.secretsManager.encryptOrDecryptBotUserCredentials(user.getName(), user.getAuthenticationMechanism().getConfig(), false));
            }
            return user;
        }
        catch (IOException | EntityNotFoundException ex) {
            LOG.debug((this.bot == null ? "Bot" : String.format("User for bot [%s]", botName)) + " [{}] not found.", (Object)botName);
            return null;
        }
    }

    protected Object getAirflowSSLConfig(OpenMetadataServerConnection.VerifySSL verifySSL, SSLConfig sslConfig) {
        switch (verifySSL) {
            case NO_SSL: 
            case IGNORE: {
                return null;
            }
            case VALIDATE: {
                return sslConfig.getValidate();
            }
        }
        throw new IllegalArgumentException("OpenMetadata doesn't support SSL verification type " + verifySSL.value());
    }
}

