/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.openmetadata.service.util.ParallelStreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class EventFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EventFilter.class);
    private static final List<String> AUDITABLE_METHODS = Arrays.asList("POST", "PUT", "PATCH", "DELETE");
    private static final int FORK_JOIN_POOL_PARALLELISM = 20;
    private final ForkJoinPool forkJoinPool = new ForkJoinPool(20);
    private final List<EventHandler> eventHandlers = new ArrayList<EventHandler>();

    public EventFilter(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        this.registerEventHandlers(config, jdbi);
    }

    private void registerEventHandlers(OpenMetadataApplicationConfig config, Jdbi jdbi) {
        try {
            HashSet eventHandlerClassNames = new HashSet(config.getEventHandlerConfiguration().getEventHandlerClassNames());
            for (String eventHandlerClassName : eventHandlerClassNames) {
                EventHandler eventHandler = (EventHandler)Class.forName(eventHandlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                eventHandler.init(config, jdbi);
                this.eventHandlers.add(eventHandler);
                LOG.info("Added event handler {}", (Object)eventHandlerClassName);
            }
        }
        catch (Exception e) {
            LOG.info("Exception ", (Throwable)e);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        String method = requestContext.getMethod();
        if (responseCode < 200 || responseCode > 299 || !AUDITABLE_METHODS.contains(method)) {
            return;
        }
        this.eventHandlers.parallelStream().forEach(eventHandler -> ParallelStreamUtil.runAsync(() -> eventHandler.process(requestContext, responseContext), this.forkJoinPool));
    }
}

