/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import com.lmax.disruptor.BatchEventProcessor;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.FailureDetails;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.AbstractEventPublisher;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.WebhookRepository;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookPublisher
extends AbstractEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookPublisher.class);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final Webhook webhook;
    private BatchEventProcessor<EventPubSub.ChangeEventHolder> processor;
    private Client client;
    private final CollectionDAO daoCollection;
    private final WebhookRepository webhookRepository;

    public WebhookPublisher(Webhook webhook, CollectionDAO dao) {
        super(webhook.getBatchSize(), webhook.getEventFilters());
        this.webhook = webhook;
        this.daoCollection = dao;
        this.webhookRepository = new WebhookRepository(dao);
    }

    public void onStart() {
        this.createClient();
        this.webhook.withFailureDetails(new FailureDetails());
        LOG.info("Webhook-lifecycle-onStart {}", (Object)this.webhook.getName());
    }

    public void onShutdown() {
        this.currentBackoffTime = 0;
        this.client.close();
        this.client = null;
        this.shutdownLatch.countDown();
        LOG.info("Webhook-lifecycle-onShutdown {}", (Object)this.webhook.getName());
    }

    public synchronized Webhook getWebhook() {
        return this.webhook;
    }

    public synchronized void updateWebhook(Webhook updatedWebhook) {
        this.currentBackoffTime = 0;
        this.webhook.setDescription(updatedWebhook.getDescription());
        this.webhook.setTimeout(updatedWebhook.getTimeout());
        this.webhook.setBatchSize(updatedWebhook.getBatchSize());
        this.webhook.setEndpoint(updatedWebhook.getEndpoint());
        this.webhook.setEventFilters(updatedWebhook.getEventFilters());
        this.updateFilter();
        this.createClient();
    }

    private void updateFilter() {
        this.filter.clear();
        this.updateFilter(this.webhook.getEventFilters());
    }

    private void setErrorStatus(Long attemptTime, Integer statusCode, String reason) throws IOException {
        if (!attemptTime.equals(this.webhook.getFailureDetails().getLastFailedAt())) {
            this.setStatus(Webhook.Status.FAILED, attemptTime, statusCode, reason, null);
        }
        throw new RuntimeException(reason);
    }

    private void setAwaitingRetry(Long attemptTime, int statusCode, String reason) throws IOException {
        if (!attemptTime.equals(this.webhook.getFailureDetails().getLastFailedAt())) {
            this.setStatus(Webhook.Status.AWAITING_RETRY, attemptTime, statusCode, reason, attemptTime + (long)this.currentBackoffTime);
        }
    }

    private void setStatus(Webhook.Status status, Long attemptTime, Integer statusCode, String reason, Long timestamp) throws IOException {
        Webhook stored = (Webhook)this.daoCollection.webhookDAO().findEntityById(this.webhook.getId());
        this.webhook.setStatus(status);
        this.webhook.getFailureDetails().withLastFailedAt(attemptTime).withLastFailedStatusCode(statusCode).withLastFailedReason(reason).withNextAttempt(timestamp);
        WebhookRepository.WebhookUpdater updater = this.webhookRepository.getUpdater(stored, this.webhook, EntityRepository.Operation.PUT);
        updater.update();
    }

    private synchronized void createClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout(10L, TimeUnit.SECONDS);
        clientBuilder.readTimeout(12L, TimeUnit.SECONDS);
        this.client = clientBuilder.build();
    }

    public void awaitShutdown() throws InterruptedException {
        LOG.info("Awaiting shutdown webhook-lifecycle {}", (Object)this.webhook.getName());
        this.shutdownLatch.await(5L, TimeUnit.SECONDS);
    }

    public void setProcessor(BatchEventProcessor<EventPubSub.ChangeEventHolder> processor) {
        this.processor = processor;
    }

    public BatchEventProcessor<EventPubSub.ChangeEventHolder> getProcessor() {
        return this.processor;
    }

    private Invocation.Builder getTarget() {
        Map<String, String> authHeaders = SecurityUtil.authHeaders("admin@open-metadata.org");
        return SecurityUtil.addHeaders(this.client.target(this.webhook.getEndpoint()), authHeaders);
    }

    @Override
    public void publish(EventResource.ChangeEventList list) throws EventPublisherException, IOException {
        long attemptTime = System.currentTimeMillis();
        try {
            Response response;
            String json = JsonUtils.pojoToJson(list);
            if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)json);
                response = this.getTarget().header("X-OM-Signature", (Object)hmac).post(Entity.json((Object)json));
            } else {
                response = this.getTarget().post(Entity.json((Object)json));
            }
            LOG.info("Webhook {}:{}:{} received response {}", new Object[]{this.webhook.getName(), this.webhook.getStatus(), this.batch.size(), response.getStatusInfo()});
            if (response.getStatus() >= 200 && response.getStatus() < 300) {
                this.webhook.getFailureDetails().setLastSuccessfulAt(((ChangeEvent)this.batch.get(this.batch.size() - 1)).getTimestamp());
                this.batch.clear();
                if (this.webhook.getStatus() != Webhook.Status.ACTIVE) {
                    this.setStatus(Webhook.Status.ACTIVE, null, null, null, null);
                }
            } else if (response.getStatus() >= 300 && response.getStatus() < 400) {
                this.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
            } else if (response.getStatus() >= 300 && response.getStatus() < 600) {
                this.setNextBackOff();
                this.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                Thread.sleep(this.currentBackoffTime);
            }
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause.getClass() == UnknownHostException.class) {
                LOG.warn("Invalid webhook {} endpoint {}", (Object)this.webhook.getName(), (Object)this.webhook.getEndpoint());
                this.setErrorStatus(attemptTime, null, "UnknownHostException");
            }
            LOG.debug("Exception occurred while publishing webhook", (Throwable)ex);
        }
    }
}

