/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartRepository
extends EntityRepository<Chart> {
    private static final Logger LOG = LoggerFactory.getLogger(ChartRepository.class);
    private static final String CHART_UPDATE_FIELDS = "owner";
    private static final String CHART_PATCH_FIELDS = "owner,tags";

    public ChartRepository(CollectionDAO dao) {
        super("v1/charts/", "chart", Chart.class, dao.chartDAO(), dao, CHART_PATCH_FIELDS, CHART_UPDATE_FIELDS);
    }

    @Override
    public void setFullyQualifiedName(Chart chart) {
        chart.setFullyQualifiedName(FullyQualifiedName.add(chart.getService().getName(), chart.getName()));
    }

    @Override
    public void prepare(Chart chart) throws IOException {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(chart.getService(), EntityUtil.Fields.EMPTY_FIELDS, Include.ALL);
        chart.setService(dashboardService.getEntityReference());
        chart.setServiceType(dashboardService.getServiceType());
        this.setFullyQualifiedName(chart);
        chart.setTags(this.addDerivedTags(chart.getTags()));
    }

    @Override
    public void storeEntity(Chart chart, boolean update) throws JsonProcessingException {
        EntityReference owner = chart.getOwner();
        List tags = chart.getTags();
        EntityReference service = chart.getService();
        chart.withOwner(null).withService(null).withHref(null).withTags(null);
        this.store(chart.getId(), chart, update);
        chart.withOwner(owner).withService(service).withTags(tags);
    }

    @Override
    public void storeRelationships(Chart chart) {
        EntityReference service = chart.getService();
        this.addRelationship(service.getId(), chart.getId(), service.getType(), "chart", Relationship.CONTAINS);
        this.storeOwner(chart, chart.getOwner());
        this.applyTags(chart);
    }

    @Override
    public Chart setFields(Chart chart, EntityUtil.Fields fields) throws IOException {
        chart.setService(this.getContainer(chart.getId()));
        chart.setFollowers(fields.contains("followers") ? this.getFollowers(chart) : null);
        return chart;
    }

    @Override
    public void restorePatchAttributes(Chart original, Chart updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }
}

