/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.Type;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Location;
import org.openmetadata.schema.entity.data.Metrics;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Report;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.filter.EventFilter;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagCategory;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.schema.util.EntitiesCount;
import org.openmetadata.schema.util.ServicesCount;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface CollectionDAO {
    @CreateSqlObject
    public DatabaseDAO databaseDAO();

    @CreateSqlObject
    public DatabaseSchemaDAO databaseSchemaDAO();

    @CreateSqlObject
    public EntityRelationshipDAO relationshipDAO();

    @CreateSqlObject
    public FieldRelationshipDAO fieldRelationshipDAO();

    @CreateSqlObject
    public EntityExtensionDAO entityExtensionDAO();

    @CreateSqlObject
    public EntityExtensionTimeSeriesDAO entityExtensionTimeSeriesDao();

    @CreateSqlObject
    public RoleDAO roleDAO();

    @CreateSqlObject
    public UserDAO userDAO();

    @CreateSqlObject
    public TeamDAO teamDAO();

    @CreateSqlObject
    public TagUsageDAO tagUsageDAO();

    @CreateSqlObject
    public TagDAO tagDAO();

    @CreateSqlObject
    public TagCategoryDAO tagCategoryDAO();

    @CreateSqlObject
    public TableDAO tableDAO();

    @CreateSqlObject
    public UsageDAO usageDAO();

    @CreateSqlObject
    public MetricsDAO metricsDAO();

    @CreateSqlObject
    public ChartDAO chartDAO();

    @CreateSqlObject
    public PipelineDAO pipelineDAO();

    @CreateSqlObject
    public DashboardDAO dashboardDAO();

    @CreateSqlObject
    public ReportDAO reportDAO();

    @CreateSqlObject
    public TopicDAO topicDAO();

    @CreateSqlObject
    public MlModelDAO mlModelDAO();

    @CreateSqlObject
    public GlossaryDAO glossaryDAO();

    @CreateSqlObject
    public GlossaryTermDAO glossaryTermDAO();

    @CreateSqlObject
    public BotDAO botDAO();

    @CreateSqlObject
    public PolicyDAO policyDAO();

    @CreateSqlObject
    public IngestionPipelineDAO ingestionPipelineDAO();

    @CreateSqlObject
    public DatabaseServiceDAO dbServiceDAO();

    @CreateSqlObject
    public PipelineServiceDAO pipelineServiceDAO();

    @CreateSqlObject
    public MlModelServiceDAO mlModelServiceDAO();

    @CreateSqlObject
    public DashboardServiceDAO dashboardServiceDAO();

    @CreateSqlObject
    public MessagingServiceDAO messagingServiceDAO();

    @CreateSqlObject
    public StorageServiceDAO storageServiceDAO();

    @CreateSqlObject
    public FeedDAO feedDAO();

    @CreateSqlObject
    public LocationDAO locationDAO();

    @CreateSqlObject
    public ChangeEventDAO changeEventDAO();

    @CreateSqlObject
    public WebhookDAO webhookDAO();

    @CreateSqlObject
    public TypeEntityDAO typeEntityDAO();

    @CreateSqlObject
    public TestDefinitionDAO testDefinitionDAO();

    @CreateSqlObject
    public TestSuiteDAO testSuiteDAO();

    @CreateSqlObject
    public TestCaseDAO testCaseDAO();

    @CreateSqlObject
    public UtilDAO utilDAO();

    @CreateSqlObject
    public SettingsDAO getSettingsDAO();

    @CreateSqlObject
    public TokenDAO getTokenDAO();

    public static interface TokenDAO {
        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE token = :token")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public TokenInterface findByToken(@Bind(value="token") String var1) throws StatementException;

        @SqlQuery(value="SELECT tokenType, json FROM user_tokens WHERE userId = :userId AND tokenType = :tokenType ")
        @RegisterRowMapper(value=TokenRowMapper.class)
        public List<TokenInterface> getAllUserTokenWithType(@Bind(value="userId") String var1, @Bind(value="tokenType") String var2) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO user_tokens (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = :json WHERE token = :token", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE user_tokens SET json = (:json :: jsonb) WHERE token = :token", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="token") String var1, @Bind(value="json") String var2);

        @SqlUpdate(value="DELETE from user_tokens WHERE token = :token")
        public void delete(@Bind(value="token") String var1);

        @SqlUpdate(value="DELETE from user_tokens WHERE userid = :userid AND tokenType = :tokenType")
        public void deleteTokenByUserAndType(@Bind(value="userid") String var1, @Bind(value="tokenType") String var2);
    }

    public static class TokenRowMapper
    implements RowMapper<TokenInterface> {
        public TokenInterface map(ResultSet rs, StatementContext ctx) throws SQLException {
            try {
                return TokenRowMapper.getToken(TokenType.fromValue((String)rs.getString("tokenType")), rs.getString("json"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static TokenInterface getToken(TokenType type, String json) throws IOException {
            TokenInterface resp = null;
            switch (type) {
                case EMAIL_VERIFICATION: {
                    resp = (TokenInterface)JsonUtils.readValue(json, EmailVerificationToken.class);
                    break;
                }
                case PASSWORD_RESET: {
                    resp = (TokenInterface)JsonUtils.readValue(json, PasswordResetToken.class);
                    break;
                }
                case REFRESH_TOKEN: {
                    resp = (TokenInterface)JsonUtils.readValue(json, RefreshToken.class);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Token Type.");
                }
            }
            return resp;
        }
    }

    public static interface SettingsDAO {
        @SqlQuery(value="SELECT configType,json FROM openmetadata_settings")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public List<Settings> getAllConfig() throws StatementException;

        @SqlQuery(value="SELECT configType, json FROM openmetadata_settings WHERE configType = :configType")
        @RegisterRowMapper(value=SettingsRowMapper.class)
        public Settings getConfigWithKey(@Bind(value="configType") String var1) throws StatementException;

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT into openmetadata_settings (configType, json)VALUES (:configType, :json :: jsonb) ON CONFLICT (configType) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insertSettings(@Bind(value="configType") String var1, @Bind(value="json") String var2);
    }

    public static class SettingsRowMapper
    implements RowMapper<Settings> {
        public Settings map(ResultSet rs, StatementContext ctx) throws SQLException {
            return SettingsRowMapper.getSettings(SettingsType.fromValue((String)rs.getString("configType")), rs.getString("json"));
        }

        public static Settings getSettings(SettingsType configType, String json) {
            Settings settings = new Settings();
            settings.setConfigType(configType);
            ArrayList<EventFilter> value = null;
            try {
                if (configType != SettingsType.ACTIVITY_FEED_FILTER_SETTING) {
                    throw new RuntimeException("Invalid Settings Type");
                }
                value = JsonUtils.readValue(json, new TypeReference<ArrayList<EventFilter>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            settings.setConfigValue(value);
            return settings;
        }
    }

    public static interface UtilDAO {
        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM table_entity <cond>) as tableCount, (SELECT COUNT(*) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(*) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(*) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(*) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT (SELECT COUNT(*) FROM database_entity <cond>) + (SELECT COUNT(*) FROM messaging_service_entity <cond>)+ (SELECT COUNT(*) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(*) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(*) FROM mlmodel_service_entity <cond>)) as servicesCount, (SELECT COUNT(*) FROM user_entity <cond> AND (JSON_EXTRACT(json, '$.isBot') IS NULL OR JSON_EXTRACT(json, '$.isBot') = FALSE)) as userCount, (SELECT COUNT(*) FROM team_entity <cond>) as teamCount, (SELECT COUNT(*) FROM test_suite <cond>) as testSuiteCount", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT (SELECT COUNT(*) FROM table_entity <cond>) as tableCount, (SELECT COUNT(*) FROM topic_entity <cond>) as topicCount, (SELECT COUNT(*) FROM dashboard_entity <cond>) as dashboardCount, (SELECT COUNT(*) FROM pipeline_entity <cond>) as pipelineCount, (SELECT COUNT(*) FROM ml_model_entity <cond>) as mlmodelCount, (SELECT (SELECT COUNT(*) FROM database_entity <cond>) + (SELECT COUNT(*) FROM messaging_service_entity <cond>)+ (SELECT COUNT(*) FROM dashboard_service_entity <cond>)+ (SELECT COUNT(*) FROM pipeline_service_entity <cond>)+ (SELECT COUNT(*) FROM mlmodel_service_entity <cond>)) as servicesCount, (SELECT COUNT(*) FROM user_entity <cond> AND (json#>'{isBot}' IS NULL OR ((json#>'{isBot}')::boolean) = FALSE)) as userCount, (SELECT COUNT(*) FROM team_entity <cond>) as teamCount, (SELECT COUNT(*) FROM test_suite <cond>  ) as testSuiteCount", connectionType=ConnectionType.POSTGRES)})
        @RegisterRowMapper(value=EntitiesCountRowMapper.class)
        public EntitiesCount getAggregatedEntitiesCount(@Define(value="cond") String var1) throws StatementException;

        @SqlQuery(value="SELECT (SELECT COUNT(*) FROM database_entity <cond>) as databaseServiceCount, (SELECT COUNT(*) FROM messaging_service_entity <cond>) as messagingServiceCount, (SELECT COUNT(*) FROM dashboard_service_entity <cond>) as dashboardServiceCount, (SELECT COUNT(*) FROM pipeline_service_entity <cond>) as pipelineServiceCount, (SELECT COUNT(*) FROM mlmodel_service_entity <cond>) as mlModelServiceCount")
        @RegisterRowMapper(value=ServicesCountRowMapper.class)
        public ServicesCount getAggregatedServicesCount(@Define(value="cond") String var1) throws StatementException;
    }

    public static class ServicesCountRowMapper
    implements RowMapper<ServicesCount> {
        public ServicesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ServicesCount().withDatabaseServiceCount(Integer.valueOf(rs.getInt("databaseServiceCount"))).withMessagingServiceCount(Integer.valueOf(rs.getInt("messagingServiceCount"))).withDashboardServiceCount(Integer.valueOf(rs.getInt("dashboardServiceCount"))).withPipelineServiceCounte(Integer.valueOf(rs.getInt("pipelineServiceCount"))).withMlModelServiceCount(Integer.valueOf(rs.getInt("mlModelServiceCount")));
        }
    }

    public static class EntitiesCountRowMapper
    implements RowMapper<EntitiesCount> {
        public EntitiesCount map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new EntitiesCount().withTableCount(Integer.valueOf(rs.getInt("tableCount"))).withTopicCount(Integer.valueOf(rs.getInt("topicCount"))).withDashboardCount(Integer.valueOf(rs.getInt("dashboardCount"))).withPipelineCount(Integer.valueOf(rs.getInt("pipelineCount"))).withMlmodelCount(Integer.valueOf(rs.getInt("mlmodelCount"))).withServicesCount(Integer.valueOf(rs.getInt("servicesCount"))).withUserCount(Integer.valueOf(rs.getInt("userCount"))).withTeamCount(Integer.valueOf(rs.getInt("teamCount"))).withTestSuiteCount(Integer.valueOf(rs.getInt("testSuiteCount")));
        }
    }

    public static interface EntityExtensionTimeSeriesDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension_time_series(entityFQN, extension, jsonSchema, json) VALUES (:entityFQN, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension_time_series(entityFQN, extension, jsonSchema, json) VALUES (:entityFQN, :extension, :jsonSchema, (:json :: jsonb))", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = :json where entityFQN=:entityFQN and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_extension_time_series set json = (:json :: jsonb) where entityFQN=:entityFQN and extension=:extension and timestamp=:timestamp", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="json") String var3, @Bind(value="timestamp") Long var4);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension")
        public String getExtension(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension AND timestamp = :timestamp")
        public String getExtensionAtTimestamp(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") long var3);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension ORDER BY timestamp DESC LIMIT 1")
        public String getLatestExtension(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension ORDER BY timestamp DESC LIMIT :limit")
        public List<String> getLastLatestExtension(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="limit") int var3);

        @RegisterRowMapper(value=ExtensionMapper.class)
        @SqlQuery(value="SELECT extension, json FROM entity_extension WHERE id = :id AND extension LIKE CONCAT (:extensionPrefix, '.%') ORDER BY extension")
        public List<ExtensionRecord> getExtensions(@Bind(value="id") String var1, @Bind(value="extensionPrefix") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension")
        public void delete(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQN = :entityFQN")
        public void deleteAll(@Bind(value="entityFQN") String var1);

        @SqlUpdate(value="DELETE FROM entity_extension_time_series WHERE entityFQN = :entityFQN AND extension = :extension AND timestamp = :timestamp")
        public void deleteAtTimestamp(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="timestamp") Long var3);

        @SqlQuery(value="SELECT json FROM entity_extension_time_series where entityFQN = :entityFQN and extension = :extension  AND timestamp >= :startTs and timestamp <= :endTs ORDER BY timestamp DESC")
        public List<String> listBetweenTimestamps(@Bind(value="entityFQN") String var1, @Bind(value="extension") String var2, @Bind(value="startTs") Long var3, @Bind(value="endTs") long var4);
    }

    public static interface TestCaseDAO
    extends EntityDAO<TestCase> {
        @Override
        default public String getTableName() {
            return "test_case";
        }

        @Override
        default public Class<TestCase> getEntityClass() {
            return TestCase.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityFQN = filter.getQueryParam("entityFQN");
            String testSuiteId = filter.getQueryParam("testSuiteId");
            boolean includeAllTests = Boolean.parseBoolean(filter.getQueryParam("includeAllTests"));
            String condition = filter.getCondition();
            if (entityFQN == null && testSuiteId == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            if (entityFQN != null) {
                condition = includeAllTests ? String.format("%s AND entityFQN LIKE %s OR entityFQN = '%s'", condition, entityFQN + ".%", entityFQN) : String.format("%s AND entityFQN = '%s') ", condition, entityFQN);
            }
            if (testSuiteId != null) {
                condition = String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND toEntity='%s' AND relation=%d AND fromEntity='%s')", condition, testSuiteId, "testCase", Relationship.CONTAINS.ordinal(), "testSuite");
            }
            return this.listBefore(this.getTableName(), this.getNameColumn(), condition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityFQN = filter.getQueryParam("entityFQN");
            String testSuiteId = filter.getQueryParam("testSuiteId");
            boolean includeAllTests = Boolean.parseBoolean(filter.getQueryParam("includeAllTests"));
            String condition = filter.getCondition();
            if (entityFQN == null && testSuiteId == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            if (entityFQN != null) {
                condition = includeAllTests ? String.format("%s AND entityFQN LIKE '%s' OR entityFQN = '%s'", condition, entityFQN + ".%", entityFQN) : String.format("%s AND entityFQN = '%s'", condition, entityFQN);
            }
            if (testSuiteId != null) {
                condition = String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND toEntity='%s' AND relation=%d AND fromEntity='%s')", condition, testSuiteId, "testCase", Relationship.CONTAINS.ordinal(), "testSuite");
            }
            return this.listAfter(this.getTableName(), this.getNameColumn(), condition, limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityFQN = filter.getQueryParam("entityFQN");
            String testSuiteId = filter.getQueryParam("testSuiteId");
            boolean includeAllTests = Boolean.parseBoolean(filter.getQueryParam("includeAllTests"));
            String condition = filter.getCondition();
            if (entityFQN == null && testSuiteId == null) {
                return EntityDAO.super.listCount(filter);
            }
            if (entityFQN != null) {
                condition = includeAllTests ? String.format("%s AND entityFQN LIKE '%s' OR entityFQN = '%s'", condition, entityFQN + ".%", entityFQN) : String.format("%s AND entityFQN = '%s'", condition, entityFQN);
            }
            if (testSuiteId != null) {
                condition = String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND toEntity='%s' AND relation=%d AND fromEntity='%s')", condition, testSuiteId, "testCase", Relationship.CONTAINS.ordinal(), "testSuite");
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), condition);
        }
    }

    public static interface TestSuiteDAO
    extends EntityDAO<TestSuite> {
        @Override
        default public String getTableName() {
            return "test_suite";
        }

        @Override
        default public Class<TestSuite> getEntityClass() {
            return TestSuite.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface TestDefinitionDAO
    extends EntityDAO<TestDefinition> {
        @Override
        default public String getTableName() {
            return "test_definition";
        }

        @Override
        default public Class<TestDefinition> getEntityClass() {
            return TestDefinition.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listBefore(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString(), limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listAfter(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString(), limit, after);
        }

        @Override
        default public int listCount(ListFilter filter) {
            String entityType = filter.getQueryParam("entityType");
            String testPlatform = filter.getQueryParam("testPlatform");
            String supportedDataType = filter.getQueryParam("supportedDataType");
            String condition = filter.getCondition();
            if (entityType == null && testPlatform == null && supportedDataType == null) {
                return EntityDAO.super.listCount(filter);
            }
            StringBuilder mysqlCondition = new StringBuilder();
            StringBuilder psqlCondition = new StringBuilder();
            mysqlCondition.append(String.format("%s ", condition));
            psqlCondition.append(String.format("%s ", condition));
            if (testPlatform != null) {
                mysqlCondition.append(String.format("AND json_extract(json, '$.testPlatforms') LIKE '%%%s%%' ", testPlatform));
                psqlCondition.append(String.format("AND json->>'testPlatforms' LIKE '%%%s%%' ", testPlatform));
            }
            if (entityType != null) {
                mysqlCondition.append(String.format("AND entityType='%s' ", entityType));
                psqlCondition.append(String.format("AND entityType='%s' ", entityType));
            }
            if (supportedDataType != null) {
                mysqlCondition.append(String.format("AND supported_data_types LIKE '%%%s%%' ", supportedDataType));
                String psqlStr = String.format("AND supported_data_types @> '`%s`' ", supportedDataType);
                psqlCondition.append(psqlStr.replace('`', '\"'));
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mysqlCondition.toString(), psqlCondition.toString());
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <mysqlCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <psqlCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> <mysqlCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> <psqlCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <psqlCond>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="psqlCond") String var4);
    }

    public static interface TypeEntityDAO
    extends EntityDAO<Type> {
        @Override
        default public String getTableName() {
            return "type_entity";
        }

        @Override
        default public Class<Type> getEntityClass() {
            return Type.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }
    }

    public static interface ChangeEventDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO change_event (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlUpdate(value="DELETE FROM change_event WHERE entityType = :entityType")
        public void deleteAll(@Bind(value="entityType") String var1);

        default public List<String> list(String eventType, List<String> entityTypes, long timestamp) {
            if (CommonUtil.nullOrEmpty(entityTypes)) {
                return Collections.emptyList();
            }
            if (entityTypes.get(0).equals("*")) {
                return this.listWithoutEntityFilter(eventType, timestamp);
            }
            return this.listWithEntityFilter(eventType, entityTypes, timestamp);
        }

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND (entityType IN (<entityTypes>)) AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithEntityFilter(@Bind(value="eventType") String var1, @BindList(value="entityTypes") List<String> var2, @Bind(value="timestamp") long var3);

        @SqlQuery(value="SELECT json FROM change_event WHERE eventType = :eventType AND eventTime >= :timestamp ORDER BY eventTime ASC")
        public List<String> listWithoutEntityFilter(@Bind(value="eventType") String var1, @Bind(value="timestamp") long var2);
    }

    public static interface UserDAO
    extends EntityDAO<User> {
        @Override
        default public String getTableName() {
            return "user_entity";
        }

        @Override
        default public Class<User> getEntityClass() {
            return User.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String team = filter.getQueryParam("team");
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean)  = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listCount(filter);
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String team = filter.getQueryParam("team");
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listBefore(filter, limit, before);
            }
            return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, limit, before, Relationship.HAS.ordinal());
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String team = filter.getQueryParam("team");
            String isBotStr = filter.getQueryParam("isBot");
            String isAdminStr = filter.getQueryParam("isAdmin");
            String mySqlCondition = filter.getCondition("ue");
            String postgresCondition = filter.getCondition("ue");
            if (isAdminStr != null) {
                boolean isAdmin = Boolean.parseBoolean(isAdminStr);
                if (isAdmin) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isAdmin') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isAdmin}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isAdmin') IS NULL OR JSON_EXTRACT(ue.json, '$.isAdmin') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND (ue.json#>'{isAdmin}' IS NULL OR ((ue.json#>'{isAdmin}')::boolean) = FALSE ) ", postgresCondition);
                }
            }
            if (isBotStr != null) {
                boolean isBot = Boolean.parseBoolean(isBotStr);
                if (isBot) {
                    mySqlCondition = String.format("%s AND JSON_EXTRACT(ue.json, '$.isBot') = TRUE ", mySqlCondition);
                    postgresCondition = String.format("%s AND ((ue.json#>'{isBot}')::boolean) = TRUE ", postgresCondition);
                } else {
                    mySqlCondition = String.format("%s AND (JSON_EXTRACT(ue.json, '$.isBot') IS NULL OR JSON_EXTRACT(ue.json, '$.isBot') = FALSE ) ", mySqlCondition);
                    postgresCondition = String.format("%s AND ue.json#>'{isBot}' IS NULL OR ((ue.json#>'{isBot}')::boolean) = FALSE ", postgresCondition);
                }
            }
            if (team == null && isAdminStr == null && isBotStr == null) {
                return EntityDAO.super.listAfter(filter, limit, after);
            }
            return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, team, limit, after, Relationship.HAS.ordinal());
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond>  AND (:team IS NULL OR te.name = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM (SELECT ue.id FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond>  AND (:team IS NULL OR te.name = :team) GROUP BY ue.id) subquery", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="relation") int var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.<nameColumn>, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.name = :team) AND ue.<nameColumn> < :before GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT ue.<nameColumn>, ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.name = :team) AND ue.<nameColumn> < :before GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="limit") int var6, @Bind(value="before") String var7, @Bind(value="relation") int var8);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <mysqlCond> AND (:team IS NULL OR te.name = :team) AND ue.<nameColumn> > :after GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT ue.json FROM user_entity ue LEFT JOIN entity_relationship er on ue.id = er.toId LEFT JOIN team_entity te on te.id = er.fromId and er.relation = :relation  <postgresCond> AND (:team IS NULL OR te.name = :team) AND ue.<nameColumn> > :after GROUP BY ue.<nameColumn>, ue.json ORDER BY ue.<nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="team") String var5, @Bind(value="limit") int var6, @Bind(value="after") String var7, @Bind(value="relation") int var8);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM user_entity WHERE email = :email", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM user_entity WHERE email = :email", connectionType=ConnectionType.POSTGRES)})
        public int checkEmailExists(@Bind(value="email") String var1);

        @SqlQuery(value="SELECT json FROM user_entity WHERE email = :email")
        public String findUserByEmail(@Bind(value="email") String var1);
    }

    @RegisterRowMapper(value=UsageDetailsMapper.class)
    public static interface UsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY))", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days'))", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="date") String var1, @Bind(value="id") String var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT :date, :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 6 DAY)), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL 29 DAY)) ON DUPLICATE KEY UPDATE count1 = count1 + :count1, count7 = count7 + :count1, count30 = count30 + :count1", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_usage (usageDate, id, entityType, count1, count7, count30) SELECT (:date :: date), :id, :entityType, :count1, (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '6 days')), (:count1 + (SELECT COALESCE(SUM(count1), 0) FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - INTERVAL '29 days')) ON CONFLICT (usageDate, id) DO UPDATE SET count1 = entity_usage.count1 + :count1, count7 = entity_usage.count7 + :count1, count30 = entity_usage.count30 + :count1", connectionType=ConnectionType.POSTGRES)})
        public void insertOrUpdateCount(@Bind(value="date") String var1, @Bind(value="id") String var2, @Bind(value="entityType") String var3, @Bind(value="count1") int var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= :date - INTERVAL :days DAY AND usageDate <= :date ORDER BY usageDate DESC", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE id = :id AND usageDate >= (:date :: date) - make_interval(days => :days) AND usageDate <= (:date :: date) ORDER BY usageDate DESC", connectionType=ConnectionType.POSTGRES)})
        public List<UsageDetails> getUsageById(@Bind(value="id") String var1, @Bind(value="date") String var2, @Bind(value="days") int var3);

        @SqlQuery(value="SELECT id, usageDate, entityType, count1, count7, count30, percentile1, percentile7, percentile30 FROM entity_usage WHERE usageDate IN (SELECT MAX(usageDate) FROM entity_usage WHERE id = :id) AND id = :id")
        public UsageDetails getLatestUsage(@Bind(value="id") String var1);

        @SqlUpdate(value="DELETE FROM entity_usage WHERE id = :id")
        public void delete(@Bind(value="id") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE entity_usage u JOIN ( SELECT u1.id, (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 <  u1.count1 AND u2.entityType = :entityType AND u2.usageDate = :date) as p1, (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 <  u1.count7 AND u3.entityType = :entityType AND u3.usageDate = :date) as p7, (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 <  u1.count30 AND u4.entityType = :entityType AND u4.usageDate = :date) as p30, (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = :date) as total FROM entity_usage u1 WHERE u1.entityType = :entityType AND u1.usageDate = :date) vals ON u.id = vals.id AND usageDate = :date SET u.percentile1 = ROUND(100 * p1/total, 2), u.percentile7 = ROUND(p7 * 100/total, 2), u.percentile30 = ROUND(p30*100/total, 2)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE entity_usage u SET percentile1 = ROUND(100 * p1 / total, 2), percentile7 = ROUND(p7 * 100 / total, 2), percentile30 = ROUND(p30 * 100 / total, 2) FROM (   SELECT u1.id,        (SELECT COUNT(*) FROM entity_usage as u2 WHERE u2.count1 < u1.count1 AND u2.entityType = :entityType AND u2.usageDate = (:date :: date)) as p1,        (SELECT COUNT(*) FROM entity_usage as u3 WHERE u3.count7 < u1.count7 AND u3.entityType = :entityType AND u3.usageDate = (:date :: date)) as p7,        (SELECT COUNT(*) FROM entity_usage as u4 WHERE u4.count30 < u1.count30 AND u4.entityType = :entityType AND u4.usageDate = (:date :: date)) as p30,        (SELECT COUNT(*) FROM entity_usage WHERE entityType = :entityType AND usageDate = (:date :: date)   ) as total FROM entity_usage u1    WHERE u1.entityType = :entityType AND u1.usageDate = (:date :: date)) vals WHERE u.id = vals.id AND usageDate = (:date :: date);", connectionType=ConnectionType.POSTGRES)})
        public void computePercentile(@Bind(value="entityType") String var1, @Bind(value="date") String var2);

        public static class UsageDetailsMapper
        implements RowMapper<UsageDetails> {
            public UsageDetails map(ResultSet r, StatementContext ctx) throws SQLException {
                UsageStats dailyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count1"))).withPercentileRank(Double.valueOf(r.getDouble("percentile1")));
                UsageStats weeklyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count7"))).withPercentileRank(Double.valueOf(r.getDouble("percentile7")));
                UsageStats monthlyStats = new UsageStats().withCount(Integer.valueOf(r.getInt("count30"))).withPercentileRank(Double.valueOf(r.getDouble("percentile30")));
                return new UsageDetails().withDate(r.getString("usageDate")).withDailyStats(dailyStats).withWeeklyStats(weeklyStats).withMonthlyStats(monthlyStats);
            }
        }
    }

    public static interface TopicDAO
    extends EntityDAO<Topic> {
        @Override
        default public String getTableName() {
            return "topic_entity";
        }

        @Override
        default public Class<Topic> getEntityClass() {
            return Topic.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface TeamDAO
    extends EntityDAO<Team> {
        @Override
        default public String getTableName() {
            return "team_entity";
        }

        @Override
        default public Class<Team> getEntityClass() {
            return Team.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public int listCount(ListFilter filter) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            return this.listCount(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition);
        }

        @Override
        default public List<String> listBefore(ListFilter filter, int limit, String before) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam);
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            before = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(before) : before;
            return this.listBefore(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, before);
        }

        @Override
        default public List<String> listAfter(ListFilter filter, int limit, String after) {
            String parentTeam = filter.getQueryParam("parentTeam");
            String isJoinable = filter.getQueryParam("isJoinable");
            String condition = filter.getCondition();
            if (parentTeam != null) {
                Team team = (Team)this.findEntityByName(parentTeam, filter.getInclude());
                condition = "Organization".equals(team.getName()) ? String.format("%s AND id NOT IN ( (SELECT '%s') UNION (SELECT toId FROM entity_relationship WHERE fromId!='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d) )", condition, team.getId(), team.getId(), Relationship.PARENT_OF.ordinal()) : String.format("%s AND id IN (SELECT toId FROM entity_relationship WHERE fromId='%s' AND fromEntity='team' AND toEntity='team' AND relation=%d)", condition, team.getId(), Relationship.PARENT_OF.ordinal());
            }
            String mySqlCondition = condition;
            String postgresCondition = condition;
            if (isJoinable != null) {
                mySqlCondition = String.format("%s AND JSON_EXTRACT(json, '$.isJoinable') = %s ", mySqlCondition, isJoinable);
                postgresCondition = String.format("%s AND ((json#>'{isJoinable}')::boolean)  = %s ", postgresCondition, isJoinable);
            }
            after = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(after) : after;
            return this.listAfter(this.getTableName(), this.getNameColumn(), mySqlCondition, postgresCondition, limit, after);
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <postgresCond>", connectionType=ConnectionType.POSTGRES)})
        public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <mysqlCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <postgresCond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>", connectionType=ConnectionType.POSTGRES)})
        public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM <table> <mysqlCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM <table> <postgresCond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6);

        default public List<String> listUsersUnderOrganization(String teamId) {
            return this.listUsersUnderOrganization(teamId, Relationship.HAS.ordinal());
        }

        default public List<String> listTeamsUnderOrganization(String teamId) {
            return this.listTeamsUnderOrganization(teamId, Relationship.PARENT_OF.ordinal());
        }

        @SqlQuery(value="SELECT ue.id FROM user_entity ue WHERE ue.id NOT IN (SELECT :teamId) UNION (SELECT toId FROM entity_relationship WHERE fromId != :teamId AND fromEntity = `team` AND relation = :relation AND toEntity = `user`)")
        public List<String> listUsersUnderOrganization(@Bind(value="teamId") String var1, @Bind(value="relation") int var2);

        @SqlQuery(value="SELECT te.id FROM team_entity te WHERE te.id NOT IN (SELECT :teamId) UNION (SELECT toId FROM entity_relationship WHERE fromId != :teamId AND fromEntity = 'team' AND relation = :relation AND toEntity = 'team')")
        public List<String> listTeamsUnderOrganization(@Bind(value="teamId") String var1, @Bind(value="relation") int var2);
    }

    public static interface RoleDAO
    extends EntityDAO<Role> {
        @Override
        default public String getTableName() {
            return "role_entity";
        }

        @Override
        default public Class<Role> getEntityClass() {
            return Role.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    @RegisterRowMapper(value=TagLabelMapper.class)
    public static interface TagUsageDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO tag_usage (source, tagFQN, targetFQN, labelType, state) VALUES (:source, :tagFQN, :targetFQN, :labelType, :state)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO tag_usage (source, tagFQN, targetFQN, labelType, state) VALUES (:source, :tagFQN, :targetFQN, :labelType, :state) ON CONFLICT (source, tagFQN, targetFQN) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void applyTag(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2, @Bind(value="targetFQN") String var3, @Bind(value="labelType") int var4, @Bind(value="state") int var5);

        @SqlQuery(value="SELECT targetFQN FROM tag_usage WHERE tagFQN = :tagFQN")
        public List<String> tagTargetFQN(@Bind(value="tagFQN") String var1);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT tu.source, tu.tagFQN, tu.labelType, tu.state, t.json ->> '$.description' AS description1, g.json ->> '$.description' AS description2 FROM tag_usage tu LEFT JOIN tag t ON tu.tagFQN = t.fullyQualifiedName AND tu.source = 0 LEFT JOIN glossary_term_entity g ON tu.tagFQN = g.fullyQualifiedName AND tu.source = 1 WHERE tu.targetFQN = :targetFQN ORDER BY tu.tagFQN", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT tu.source, tu.tagFQN, tu.labelType, tu.state, t.json ->> 'description' AS description1, g.json ->> 'description' AS description2 FROM tag_usage tu LEFT JOIN tag t ON tu.tagFQN = t.fullyQualifiedName AND tu.source = 0 LEFT JOIN glossary_term_entity g ON tu.tagFQN = g.fullyQualifiedName AND tu.source = 1 WHERE tu.targetFQN = :targetFQN ORDER BY tu.tagFQN", connectionType=ConnectionType.POSTGRES)})
        public List<TagLabel> getTags(@Bind(value="targetFQN") String var1);

        @SqlQuery(value="SELECT COUNT(*) FROM tag_usage WHERE tagFQN LIKE CONCAT(:fqnPrefix, '%') AND source = :source")
        public int getTagCount(@Bind(value="source") int var1, @Bind(value="fqnPrefix") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQN = :targetFQN")
        public void deleteTagsByTarget(@Bind(value="targetFQN") String var1);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQN = :tagFQN AND source = :source")
        public void deleteTagLabels(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where tagFQN LIKE CONCAT(:tagFQN, '.%') AND source = :source")
        public void deleteTagLabelsByPrefix(@Bind(value="source") int var1, @Bind(value="tagFQN") String var2);

        @SqlUpdate(value="DELETE FROM tag_usage where targetFQN LIKE CONCAT(:targetFQN, '%')")
        public void deleteTagLabelsByTargetPrefix(@Bind(value="targetFQN") String var1);

        public static class TagLabelMapper
        implements RowMapper<TagLabel> {
            public TagLabel map(ResultSet r, StatementContext ctx) throws SQLException {
                String description1 = r.getString("description1");
                String description2 = r.getString("description2");
                return new TagLabel().withSource(TagLabel.TagSource.values()[r.getInt("source")]).withLabelType(TagLabel.LabelType.values()[r.getInt("labelType")]).withState(TagLabel.State.values()[r.getInt("state")]).withTagFQN(r.getString("tagFQN")).withDescription(description1 == null ? description2 : description1);
            }
        }
    }

    public static interface TagDAO
    extends EntityDAO<Tag> {
        @Override
        default public String getTableName() {
            return "tag";
        }

        @Override
        default public Class<Tag> getEntityClass() {
            return Tag.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }

        @SqlUpdate(value="DELETE FROM tag where fullyQualifiedName LIKE CONCAT(:fqnPrefix, '.%')")
        public void deleteTagsByPrefix(@Bind(value="fqnPrefix") String var1);
    }

    public static interface TagCategoryDAO
    extends EntityDAO<TagCategory> {
        @Override
        default public String getTableName() {
            return "tag_category";
        }

        @Override
        default public Class<TagCategory> getEntityClass() {
            return TagCategory.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface WebhookDAO
    extends EntityDAO<Webhook> {
        @Override
        default public String getTableName() {
            return "webhook_entity";
        }

        @Override
        default public Class<Webhook> getEntityClass() {
            return Webhook.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public boolean supportsSoftDelete() {
            return false;
        }

        @SqlQuery(value="SELECT json FROM <table>")
        public List<String> listAllWebhooks(@Define(value="table") String var1);
    }

    public static interface PipelineDAO
    extends EntityDAO<Pipeline> {
        @Override
        default public String getTableName() {
            return "pipeline_entity";
        }

        @Override
        default public Class<Pipeline> getEntityClass() {
            return Pipeline.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface LocationDAO
    extends EntityDAO<Location> {
        @Override
        default public String getTableName() {
            return "location_entity";
        }

        @Override
        default public Class<Location> getEntityClass() {
            return Location.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }

        default public int listPrefixesCount(String table, String nameColumn, String fqn, String service) {
            return this.listPrefixesCountInternal(table, nameColumn, fqn, service + ".");
        }

        @SqlQuery(value="SELECT count(*) FROM <table> WHERE LEFT(:fqn, LENGTH(<nameColumn>)) = <nameColumn> AND <nameColumn> >= :servicePrefix AND <nameColumn> <= :fqn")
        public int listPrefixesCountInternal(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="fqn") String var3, @Bind(value="servicePrefix") String var4);

        default public List<String> listPrefixesBefore(String table, String nameColumn, String fqn, String service, int limit, String before) {
            return this.listPrefixesBeforeInternal(table, nameColumn, fqn, service + ".", limit, before);
        }

        @SqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> WHERE LEFT(:fqn, LENGTH(<nameColumn>)) = <nameColumn> AND <nameColumn> >= servicePrefix AND <nameColumn> <= :fqn AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>")
        public List<String> listPrefixesBeforeInternal(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="fqn") String var3, @Bind(value="servicePrefix") String var4, @Bind(value="limit") int var5, @Bind(value="before") String var6);

        default public List<String> listPrefixesAfter(String table, String nameColumn, String fqn, String service, int limit, String after) {
            return this.listPrefixesAfterInternal(table, nameColumn, fqn, service + ".", limit, after);
        }

        @SqlQuery(value="SELECT json FROM <table> WHERE LEFT(:fqn, LENGTH(<nameColumn>)) = <nameColumn> AND <nameColumn> >= :servicePrefix AND <nameColumn> <= :fqn AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit")
        public List<String> listPrefixesAfterInternal(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="fqn") String var3, @Bind(value="servicePrefix") String var4, @Bind(value="limit") int var5, @Bind(value="after") String var6);
    }

    public static interface TableDAO
    extends EntityDAO<Table> {
        @Override
        default public String getTableName() {
            return "table_entity";
        }

        @Override
        default public Class<Table> getEntityClass() {
            return Table.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface ReportDAO
    extends EntityDAO<Report> {
        @Override
        default public String getTableName() {
            return "report_entity";
        }

        @Override
        default public Class<Report> getEntityClass() {
            return Report.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface PolicyDAO
    extends EntityDAO<Policy> {
        @Override
        default public String getTableName() {
            return "policy_entity";
        }

        @Override
        default public Class<Policy> getEntityClass() {
            return Policy.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface MlModelServiceDAO
    extends EntityDAO<MlModelService> {
        @Override
        default public String getTableName() {
            return "mlmodel_service_entity";
        }

        @Override
        default public Class<MlModelService> getEntityClass() {
            return MlModelService.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface PipelineServiceDAO
    extends EntityDAO<PipelineService> {
        @Override
        default public String getTableName() {
            return "pipeline_service_entity";
        }

        @Override
        default public Class<PipelineService> getEntityClass() {
            return PipelineService.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface IngestionPipelineDAO
    extends EntityDAO<IngestionPipeline> {
        @Override
        default public String getTableName() {
            return "ingestion_pipeline_entity";
        }

        @Override
        default public Class<IngestionPipeline> getEntityClass() {
            return IngestionPipeline.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface GlossaryTermDAO
    extends EntityDAO<GlossaryTerm> {
        @Override
        default public String getTableName() {
            return "glossary_term_entity";
        }

        @Override
        default public Class<GlossaryTerm> getEntityClass() {
            return GlossaryTerm.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface GlossaryDAO
    extends EntityDAO<Glossary> {
        @Override
        default public String getTableName() {
            return "glossary_entity";
        }

        @Override
        default public Class<Glossary> getEntityClass() {
            return Glossary.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface MlModelDAO
    extends EntityDAO<MlModel> {
        @Override
        default public String getTableName() {
            return "ml_model_entity";
        }

        @Override
        default public Class<MlModel> getEntityClass() {
            return MlModel.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface MetricsDAO
    extends EntityDAO<Metrics> {
        @Override
        default public String getTableName() {
            return "metrics_entity";
        }

        @Override
        default public Class<Metrics> getEntityClass() {
            return Metrics.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface MessagingServiceDAO
    extends EntityDAO<MessagingService> {
        @Override
        default public String getTableName() {
            return "messaging_service_entity";
        }

        @Override
        default public Class<MessagingService> getEntityClass() {
            return MessagingService.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface ChartDAO
    extends EntityDAO<Chart> {
        @Override
        default public String getTableName() {
            return "chart_entity";
        }

        @Override
        default public Class<Chart> getEntityClass() {
            return Chart.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface BotDAO
    extends EntityDAO<Bot> {
        @Override
        default public String getTableName() {
            return "bot_entity";
        }

        @Override
        default public Class<Bot> getEntityClass() {
            return Bot.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface FieldRelationshipDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT IGNORE INTO field_relationship(fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQN, :toFQN, :fromType, :toType, :relation, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQN, toFQN, fromType, toType, relation, json) VALUES (:fromFQN, :toFQN, :fromType, :toType, :relation, (:json :: jsonb)) ON CONFLICT (fromFQN, toFQN, relation) DO NOTHING", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="fromFQN") String var1, @Bind(value="toFQN") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5, @Bind(value="json") String var6);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO field_relationship(fromFQN, toFQN, fromType, toType, relation, jsonSchema, json) VALUES (:fromFQN, :toFQN, :fromType, :toType, :relation, :jsonSchema, (:json :: jsonb)) ON CONFLICT (fromFQN, toFQN, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void upsert(@Bind(value="fromFQN") String var1, @Bind(value="toFQN") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5, @Bind(value="jsonSchema") String var6, @Bind(value="json") String var7);

        @SqlQuery(value="SELECT json FROM field_relationship WHERE fromFQN = :fromFQN AND toFQN = :toFQN AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public String find(@Bind(value="fromFQN") String var1, @Bind(value="toFQN") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE toFQN LIKE CONCAT(:fqnPrefix, '%') AND fromType = :fromType AND toType = :toType AND relation = :relation")
        @RegisterRowMapper(value=FromFieldMapper.class)
        public List<Triple<String, String, String>> listFromByPrefix(@Bind(value="fqnPrefix") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE toFQN LIKE CONCAT(:fqnPrefix, '%') AND fromType = :fromType AND toType LIKE CONCAT(:toType, '%') AND relation = :relation")
        @RegisterRowMapper(value=FromFieldMapper.class)
        public List<Triple<String, String, String>> listFromByAllPrefix(@Bind(value="fqnPrefix") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQN LIKE CONCAT(:fqnPrefix, '%') AND fromType = :fromType AND toType = :toType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listToByPrefix(@Bind(value="fqnPrefix") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQN = :fqn AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQN = :fqn AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectional(@Bind(value="fqn") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        @SqlQuery(value="SELECT fromFQN, toFQN, json FROM field_relationship WHERE fromFQN LIKE CONCAT(:fqnPrefix, '%') AND fromType = :type AND toType = :otherType AND relation = :relation UNION SELECT toFQN, fromFQN, json FROM field_relationship WHERE toFQN LIKE CONCAT(:fqnPrefix, '%') AND toType = :type AND fromType = :otherType AND relation = :relation")
        @RegisterRowMapper(value=ToFieldMapper.class)
        public List<Triple<String, String, String>> listBidirectionalByPrefix(@Bind(value="fqnPrefix") String var1, @Bind(value="type") String var2, @Bind(value="otherType") String var3, @Bind(value="relation") int var4);

        default public void deleteAllByPrefix(String fqnPrefix) {
            String prefix = String.format("%s%s%%", fqnPrefix, ".");
            String condition = "WHERE (toFQN LIKE :prefix OR fromFQN LIKE :prefix)";
            HashMap<String, String> bindMap = new HashMap<String, String>();
            bindMap.put("prefix", prefix);
            this.deleteAllByPrefixInternal(condition, bindMap);
        }

        @SqlUpdate(value="DELETE from field_relationship <cond>")
        public void deleteAllByPrefixInternal(@Define(value="cond") String var1, @BindMap Map<String, String> var2);

        @SqlUpdate(value="DELETE from field_relationship WHERE fromFQN = :fromFQN AND toFQN = :toFQN AND fromType = :fromType AND toType = :toType AND relation = :relation")
        public void delete(@Bind(value="fromFQN") String var1, @Bind(value="toFQN") String var2, @Bind(value="fromType") String var3, @Bind(value="toType") String var4, @Bind(value="relation") int var5);

        public static class FromFieldMapper
        implements RowMapper<Triple<String, String, String>> {
            public Triple<String, String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Triple.of((Object)rs.getString("toFQN"), (Object)rs.getString("fromFQN"), (Object)rs.getString("json"));
            }
        }

        public static class ToFieldMapper
        implements RowMapper<Triple<String, String, String>> {
            public Triple<String, String, String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Triple.of((Object)rs.getString("fromFQN"), (Object)rs.getString("toFQN"), (Object)rs.getString("json"));
            }
        }
    }

    public static interface FeedDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO thread_entity(json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="json") String var1);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE id = :id")
        public String findById(@Bind(value="id") String var1);

        @SqlQuery(value="SELECT json FROM thread_entity ORDER BY createdAt DESC")
        public List<String> list();

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE resolved = :resolved AND (:type IS NULL OR type = :type) AND (:status IS NULL OR taskStatus = :status)")
        public int listCount(@Bind(value="status") TaskStatus var1, @Bind(value="resolved") boolean var2, @Bind(value="type") ThreadType var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE (:type IS NULL OR type = :type) AND <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE (:type IS NULL OR type = :type) AND <postgresCond>", connectionType=ConnectionType.POSTGRES)})
        public int listAnnouncementCount(@Bind(value="type") ThreadType var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3);

        default public int listCount(TaskStatus status, boolean resolved, ThreadType type, Boolean activeAnnouncement) {
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listAnnouncementCount(ThreadType.Announcement, mysqlCondition, postgresCondition);
            }
            return this.listCount(status, resolved, type);
        }

        @SqlUpdate(value="DELETE FROM thread_entity WHERE id = :id")
        public void delete(@Bind(value="id") String var1);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=LAST_INSERT_ID(id+1)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE task_sequence SET id=(id+1) RETURNING id", connectionType=ConnectionType.POSTGRES)})
        public void updateTaskId();

        @SqlQuery(value="SELECT id FROM task_sequence LIMIT 1")
        public int getTaskId();

        @SqlQuery(value="SELECT json FROM thread_entity WHERE taskId = :id")
        public String findByTaskId(@Bind(value="id") int var1);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND resolved = :resolved AND (:type IS NULL OR type = :type) AND (:status IS NULL OR taskStatus = :status) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listBefore(@Bind(value="limit") int var1, @Bind(value="before") long var2, @Bind(value="status") TaskStatus var4, @Bind(value="resolved") boolean var5, @Bind(value="type") ThreadType var6);

        default public List<String> listBefore(int limit, long before, TaskStatus status, boolean resolved, ThreadType type, Boolean activeAnnouncement) {
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listAnnouncementBefore(limit, before, ThreadType.Announcement, mysqlCondition, postgresCondition);
            }
            return this.listBefore(limit, before, status, resolved, type);
        }

        default public List<String> listAnnouncementBetween(String entityId, long startTs, long endTs) {
            return this.listAnnouncementBetween(null, entityId, startTs, endTs);
        }

        @SqlQuery(value="SELECT json FROM thread_entity WHERE type='Announcement' AND (:threadId IS NULL OR id != :threadId) AND entityId = :entityId AND (( :startTs >= announcementStart AND :startTs < announcementEnd) OR (:endTs > announcementStart AND :endTs < announcementEnd) OR (:startTs <= announcementStart AND :endTs >= announcementEnd))")
        public List<String> listAnnouncementBetween(@Bind(value="threadId") String var1, @Bind(value="entityId") String var2, @Bind(value="startTs") long var3, @Bind(value="endTs") long var5);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND type = :type AND <mysqlCond> ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND type = :type AND <postgresCond> ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAnnouncementBefore(@Bind(value="limit") int var1, @Bind(value="before") long var2, @Bind(value="type") ThreadType var4, @Define(value="mysqlCond") String var5, @Define(value="postgresCond") String var6);

        default public List<String> listAfter(int limit, long after, TaskStatus status, boolean resolved, ThreadType type, Boolean activeAnnouncement) {
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listAnnouncementAfter(limit, after, ThreadType.Announcement, mysqlCondition, postgresCondition);
            }
            return this.listAfter(limit, after, status, resolved, type);
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND type = :type AND <mysqlCond> ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND type = :type AND <postgresCond> ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAnnouncementAfter(@Bind(value="limit") int var1, @Bind(value="after") long var2, @Bind(value="type") ThreadType var4, @Define(value="mysqlCond") String var5, @Define(value="postgresCond") String var6);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND resolved = :resolved AND (:type IS NULL OR type = :type) AND (:status IS NULL OR taskStatus = :status) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listAfter(@Bind(value="limit") int var1, @Bind(value="after") long var2, @Bind(value="status") TaskStatus var4, @Bind(value="resolved") boolean var5, @Bind(value="type") ThreadType var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt > :before AND taskStatus = :status AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt > :before AND taskStatus = :status AND JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksAssignedToBefore(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="status") TaskStatus var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt < :after AND (:status IS NULL OR taskStatus = :status) AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt < :after AND (:status IS NULL OR taskStatus = :status) AND JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksAssignedToAfter(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="status") TaskStatus var6);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE type='Task' AND (:status IS NULL OR taskStatus = :status) AND taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[])", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE type='Task' AND (:status IS NULL OR taskStatus = :status) AND JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksAssignedTo(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="status") TaskStatus var3);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt > :before AND taskStatus = :status AND AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt > :before AND taskStatus = :status AND AND (JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksOfUserBefore(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Bind(value="limit") int var4, @Bind(value="before") long var5, @Bind(value="status") TaskStatus var7);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt < :after AND (:status IS NULL OR taskStatus = :status) AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt < :after AND (:status IS NULL OR taskStatus = :status) AND (JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) OR createdBy = :username) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL)})
        public List<String> listTasksOfUserAfter(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Bind(value="limit") int var4, @Bind(value="after") long var5, @Bind(value="status") TaskStatus var7);

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE type='Task' AND (:status IS NULL OR taskStatus = :status) AND (taskAssignees @> ANY (ARRAY[<userTeamJsonPostgres>]::jsonb[]) OR createdBy = :username) ", connectionType=ConnectionType.POSTGRES), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE type='Task' AND (:status IS NULL OR taskStatus = :status) AND (JSON_OVERLAPS(taskAssignees, :userTeamJsonMysql) OR createdBy = :username) ", connectionType=ConnectionType.MYSQL)})
        public int listCountTasksOfUser(@BindList(value="userTeamJsonPostgres") List<String> var1, @Bind(value="userTeamJsonMysql") String var2, @Bind(value="username") String var3, @Bind(value="status") TaskStatus var4);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt > :before AND (:status IS NULL OR taskStatus = :status) AND createdBy = :username ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listTasksAssignedByBefore(@Bind(value="username") String var1, @Bind(value="limit") int var2, @Bind(value="before") long var3, @Bind(value="status") TaskStatus var5);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE type='Task' AND updatedAt < :after AND (:status IS NULL OR taskStatus = :status) AND createdBy = :username ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listTasksAssignedByAfter(@Bind(value="username") String var1, @Bind(value="limit") int var2, @Bind(value="after") long var3, @Bind(value="status") TaskStatus var5);

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE type='Task' AND (:status IS NULL OR taskStatus = :status) AND createdBy = :username")
        public int listCountTasksAssignedBy(@Bind(value="username") String var1, @Bind(value="status") TaskStatus var2);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND resolved = :resolved AND (:type IS NULL OR type = :type) AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByOwnerBefore(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND resolved = :resolved AND (:type IS NULL OR type = :type) AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByOwnerAfter(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7);

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE resolved = :resolved AND (:type IS NULL OR type = :type) AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) ")
        public int listCountThreadsByOwner(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="type") ThreadType var3, @Bind(value="resolved") boolean var4);

        default public List<String> listThreadsByEntityLinkBefore(String fqnPrefix, String toType, int limit, long before, ThreadType type, TaskStatus status, Boolean activeAnnouncement, boolean resolved, int relation, String userName, List<String> teamNames, FeedRepository.FilterType filterType) {
            int filterRelation = -1;
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listAnnouncementsByEntityLinkBefore(fqnPrefix, toType, limit, before, type, relation, mysqlCondition, postgresCondition);
            }
            if (userName != null && filterType == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listThreadsByEntityLinkBefore(fqnPrefix, toType, limit, before, type, status, resolved, relation, userName, teamNames, filterRelation);
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND (:type IS NULL OR type = :type) AND <mysqlCond> AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND (:type IS NULL OR type = :type) AND <postgresCond> AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAnnouncementsByEntityLinkBefore(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="type") ThreadType var6, @Bind(value="relation") int var7, @Define(value="mysqlCond") String var8, @Define(value="postgresCond") String var9);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND resolved = :resolved AND (:status IS NULL OR taskStatus = :status) AND (:type IS NULL OR type = :type) AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR id in (SELECT toFQN FROM field_relationship WHERE  ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByEntityLinkBefore(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="type") ThreadType var6, @Bind(value="status") TaskStatus var7, @Bind(value="resolved") boolean var8, @Bind(value="relation") int var9, @Bind(value="userName") String var10, @BindList(value="teamNames") List<String> var11, @Bind(value="filterRelation") int var12);

        default public List<String> listThreadsByEntityLinkAfter(String fqnPrefix, String toType, int limit, long after, ThreadType type, TaskStatus status, Boolean activeAnnouncement, boolean resolved, int relation, String userName, List<String> teamNames, FeedRepository.FilterType filterType) {
            int filterRelation = -1;
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listAnnouncementsByEntityLinkAfter(fqnPrefix, toType, limit, after, type, relation, mysqlCondition, postgresCondition);
            }
            if (userName != null && filterType == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listThreadsByEntityLinkAfter(fqnPrefix, toType, limit, after, type, status, resolved, relation, userName, teamNames, filterRelation);
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND (:type IS NULL OR type = :type) AND <mysqlCond> AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND (:type IS NULL OR type = :type) AND <postgresCond> AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
        public List<String> listAnnouncementsByEntityLinkAfter(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="type") ThreadType var6, @Bind(value="relation") int var7, @Define(value="mysqlCond") String var8, @Define(value="postgresCond") String var9);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND resolved = :resolved AND (:status IS NULL OR taskStatus = :status) AND (:type IS NULL OR type = :type) AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR id in (SELECT toFQN FROM field_relationship WHERE  ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByEntityLinkAfter(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="type") ThreadType var6, @Bind(value="status") TaskStatus var7, @Bind(value="resolved") boolean var8, @Bind(value="relation") int var9, @Bind(value="userName") String var10, @BindList(value="teamNames") List<String> var11, @Bind(value="filterRelation") int var12);

        default public int listCountThreadsByEntityLink(String fqnPrefix, String toType, ThreadType type, TaskStatus status, Boolean activeAnnouncement, boolean resolved, int relation, String userName, List<String> teamNames, FeedRepository.FilterType filterType) {
            int filterRelation = -1;
            if (ThreadType.Announcement.equals((Object)type) && activeAnnouncement != null) {
                String postgresCondition;
                String mysqlCondition;
                if (activeAnnouncement.booleanValue()) {
                    mysqlCondition = " UNIX_TIMESTAMP() BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) BETWEEN announcementStart AND announcementEnd ";
                } else {
                    mysqlCondition = " UNIX_TIMESTAMP() NOT BETWEEN announcementStart AND announcementEnd ";
                    postgresCondition = " extract(epoch from now()) NOT BETWEEN announcementStart AND announcementEnd ";
                }
                return this.listCountAnnouncementsByEntityLink(fqnPrefix, toType, type, relation, mysqlCondition, postgresCondition);
            }
            if (userName != null && filterType == FeedRepository.FilterType.MENTIONS) {
                filterRelation = Relationship.MENTIONED_IN.ordinal();
            }
            return this.listCountThreadsByEntityLink(fqnPrefix, toType, type, status, resolved, relation, userName, teamNames, filterRelation);
        }

        @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE <mysqlCond> AND (:type IS NULL OR type = :type) AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(id) FROM thread_entity WHERE <postgresCond> AND (:type IS NULL OR type = :type) AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation)", connectionType=ConnectionType.POSTGRES)})
        public int listCountAnnouncementsByEntityLink(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="type") ThreadType var3, @Bind(value="relation") int var4, @Define(value="mysqlCond") String var5, @Define(value="postgresCond") String var6);

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE resolved = :resolved AND (:status IS NULL OR taskStatus = :status) AND (:type IS NULL OR type = :type) AND id in (SELECT fromFQN FROM field_relationship WHERE (:fqnPrefix IS NULL OR toFQN LIKE CONCAT(:fqnPrefix, '.%') OR toFQN=:fqnPrefix) AND fromType='THREAD' AND (:toType IS NULL OR toType LIKE CONCAT(:toType, '.%') OR toType=:toType) AND relation= :relation) AND (:userName IS NULL OR id in (SELECT toFQN FROM field_relationship WHERE  ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>))) AND toType='THREAD' AND relation= :filterRelation) )")
        public int listCountThreadsByEntityLink(@Bind(value="fqnPrefix") String var1, @Bind(value="toType") String var2, @Bind(value="type") ThreadType var3, @Bind(value="status") TaskStatus var4, @Bind(value="resolved") boolean var5, @Bind(value="relation") int var6, @Bind(value="userName") String var7, @BindList(value="teamNames") List<String> var8, @Bind(value="filterRelation") int var9);

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = :json where id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE thread_entity SET json = (:json :: jsonb) where id = :id", connectionType=ConnectionType.POSTGRES)})
        public void update(@Bind(value="id") String var1, @Bind(value="json") String var2);

        @SqlQuery(value="SELECT entityLink, COUNT(id) count FROM field_relationship fr INNER JOIN thread_entity te ON fr.fromFQN=te.id WHERE (:fqnPrefix IS NULL OR fr.toFQN LIKE CONCAT(:fqnPrefix, '.%') OR fr.toFQN=:fqnPrefix) AND (:toType IS NULL OR fr.toType like concat(:toType, '.%') OR fr.toType=:toType) AND fr.fromType = :fromType AND fr.relation = :relation AND te.resolved= :isResolved AND (:status IS NULL OR te.taskStatus = :status) AND (:type IS NULL OR te.type = :type) GROUP BY entityLink")
        @RegisterRowMapper(value=CountFieldMapper.class)
        public List<List<String>> listCountByEntityLink(@Bind(value="fqnPrefix") String var1, @Bind(value="fromType") String var2, @Bind(value="toType") String var3, @Bind(value="relation") int var4, @Bind(value="type") ThreadType var5, @Bind(value="status") TaskStatus var6, @Bind(value="isResolved") boolean var7);

        @SqlQuery(value="SELECT entityLink, COUNT(id) count FROM thread_entity WHERE resolved = :resolved AND (:type IS NULL OR type = :type) AND (entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation=8) OR id in (SELECT toId FROM entity_relationship WHERE (fromEntity='user' AND fromId= :userId AND toEntity='THREAD' AND relation IN (1,2)))) GROUP BY entityLink")
        @RegisterRowMapper(value=CountFieldMapper.class)
        public List<List<String>> listCountByOwner(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="type") ThreadType var3, @Bind(value="resolved") boolean var4);

        @SqlQuery(value="SELECT entityLink, COUNT(id) count FROM thread_entity WHERE (id IN (<threadIds>)) AND resolved= :isResolved AND (:type IS NULL OR type = :type) AND (:status IS NULL OR taskStatus = :status) GROUP BY entityLink")
        @RegisterRowMapper(value=CountFieldMapper.class)
        public List<List<String>> listCountByThreads(@BindList(value="threadIds") List<String> var1, @Bind(value="type") ThreadType var2, @Bind(value="status") TaskStatus var3, @Bind(value="isResolved") boolean var4);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND resolved = :resolved AND (:type IS NULL OR type = :type) AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByFollowsBefore(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7, @Bind(value="relation") int var8);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND resolved = :resolved AND (:type IS NULL OR type = :type) AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByFollowsAfter(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7, @Bind(value="relation") int var8);

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE resolved = :resolved AND (:type IS NULL OR type = :type) AND entityId in (SELECT toId FROM entity_relationship WHERE ((fromEntity='user' AND fromId= :userId) OR (fromEntity='team' AND fromId IN (<teamIds>))) AND relation= :relation)")
        public int listCountThreadsByFollows(@Bind(value="userId") String var1, @BindList(value="teamIds") List<String> var2, @Bind(value="type") ThreadType var3, @Bind(value="resolved") boolean var4, @Bind(value="relation") int var5);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt > :before AND resolved = :resolved AND (:type IS NULL OR type = :type) AND id in (SELECT toFQN FROM field_relationship WHERE ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByMentionsBefore(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="limit") int var3, @Bind(value="before") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7, @Bind(value="relation") int var8);

        @SqlQuery(value="SELECT json FROM thread_entity WHERE updatedAt < :after AND resolved = :resolved AND (:type IS NULL OR type = :type) AND id in (SELECT toFQN FROM field_relationship WHERE ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ORDER BY createdAt DESC LIMIT :limit")
        public List<String> listThreadsByMentionsAfter(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="limit") int var3, @Bind(value="after") long var4, @Bind(value="type") ThreadType var6, @Bind(value="resolved") boolean var7, @Bind(value="relation") int var8);

        @SqlQuery(value="SELECT count(id) FROM thread_entity WHERE resolved = :resolved AND (:type IS NULL OR type = :type) AND id in (SELECT toFQN FROM field_relationship WHERE ((fromType='user' AND fromFQN= :userName) OR (fromType='team' AND fromFQN IN (<teamNames>)))  AND toType='THREAD' AND relation= :relation) ")
        public int listCountThreadsByMentions(@Bind(value="userName") String var1, @BindList(value="teamNames") List<String> var2, @Bind(value="type") ThreadType var3, @Bind(value="resolved") boolean var4, @Bind(value="relation") int var5);

        public static class CountFieldMapper
        implements RowMapper<List<String>> {
            public List<String> map(ResultSet rs, StatementContext ctx) throws SQLException {
                return Arrays.asList(rs.getString("entityLink"), rs.getString("count"));
            }
        }
    }

    public static interface EntityRelationshipDAO {
        default public void insert(UUID fromId, UUID toId, String fromEntity, String toEntity, int relation) {
            this.insert(fromId, toId, fromEntity, toEntity, relation, null);
        }

        default public void insert(UUID fromId, UUID toId, String fromEntity, String toEntity, int relation, String json) {
            this.insert(fromId.toString(), toId.toString(), fromEntity, toEntity, relation, json);
        }

        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, :json) ON DUPLICATE KEY UPDATE json = :json", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_relationship(fromId, toId, fromEntity, toEntity, relation, json) VALUES (:fromId, :toId, :fromEntity, :toEntity, :relation, (:json :: jsonb)) ON CONFLICT (fromId, toId, relation) DO UPDATE SET json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="fromId") String var1, @Bind(value="toId") String var2, @Bind(value="fromEntity") String var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5, @Bind(value="json") String var6);

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation IN (<relation>) ORDER BY toId")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @BindList(value="relation") List<Integer> var3);

        default public List<EntityRelationshipRecord> findTo(String fromId, String fromEntity, int relation) {
            return this.findTo(fromId, fromEntity, List.of(Integer.valueOf(relation)));
        }

        @SqlQuery(value="SELECT toId, toEntity, json FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity ORDER BY toId")
        @RegisterRowMapper(value=ToRelationshipMapper.class)
        public List<EntityRelationshipRecord> findTo(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @SqlQuery(value="SELECT count(*) FROM entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND (toEntity = :toEntity OR :toEntity IS NULL) ORDER BY fromId")
        public int findToCount(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3);

        @SqlQuery(value="SELECT fromId, fromEntity, json FROM entity_relationship WHERE toId = :toId ORDER BY fromId")
        @RegisterRowMapper(value=FromRelationshipMapper.class)
        public List<EntityRelationshipRecord> findFrom(@Bind(value="toId") String var1);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND toId = :toId AND toEntity = :toEntity AND relation = :relation")
        public int delete(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="toId") String var3, @Bind(value="toEntity") String var4, @Bind(value="relation") int var5);

        @SqlUpdate(value="DELETE from entity_relationship WHERE fromId = :fromId AND fromEntity = :fromEntity AND relation = :relation AND toEntity = :toEntity")
        public void deleteFrom(@Bind(value="fromId") String var1, @Bind(value="fromEntity") String var2, @Bind(value="relation") int var3, @Bind(value="toEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE toId = :toId AND toEntity = :toEntity AND relation = :relation AND fromEntity = :fromEntity")
        public void deleteTo(@Bind(value="toId") String var1, @Bind(value="toEntity") String var2, @Bind(value="relation") int var3, @Bind(value="fromEntity") String var4);

        @SqlUpdate(value="DELETE from entity_relationship WHERE (toId = :id AND toEntity = :entity) OR (fromId = :id AND fromEntity = :entity)")
        public void deleteAll(@Bind(value="id") String var1, @Bind(value="entity") String var2);

        public static class ToRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("toId"))).type(rs.getString("toEntity")).json(rs.getString("json")).build();
            }
        }

        public static class FromRelationshipMapper
        implements RowMapper<EntityRelationshipRecord> {
            public EntityRelationshipRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
                return EntityRelationshipRecord.builder().id(UUID.fromString(rs.getString("fromId"))).type(rs.getString("fromEntity")).json(rs.getString("json")).build();
            }
        }
    }

    public static class EntityRelationshipRecord {
        private UUID id;
        private String type;
        private String json;

        EntityRelationshipRecord(UUID id, String type, String json) {
            this.id = id;
            this.type = type;
            this.json = json;
        }

        public static EntityRelationshipRecordBuilder builder() {
            return new EntityRelationshipRecordBuilder();
        }

        public UUID getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getJson() {
            return this.json;
        }

        public static class EntityRelationshipRecordBuilder {
            private UUID id;
            private String type;
            private String json;

            EntityRelationshipRecordBuilder() {
            }

            public EntityRelationshipRecordBuilder id(UUID id) {
                this.id = id;
                return this;
            }

            public EntityRelationshipRecordBuilder type(String type) {
                this.type = type;
                return this;
            }

            public EntityRelationshipRecordBuilder json(String json) {
                this.json = json;
                return this;
            }

            public EntityRelationshipRecord build() {
                return new EntityRelationshipRecord(this.id, this.type, this.json);
            }

            public String toString() {
                return "CollectionDAO.EntityRelationshipRecord.EntityRelationshipRecordBuilder(id=" + this.id + ", type=" + this.type + ", json=" + this.json + ")";
            }
        }
    }

    public static class ExtensionMapper
    implements RowMapper<ExtensionRecord> {
        public ExtensionRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
            return new ExtensionRecord(rs.getString("extension"), rs.getString("json"));
        }
    }

    public static class ExtensionRecord {
        private final String extensionName;
        private final String extensionJson;

        public ExtensionRecord(String extensionName, String extensionJson) {
            this.extensionName = extensionName;
            this.extensionJson = extensionJson;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public String getExtensionJson() {
            return this.extensionJson;
        }
    }

    public static class EntityVersionPair {
        private final Double version;
        private final String entityJson;

        public EntityVersionPair(ExtensionRecord extensionRecord) {
            this.version = EntityUtil.getVersion(extensionRecord.getExtensionName());
            this.entityJson = extensionRecord.getExtensionJson();
        }

        public Double getVersion() {
            return this.version;
        }

        public String getEntityJson() {
            return this.entityJson;
        }
    }

    public static interface EntityExtensionDAO {
        @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="REPLACE INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO entity_extension(id, extension, jsonSchema, json) VALUES (:id, :extension, :jsonSchema, (:json :: jsonb)) ON CONFLICT (id, extension) DO UPDATE SET jsonSchema = EXCLUDED.jsonSchema, json = EXCLUDED.json", connectionType=ConnectionType.POSTGRES)})
        public void insert(@Bind(value="id") String var1, @Bind(value="extension") String var2, @Bind(value="jsonSchema") String var3, @Bind(value="json") String var4);

        @SqlQuery(value="SELECT json FROM entity_extension WHERE id = :id AND extension = :extension")
        public String getExtension(@Bind(value="id") String var1, @Bind(value="extension") String var2);

        @RegisterRowMapper(value=ExtensionMapper.class)
        @SqlQuery(value="SELECT extension, json FROM entity_extension WHERE id = :id AND extension LIKE CONCAT (:extensionPrefix, '.%') ORDER BY extension")
        public List<ExtensionRecord> getExtensions(@Bind(value="id") String var1, @Bind(value="extensionPrefix") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id AND extension = :extension")
        public void delete(@Bind(value="id") String var1, @Bind(value="extension") String var2);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE extension = :extension")
        public void deleteExtension(@Bind(value="extension") String var1);

        @SqlUpdate(value="DELETE FROM entity_extension WHERE id = :id")
        public void deleteAll(@Bind(value="id") String var1);
    }

    public static interface StorageServiceDAO
    extends EntityDAO<StorageService> {
        @Override
        default public String getTableName() {
            return "storage_service_entity";
        }

        @Override
        default public Class<StorageService> getEntityClass() {
            return StorageService.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface DatabaseServiceDAO
    extends EntityDAO<DatabaseService> {
        @Override
        default public String getTableName() {
            return "dbservice_entity";
        }

        @Override
        default public Class<DatabaseService> getEntityClass() {
            return DatabaseService.class;
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }
    }

    public static interface DatabaseSchemaDAO
    extends EntityDAO<DatabaseSchema> {
        @Override
        default public String getTableName() {
            return "database_schema_entity";
        }

        @Override
        default public Class<DatabaseSchema> getEntityClass() {
            return DatabaseSchema.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface DatabaseDAO
    extends EntityDAO<Database> {
        @Override
        default public String getTableName() {
            return "database_entity";
        }

        @Override
        default public Class<Database> getEntityClass() {
            return Database.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }

    public static interface DashboardServiceDAO
    extends EntityDAO<DashboardService> {
        @Override
        default public String getTableName() {
            return "dashboard_service_entity";
        }

        @Override
        default public String getNameColumn() {
            return "name";
        }

        @Override
        default public Class<DashboardService> getEntityClass() {
            return DashboardService.class;
        }
    }

    public static interface DashboardDAO
    extends EntityDAO<Dashboard> {
        @Override
        default public String getTableName() {
            return "dashboard_entity";
        }

        @Override
        default public Class<Dashboard> getEntityClass() {
            return Dashboard.class;
        }

        @Override
        default public String getNameColumn() {
            return "fullyQualifiedName";
        }
    }
}

