/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface EntityDAO<T extends EntityInterface> {
    public String getTableName();

    public Class<T> getEntityClass();

    public String getNameColumn();

    default public boolean supportsSoftDelete() {
        return true;
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO <table> (json) VALUES (:json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO <table> (json) VALUES (:json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
    public void insert(@Define(value="table") String var1, @Bind(value="json") String var2);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = :json WHERE id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = (:json :: jsonb) WHERE id = :id", connectionType=ConnectionType.POSTGRES)})
    public void update(@Define(value="table") String var1, @Bind(value="id") String var2, @Bind(value="json") String var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE id = :id <cond>")
    public String findById(@Define(value="table") String var1, @Bind(value="id") String var2, @Define(value="cond") String var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE <nameColumn> = :name <cond>")
    public String findByName(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="name") String var3, @Define(value="cond") String var4);

    @SqlQuery(value="SELECT count(*) FROM <table> <cond>")
    public int listCount(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3);

    @SqlQuery(value="SELECT json FROM (SELECT <nameColumn>, json FROM <table> <cond> AND <nameColumn> < :before ORDER BY <nameColumn> DESC LIMIT :limit) last_rows_subquery ORDER BY <nameColumn>")
    public List<String> listBefore(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="before") String var5);

    @SqlQuery(value="SELECT json FROM <table> <cond> AND <nameColumn> > :after ORDER BY <nameColumn> LIMIT :limit")
    public List<String> listAfter(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="after") String var5);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE id = :id)")
    public boolean exists(@Define(value="table") String var1, @Bind(value="id") String var2);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE <nameColumn> = :fqn)")
    public boolean existsByName(@Define(value="table") String var1, @Define(value="nameColumn") String var2, @Bind(value="fqn") String var3);

    @SqlUpdate(value="DELETE FROM <table> WHERE id = :id")
    public int delete(@Define(value="table") String var1, @Bind(value="id") String var2);

    default public void insert(EntityInterface entity) throws JsonProcessingException {
        this.insert(this.getTableName(), JsonUtils.pojoToJson(entity));
    }

    default public void update(UUID id, String json) {
        this.update(this.getTableName(), id.toString(), json);
    }

    default public void update(EntityInterface entity) throws JsonProcessingException {
        this.update(this.getTableName(), entity.getId().toString(), JsonUtils.pojoToJson(entity));
    }

    default public String getCondition(Include include) {
        if (!this.supportsSoftDelete()) {
            return "";
        }
        if (include == null || include == Include.NON_DELETED) {
            return "AND deleted = FALSE";
        }
        if (include == Include.DELETED) {
            return " AND deleted = TRUE";
        }
        return "";
    }

    default public T findEntityById(UUID id, Include include) throws IOException {
        return this.jsonToEntity(this.findById(this.getTableName(), id.toString(), this.getCondition(include)), id.toString());
    }

    default public T findEntityById(UUID id) throws IOException {
        return this.findEntityById(id, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn) {
        return this.findEntityByName(fqn, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn, Include include) {
        return this.jsonToEntity(this.findByName(this.getTableName(), this.getNameColumn(), fqn, this.getCondition(include)), fqn);
    }

    default public T jsonToEntity(String json, String identity) throws IOException {
        Class<T> clz = this.getEntityClass();
        EntityInterface entity = null;
        if (json != null) {
            entity = (EntityInterface)JsonUtils.readValue(json, clz);
        }
        if (entity == null) {
            String entityType = Entity.getEntityTypeFromClass(clz);
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, identity));
        }
        return (T)entity;
    }

    default public EntityReference findEntityReferenceById(UUID id) throws IOException {
        return this.findEntityById(id).getEntityReference();
    }

    default public EntityReference findEntityReferenceByName(String fqn) {
        return this.findEntityByName(fqn).getEntityReference();
    }

    default public EntityReference findEntityReferenceById(UUID id, Include include) throws IOException {
        return this.findEntityById(id, include).getEntityReference();
    }

    default public EntityReference findEntityReferenceByName(String fqn, Include include) {
        return this.findEntityByName(fqn, include).getEntityReference();
    }

    default public String findJsonById(UUID id, Include include) {
        return this.findById(this.getTableName(), id.toString(), this.getCondition(include));
    }

    default public String findJsonByFqn(String fqn, Include include) {
        return this.findByName(this.getTableName(), this.getNameColumn(), fqn, this.getCondition(include));
    }

    default public int listCount(ListFilter filter) {
        return this.listCount(this.getTableName(), this.getNameColumn(), filter.getCondition());
    }

    default public List<String> listBefore(ListFilter filter, int limit, String before) {
        before = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(before) : before;
        return this.listBefore(this.getTableName(), this.getNameColumn(), filter.getCondition(), limit, before);
    }

    default public List<String> listAfter(ListFilter filter, int limit, String after) {
        after = this.getNameColumn().equals("name") ? FullyQualifiedName.unquoteName(after) : after;
        return this.listAfter(this.getTableName(), this.getNameColumn(), filter.getCondition(), limit, after);
    }

    default public void exists(UUID id) {
        if (!this.exists(this.getTableName(), id.toString())) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
    }

    default public void existsByName(String fqn) {
        if (!this.existsByName(this.getTableName(), this.getNameColumn(), fqn)) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, fqn));
        }
    }

    default public int delete(String id) {
        int rowsDeleted = this.delete(this.getTableName(), id);
        if (rowsDeleted <= 0) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
        return rowsDeleted;
    }
}

