/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Location;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRepository
extends EntityRepository<Policy> {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyRepository.class);
    private static final String POLICY_UPDATE_FIELDS = "owner,location";
    private static final String POLICY_PATCH_FIELDS = "owner,location";
    public static final String ENABLED = "enabled";

    public PolicyRepository(CollectionDAO dao) {
        super("v1/policies/", "policy", Policy.class, dao.policyDAO(), dao, "owner,location", "owner,location");
    }

    @Transaction
    private EntityReference getLocationForPolicy(Policy policy) throws IOException {
        return this.getToEntityRef(policy.getId(), Relationship.APPLIED_TO, "location", false);
    }

    @Override
    public Policy setFields(Policy policy, EntityUtil.Fields fields) throws IOException {
        policy.setOwner(fields.contains("owner") ? this.getOwner(policy) : null);
        policy.setLocation(fields.contains("location") ? this.getLocationForPolicy(policy) : null);
        policy.setTeams(fields.contains("teams") ? this.getTeams(policy) : null);
        policy.setRoles(fields.contains("roles") ? this.getRoles(policy) : null);
        return policy;
    }

    private List<EntityReference> getTeams(Policy policy) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(policy.getId(), "policy", Relationship.HAS, "team");
        return EntityUtil.populateEntityReferences(records, "team");
    }

    private List<EntityReference> getRoles(Policy policy) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFrom(policy.getId(), "policy", Relationship.HAS, "role");
        return EntityUtil.populateEntityReferences(records, "role");
    }

    @Transaction
    private EntityReference getLocationReference(Policy policy) throws IOException {
        if (policy == null || policy.getLocation() == null || policy.getLocation().getId() == null) {
            return null;
        }
        Location location = (Location)this.daoCollection.locationDAO().findEntityById(policy.getLocation().getId());
        if (location == null) {
            return null;
        }
        return location.getEntityReference();
    }

    @Override
    public void prepare(Policy policy) throws IOException {
        this.setFullyQualifiedName(policy);
        this.validateRules(policy);
        policy.setLocation(this.getLocationReference(policy));
    }

    @Override
    public void storeEntity(Policy policy, boolean update) throws IOException {
        EntityReference owner = policy.getOwner();
        EntityReference location = policy.getLocation();
        URI href = policy.getHref();
        policy.withOwner(null).withLocation(null).withHref(null);
        this.store(policy.getId(), policy, update);
        policy.withOwner(owner).withLocation(location).withHref(href);
    }

    @Override
    public void storeRelationships(Policy policy) {
        this.storeOwner(policy, policy.getOwner());
        this.setLocation(policy, policy.getLocation());
    }

    public PolicyUpdater getUpdater(Policy original, Policy updated, EntityRepository.Operation operation) {
        return new PolicyUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Policy entity) {
        if (Boolean.FALSE.equals(entity.getAllowDelete())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.deletionNotAllowed("policy", entity.getName()));
        }
    }

    public void validateRules(Policy policy) {
        List rules = policy.getRules();
        if (CommonUtil.listOrEmpty((List)rules).isEmpty()) {
            throw new IllegalArgumentException("At least one rule is required in a policy");
        }
        for (Rule rule : rules) {
            CompiledRule.validateExpression(rule.getCondition(), Boolean.class);
            rule.getResources().sort(String.CASE_INSENSITIVE_ORDER);
            rule.getOperations().sort(Comparator.comparing(MetadataOperation::value));
        }
        rules.sort(Comparator.comparing(Rule::getName));
    }

    public List<Policy> getAccessControlPolicies() throws IOException {
        EntityUtil.Fields fields = new EntityUtil.Fields(List.of("rules", ENABLED));
        ListFilter filter = new ListFilter();
        List<String> jsons = this.daoCollection.policyDAO().listAfter(filter, Integer.MAX_VALUE, "");
        ArrayList<Policy> policies = new ArrayList<Policy>(jsons.size());
        for (String json : jsons) {
            Policy policy = this.setFieldsInternal(JsonUtils.readValue(json, Policy.class), fields);
            if (!Boolean.TRUE.equals(policy.getEnabled())) continue;
            policies.add(policy);
        }
        return policies;
    }

    private void setLocation(Policy policy, EntityReference location) {
        if (location == null || location.getId() == null) {
            return;
        }
        this.addRelationship(policy.getId(), policy.getLocation().getId(), "policy", "location", Relationship.APPLIED_TO);
    }

    public class PolicyUpdater
    extends EntityRepository.EntityUpdater {
        public PolicyUpdater(Policy original, Policy updated, EntityRepository.Operation operation) {
            super((EntityRepository)PolicyRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange(PolicyRepository.ENABLED, ((Policy)this.original).getEnabled(), ((Policy)this.updated).getEnabled());
            this.updateLocation((Policy)this.original, (Policy)this.updated);
            this.updateRules(((Policy)this.original).getRules(), ((Policy)this.updated).getRules());
        }

        private void updateLocation(Policy origPolicy, Policy updatedPolicy) throws IOException {
            if (origPolicy.getLocation() != null && origPolicy.getLocation().getId() != null) {
                PolicyRepository.this.deleteRelationship(origPolicy.getId(), "policy", origPolicy.getLocation().getId(), "location", Relationship.APPLIED_TO);
            }
            if (updatedPolicy.getLocation() != null && updatedPolicy.getLocation().getId() != null) {
                PolicyRepository.this.addRelationship(updatedPolicy.getId(), updatedPolicy.getLocation().getId(), "policy", "location", Relationship.APPLIED_TO);
            }
            this.recordChange("location", origPolicy.getLocation(), updatedPolicy.getLocation(), true, EntityUtil.entityReferenceMatch);
        }

        private void updateRules(List<Rule> origRules, List<Rule> updatedRules) throws IOException {
            ArrayList deletedRules = new ArrayList();
            ArrayList addedRules = new ArrayList();
            this.recordListChange("rules", origRules, updatedRules, addedRules, deletedRules, EntityUtil.ruleMatch);
            for (Rule updated : updatedRules) {
                Rule stored = origRules.stream().filter(c -> EntityUtil.ruleMatch.test((Rule)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateRuleDescription(stored, updated);
                this.updateRuleEffect(stored, updated);
                this.updateRuleOperations(stored, updated);
                this.updateRuleResources(stored, updated);
                this.updateRuleCondition(stored, updated);
            }
        }

        private void updateRuleDescription(Rule stored, Rule updated) throws JsonProcessingException {
            String ruleField = EntityUtil.getRuleField(stored, "description");
            this.recordChange(ruleField, stored.getDescription(), updated.getDescription());
        }

        private void updateRuleEffect(Rule stored, Rule updated) throws JsonProcessingException {
            String ruleField = EntityUtil.getRuleField(stored, "effect");
            this.recordChange(ruleField, stored.getEffect(), updated.getEffect());
        }

        private void updateRuleOperations(Rule stored, Rule updated) throws JsonProcessingException {
            String ruleField = EntityUtil.getRuleField(stored, "operations");
            this.recordChange(ruleField, stored.getOperations(), updated.getOperations());
        }

        private void updateRuleResources(Rule stored, Rule updated) throws JsonProcessingException {
            String ruleField = EntityUtil.getRuleField(stored, "resources");
            this.recordChange(ruleField, stored.getResources(), updated.getResources());
        }

        private void updateRuleCondition(Rule stored, Rule updated) throws JsonProcessingException {
            String ruleField = EntityUtil.getRuleField(stored, "condition");
            this.recordChange(ruleField, stored.getCondition(), updated.getCondition());
        }
    }
}

