/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.TeamHierarchy;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamRepository
extends EntityRepository<Team> {
    private static final Logger LOG = LoggerFactory.getLogger(TeamRepository.class);
    static final String TEAM_UPDATE_FIELDS = "owner,profile,users,defaultRoles,parents,children,policies,teamType";
    static final String TEAM_PATCH_FIELDS = "owner,profile,users,defaultRoles,parents,children,policies,teamType";
    private Team organization = null;

    public TeamRepository(CollectionDAO dao) {
        super("/v1/teams/", "team", Team.class, dao.teamDAO(), dao, "owner,profile,users,defaultRoles,parents,children,policies,teamType", "owner,profile,users,defaultRoles,parents,children,policies,teamType");
    }

    @Override
    public Team setFields(Team team, EntityUtil.Fields fields) throws IOException {
        if (!fields.contains("profile")) {
            team.setProfile(null);
        }
        team.setUsers(fields.contains("users") ? this.getUsers(team) : null);
        team.setOwns(fields.contains("owns") ? this.getOwns(team) : null);
        team.setDefaultRoles(fields.contains("defaultRoles") ? this.getDefaultRoles(team) : null);
        team.setInheritedRoles(fields.contains("defaultRoles") ? this.getInheritedRoles(team) : null);
        team.setOwner(fields.contains("owner") ? this.getOwner(team) : null);
        team.setParents(fields.contains("parents") ? this.getParents(team) : null);
        team.setChildren(fields.contains("children") ? this.getChildren(team.getId()) : null);
        team.setPolicies(fields.contains("policies") ? this.getPolicies(team) : null);
        team.setChildrenCount(fields.contains("childrenCount") ? this.getChildrenCount(team) : null);
        team.setUserCount(fields.contains("userCount") ? this.getUserCount(team.getId()) : null);
        return team;
    }

    private List<EntityReference> getInheritedRoles(Team team) throws IOException {
        return SubjectCache.getInstance().getRolesForTeams(this.getParentsForInheritedRoles(team));
    }

    @Override
    public void restorePatchAttributes(Team original, Team updated) {
        updated.withName(original.getName()).withId(original.getId());
        updated.withInheritedRoles(original.getInheritedRoles());
    }

    @Override
    public void prepare(Team team) throws IOException {
        this.setFullyQualifiedName(team);
        this.populateParents(team);
        this.populateChildren(team);
        this.validateUsers(team.getUsers());
        this.validateRoles(team.getDefaultRoles());
        this.validatePolicies(team.getPolicies());
    }

    @Override
    public void storeEntity(Team team, boolean update) throws IOException {
        EntityReference owner = team.getOwner();
        List users = team.getUsers();
        List defaultRoles = team.getDefaultRoles();
        List parents = team.getParents();
        List children = team.getChildren();
        List policies = team.getPolicies();
        team.withUsers(null).withDefaultRoles(null).withHref(null).withOwner(null).withInheritedRoles(null);
        this.store(team.getId(), team, update);
        team.withUsers(users).withDefaultRoles(defaultRoles).withOwner(owner).withParents(parents).withChildren(children).withPolicies(policies);
    }

    @Override
    public void storeRelationships(Team team) {
        this.storeOwner(team, team.getOwner());
        for (EntityReference user : CommonUtil.listOrEmpty((List)team.getUsers())) {
            this.addRelationship(team.getId(), user.getId(), "team", "user", Relationship.HAS);
        }
        for (EntityReference defaultRole : CommonUtil.listOrEmpty((List)team.getDefaultRoles())) {
            this.addRelationship(team.getId(), defaultRole.getId(), "team", "role", Relationship.HAS);
        }
        for (EntityReference parent : CommonUtil.listOrEmpty((List)team.getParents())) {
            if (parent.getId().equals(this.organization.getId())) continue;
            this.addRelationship(parent.getId(), team.getId(), "team", "team", Relationship.PARENT_OF);
        }
        for (EntityReference child : CommonUtil.listOrEmpty((List)team.getChildren())) {
            this.addRelationship(team.getId(), child.getId(), "team", "team", Relationship.PARENT_OF);
        }
        for (EntityReference policy : CommonUtil.listOrEmpty((List)team.getPolicies())) {
            this.addRelationship(team.getId(), policy.getId(), "team", "policy", Relationship.HAS);
        }
    }

    public TeamUpdater getUpdater(Team original, Team updated, EntityRepository.Operation operation) {
        return new TeamUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Team entity) {
        if (entity.getId().equals(this.organization.getId())) {
            throw new IllegalArgumentException("Organization team type can't be deleted");
        }
    }

    @Override
    protected void cleanup(Team team) throws IOException {
        this.getParents(team);
        for (EntityReference child : CommonUtil.listOrEmpty((List)team.getChildren())) {
            Team childTeam = (Team)this.dao.findEntityById(child.getId());
            this.getParents(childTeam);
            if (childTeam.getParents().size() != 1) continue;
            this.addRelationship(this.organization.getId(), childTeam.getId(), "team", "team", Relationship.PARENT_OF);
            LOG.info("Moving parent of team " + childTeam.getId() + " to organization");
        }
        super.cleanup(team);
        SubjectCache.getInstance().invalidateTeam(team.getId());
    }

    private TeamHierarchy getTeamHierarchy(Team team) {
        return new TeamHierarchy().withId(team.getId()).withTeamType(team.getTeamType()).withName(team.getName()).withDisplayName(team.getDisplayName()).withHref(team.getHref()).withFullyQualifiedName(team.getFullyQualifiedName()).withIsJoinable(team.getIsJoinable()).withChildren(null);
    }

    private TeamHierarchy deepCopy(TeamHierarchy team) {
        TeamHierarchy newTeam = new TeamHierarchy().withId(team.getId()).withTeamType(team.getTeamType()).withName(team.getName()).withDisplayName(team.getDisplayName()).withHref(team.getHref()).withFullyQualifiedName(team.getFullyQualifiedName()).withIsJoinable(team.getIsJoinable());
        if (team.getChildren() != null) {
            ArrayList<TeamHierarchy> children = new ArrayList<TeamHierarchy>();
            for (TeamHierarchy n : team.getChildren()) {
                children.add(this.deepCopy(n));
            }
            newTeam.withChildren(children);
        }
        return newTeam;
    }

    private TeamHierarchy mergeTrees(TeamHierarchy team1, TeamHierarchy team2) {
        List team1Children = team1.getChildren();
        List team2Children = team2.getChildren();
        if (team1Children != null && team2Children != null) {
            ArrayList toMerge = new ArrayList(team1Children);
            toMerge.retainAll(team2Children);
            for (TeamHierarchy n : toMerge) {
                this.mergeTrees(n, (TeamHierarchy)team2Children.get(team2Children.indexOf(n)));
            }
        }
        if (team2Children != null) {
            ArrayList toAdd = new ArrayList(team2Children);
            if (team1Children != null) {
                toAdd.removeAll(team1Children);
            } else {
                team1.setChildren(new ArrayList());
            }
            for (TeamHierarchy n : toAdd) {
                team1.getChildren().add(this.deepCopy(n));
            }
        }
        return team1;
    }

    public List<TeamHierarchy> listHierarchy(ListFilter filter, int limit, Boolean isJoinable) throws IOException {
        EntityUtil.Fields fields = this.getFields("parents");
        HashMap map = new HashMap();
        ResultList resultList = this.listAfter(null, fields, filter, limit, null);
        List allTeams = resultList.getData();
        List<Team> joinableTeams = allTeams.stream().filter(Boolean.TRUE.equals(isJoinable) ? Team::getIsJoinable : t -> true).filter(t -> !t.getName().equals("Organization")).collect(Collectors.toList());
        joinableTeams.forEach(team -> {
            Team currentTeam = team;
            TeamHierarchy currentHierarchy = this.getTeamHierarchy((Team)team);
            while (currentTeam != null && currentTeam.getParents().size() > 0 && !((EntityReference)currentTeam.getParents().get(0)).getName().equals("Organization")) {
                EntityReference parentRef = (EntityReference)currentTeam.getParents().get(0);
                Team parent = allTeams.stream().filter(t -> t.getId().equals(parentRef.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unexpected error occurred while building the teams hierarchy"));
                currentHierarchy = this.getTeamHierarchy(parent).withChildren(new ArrayList<TeamHierarchy>(List.of(currentHierarchy)));
                if (map.containsKey(parent.getId())) {
                    TeamHierarchy parentTeam = (TeamHierarchy)map.get(parent.getId());
                    currentHierarchy = this.mergeTrees(parentTeam, currentHierarchy);
                    currentTeam = allTeams.stream().filter(t -> t.getId().equals(parent.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unexpected error occurred while building the teams hierarchy"));
                    continue;
                }
                currentTeam = parent;
            }
            UUID currentId = currentHierarchy.getId();
            if (!map.containsKey(currentId)) {
                map.put(currentId, currentHierarchy);
            } else {
                map.put(currentId, this.mergeTrees((TeamHierarchy)map.get(currentId), currentHierarchy));
            }
        });
        return new ArrayList<TeamHierarchy>(map.values());
    }

    private List<EntityReference> getUsers(Team team) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> userIds = this.findTo(team.getId(), "team", Relationship.HAS, "user");
        return EntityUtil.populateEntityReferences(userIds, "user");
    }

    private Integer getUserCount(UUID teamId) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> userIds = this.findTo(teamId, "team", Relationship.HAS, "user");
        int userCount = userIds.size();
        List<EntityReference> children = this.getChildren(teamId);
        for (EntityReference child : children) {
            userCount += this.getUserCount(child.getId()).intValue();
        }
        return userCount;
    }

    private List<EntityReference> getOwns(Team team) throws IOException {
        return EntityUtil.getEntityReferences(this.daoCollection.relationshipDAO().findTo(team.getId().toString(), "team", Relationship.OWNS.ordinal()));
    }

    private List<EntityReference> getDefaultRoles(Team team) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> defaultRoleIds = this.findTo(team.getId(), "team", Relationship.HAS, "role");
        return EntityUtil.populateEntityReferences(defaultRoleIds, "role");
    }

    private List<EntityReference> getParents(Team team) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> relationshipRecords = this.findFrom(team.getId(), "team", Relationship.PARENT_OF, "team");
        List<EntityReference> parents = EntityUtil.populateEntityReferences(relationshipRecords, "team");
        if (this.organization != null && CommonUtil.listOrEmpty(parents).isEmpty() && !team.getId().equals(this.organization.getId())) {
            return new ArrayList<EntityReference>(List.of(this.organization.getEntityReference()));
        }
        return parents;
    }

    private List<EntityReference> getParentsForInheritedRoles(Team team) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> relationshipRecords = this.findFrom(team.getId(), "team", Relationship.PARENT_OF, "team");
        List<EntityReference> parents = EntityUtil.populateEntityReferences(relationshipRecords, "team").stream().filter(e -> e.getDeleted() == false).collect(Collectors.toList());
        if (this.organization != null && CommonUtil.listOrEmpty(parents).isEmpty() && !team.getId().equals(this.organization.getId())) {
            return new ArrayList<EntityReference>(List.of(this.organization.getEntityReference()));
        }
        return parents;
    }

    private List<EntityReference> getChildren(UUID teamId) throws IOException {
        if (teamId.equals(this.organization.getId())) {
            List<String> children = this.daoCollection.teamDAO().listTeamsUnderOrganization(teamId.toString());
            return EntityUtil.populateEntityReferencesById(children, "team");
        }
        List<CollectionDAO.EntityRelationshipRecord> children = this.findTo(teamId, "team", Relationship.PARENT_OF, "team");
        return EntityUtil.populateEntityReferences(children, "team");
    }

    private Integer getChildrenCount(Team team) throws IOException {
        return this.getChildren(team.getId()).size();
    }

    private List<EntityReference> getPolicies(Team team) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> policies = this.findTo(team.getId(), "team", Relationship.HAS, "policy");
        return EntityUtil.populateEntityReferences(policies, "policy");
    }

    private void populateChildren(Team team) throws IOException {
        List childrenRefs = team.getChildren();
        if (childrenRefs == null) {
            return;
        }
        List<Team> children = this.getTeams(childrenRefs);
        switch (team.getTeamType()) {
            case GROUP: {
                if (children.isEmpty()) break;
                throw new IllegalArgumentException("Team of type Group can't have children of type team. Only users are allowed as part of the team");
            }
            case DEPARTMENT: {
                this.validateChildren(team, children, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.GROUP);
                break;
            }
            case DIVISION: {
                this.validateChildren(team, children, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.GROUP);
                break;
            }
            case BUSINESS_UNIT: 
            case ORGANIZATION: {
                this.validateChildren(team, children, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.GROUP);
            }
        }
        this.populateTeamRefs(childrenRefs, children);
    }

    private void populateParents(Team team) throws IOException {
        List parentRefs = CommonUtil.listOrEmpty((List)team.getParents());
        if (parentRefs.isEmpty() && !team.getName().equals("Organization")) {
            team.setParents(new ArrayList());
            team.getParents().add(this.organization.getEntityReference());
            return;
        }
        List<Team> parents = this.getTeams(parentRefs);
        switch (team.getTeamType()) {
            case GROUP: 
            case DEPARTMENT: {
                this.validateParents(team, parents, CreateTeam.TeamType.DEPARTMENT, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case DIVISION: {
                this.validateSingleParent(team, parentRefs);
                this.validateParents(team, parents, CreateTeam.TeamType.DIVISION, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case BUSINESS_UNIT: {
                this.validateSingleParent(team, parentRefs);
                this.validateParents(team, parents, CreateTeam.TeamType.BUSINESS_UNIT, CreateTeam.TeamType.ORGANIZATION);
                break;
            }
            case ORGANIZATION: {
                if (parentRefs.isEmpty()) break;
                throw new IllegalArgumentException("Team of type Organization can't have a parent team");
            }
        }
        this.populateTeamRefs(parentRefs, parents);
    }

    private void populateTeamRefs(List<EntityReference> teamRefs, List<Team> teams) {
        for (int i = 0; i < teams.size(); ++i) {
            EntityUtil.copy(teams.get(i).getEntityReference(), teamRefs.get(i));
        }
    }

    private List<Team> getTeams(List<EntityReference> teamRefs) throws IOException {
        ArrayList<Team> teams = new ArrayList<Team>();
        for (EntityReference teamRef : teamRefs) {
            try {
                Team team = (Team)this.dao.findEntityById(teamRef.getId());
                teams.add(team);
            }
            catch (EntityNotFoundException ex) {
                LOG.debug("Failed to populate team since it might be soft deleted.", (Throwable)ex);
                this.dao.findEntityById(teamRef.getId(), Include.DELETED);
            }
        }
        return teams;
    }

    private void validateParents(Team team, List<Team> relatedTeams, CreateTeam.TeamType ... allowedTeamTypes) {
        List<CreateTeam.TeamType> allowed = Arrays.asList(allowedTeamTypes);
        for (Team relatedTeam : relatedTeams) {
            if (allowed.contains(relatedTeam.getTeamType())) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidParent(relatedTeam, team.getName(), team.getTeamType()));
        }
    }

    private void validateChildren(Team team, List<Team> children, CreateTeam.TeamType ... allowedTeamTypes) {
        List<CreateTeam.TeamType> allowed = Arrays.asList(allowedTeamTypes);
        for (Team child : children) {
            if (allowed.contains(child.getTeamType())) continue;
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidChild(team.getName(), team.getTeamType(), child));
        }
    }

    private void validateSingleParent(Team team, List<EntityReference> parentRefs) {
        if (CommonUtil.listOrEmpty(parentRefs).size() != 1) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidParentCount(1, team.getTeamType()));
        }
    }

    public void initOrganization() throws IOException {
        String json = this.dao.findJsonByFqn("Organization", Include.ALL);
        if (json == null) {
            LOG.debug("Organization {} is not initialized", (Object)"Organization");
            try {
                EntityReference organizationPolicy = Entity.getEntityReferenceByName("policy", "OrganizationPolicy", Include.ALL);
                EntityReference dataConsumerRole = Entity.getEntityReferenceByName("role", "DataConsumer", Include.ALL);
                Team team = new Team().withId(UUID.randomUUID()).withName("Organization").withDisplayName("Organization").withDescription("Organization under which all the other team hierarchy is created").withTeamType(CreateTeam.TeamType.ORGANIZATION).withUpdatedBy("admin").withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withPolicies(new ArrayList<EntityReference>(List.of(organizationPolicy))).withDefaultRoles(new ArrayList<EntityReference>(List.of(dataConsumerRole)));
                this.organization = this.create(null, team);
                LOG.info("Organization {}:{} is successfully initialized", (Object)"Organization", (Object)this.organization.getId());
            }
            catch (Exception e) {
                LOG.error("Failed to initialize organization", (Throwable)e);
                throw e;
            }
        } else {
            this.organization = JsonUtils.readValue(json, Team.class);
            LOG.info("Organization is already initialized");
        }
    }

    public class TeamUpdater
    extends EntityRepository.EntityUpdater {
        public TeamUpdater(Team original, Team updated, EntityRepository.Operation operation) {
            super((EntityRepository)TeamRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            if (((Team)this.original).getTeamType() != ((Team)this.updated).getTeamType()) {
                if (CreateTeam.TeamType.GROUP.equals((Object)((Team)this.original).getTeamType())) {
                    throw new IllegalArgumentException("Team of type Group cannot be updated");
                }
                if (((Team)this.original).getChildren().size() > 0 && CreateTeam.TeamType.GROUP.equals((Object)((Team)this.updated).getTeamType())) {
                    throw new IllegalArgumentException("A team with children cannot be updated to type Group");
                }
            }
            this.recordChange("profile", ((Team)this.original).getProfile(), ((Team)this.updated).getProfile());
            this.recordChange("isJoinable", ((Team)this.original).getIsJoinable(), ((Team)this.updated).getIsJoinable());
            this.recordChange("teamType", ((Team)this.original).getTeamType(), ((Team)this.updated).getTeamType());
            this.updateUsers((Team)this.original, (Team)this.updated);
            this.updateDefaultRoles((Team)this.original, (Team)this.updated);
            this.updateParents((Team)this.original, (Team)this.updated);
            this.updateChildren((Team)this.original, (Team)this.updated);
            this.updatePolicies((Team)this.original, (Team)this.updated);
        }

        private void updateUsers(Team origTeam, Team updatedTeam) throws JsonProcessingException {
            List origUsers = CommonUtil.listOrEmpty((List)origTeam.getUsers());
            List updatedUsers = CommonUtil.listOrEmpty((List)updatedTeam.getUsers());
            this.updateToRelationships("users", "team", origTeam.getId(), Relationship.HAS, "user", origUsers, updatedUsers, false);
        }

        private void updateDefaultRoles(Team origTeam, Team updatedTeam) throws JsonProcessingException {
            List origDefaultRoles = CommonUtil.listOrEmpty((List)origTeam.getDefaultRoles());
            List updatedDefaultRoles = CommonUtil.listOrEmpty((List)updatedTeam.getDefaultRoles());
            this.updateToRelationships("defaultRoles", "team", origTeam.getId(), Relationship.HAS, "role", origDefaultRoles, updatedDefaultRoles, false);
        }

        private void updateParents(Team original, Team updated) throws JsonProcessingException {
            List origParents = CommonUtil.listOrEmpty((List)original.getParents());
            List updatedParents = CommonUtil.listOrEmpty((List)updated.getParents());
            this.updateFromRelationships("parents", "team", origParents, updatedParents, Relationship.PARENT_OF, "team", original.getId());
        }

        private void updateChildren(Team original, Team updated) throws JsonProcessingException {
            List origParents = CommonUtil.listOrEmpty((List)original.getChildren());
            List updatedParents = CommonUtil.listOrEmpty((List)updated.getChildren());
            this.updateToRelationships("children", "team", original.getId(), Relationship.PARENT_OF, "team", origParents, updatedParents, false);
        }

        private void updatePolicies(Team original, Team updated) throws JsonProcessingException {
            List origPolicies = CommonUtil.listOrEmpty((List)original.getPolicies());
            List updatedPolicies = CommonUtil.listOrEmpty((List)updated.getPolicies());
            this.updateToRelationships("policies", "team", original.getId(), Relationship.HAS, "policy", origPolicies, updatedPolicies, false);
        }
    }
}

