/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.lmax.disruptor.BatchEventProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.schema.type.WebhookType;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.MSTeamsWebhookPublisher;
import org.openmetadata.service.events.WebhookPublisher;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.slack.SlackWebhookEventPublisher;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookRepository
extends EntityRepository<Webhook> {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookRepository.class);
    private static final ConcurrentHashMap<UUID, WebhookPublisher> webhookPublisherMap = new ConcurrentHashMap();

    public WebhookRepository(CollectionDAO dao) {
        super("v1/webhook/", "webhook", Webhook.class, dao.webhookDAO(), dao, "", "");
    }

    @Override
    public Webhook setFields(Webhook entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public void prepare(Webhook entity) {
        this.setFullyQualifiedName(entity);
    }

    @Override
    public void storeEntity(Webhook entity, boolean update) throws IOException {
        entity.setHref(null);
        this.store(entity.getId(), entity, update);
    }

    @Override
    public void storeRelationships(Webhook entity) {
    }

    @Override
    public void restorePatchAttributes(Webhook original, Webhook updated) {
        updated.withId(original.getId()).withName(original.getName());
    }

    public WebhookUpdater getUpdater(Webhook original, Webhook updated, EntityRepository.Operation operation) {
        return new WebhookUpdater(original, updated, operation);
    }

    private WebhookPublisher getPublisher(UUID id) {
        return webhookPublisherMap.get(id);
    }

    public void addWebhookPublisher(Webhook webhook) {
        if (Boolean.FALSE.equals(webhook.getEnabled())) {
            webhook.setStatus(Webhook.Status.DISABLED);
            return;
        }
        WebhookPublisher publisher = webhook.getWebhookType() == WebhookType.slack ? new SlackWebhookEventPublisher(webhook, this.daoCollection) : (webhook.getWebhookType() == WebhookType.msteams ? new MSTeamsWebhookPublisher(webhook, this.daoCollection) : new WebhookPublisher(webhook, this.daoCollection));
        BatchEventProcessor<EventPubSub.ChangeEventHolder> processor = EventPubSub.addEventHandler(publisher);
        publisher.setProcessor(processor);
        webhookPublisherMap.put(webhook.getId(), publisher);
        LOG.info("Webhook subscription started for {}", (Object)webhook.getName());
    }

    public void updateWebhookPublisher(Webhook webhook) {
        if (Boolean.TRUE.equals(webhook.getEnabled())) {
            WebhookPublisher previousPublisher = this.getPublisher(webhook.getId());
            if (previousPublisher == null) {
                this.addWebhookPublisher(webhook);
                return;
            }
            Webhook.Status status = previousPublisher.getWebhook().getStatus();
            previousPublisher.updateWebhook(webhook);
            if (status != Webhook.Status.ACTIVE && status != Webhook.Status.AWAITING_RETRY) {
                BatchEventProcessor<EventPubSub.ChangeEventHolder> processor = EventPubSub.addEventHandler(previousPublisher);
                previousPublisher.setProcessor(processor);
                LOG.info("Webhook publisher restarted for {}", (Object)webhook.getName());
            }
        } else {
            this.deleteWebhookPublisher(webhook.getId());
        }
    }

    public void deleteWebhookPublisher(UUID id) throws InterruptedException {
        WebhookPublisher publisher = webhookPublisherMap.get(id);
        if (publisher != null) {
            publisher.getProcessor().halt();
            publisher.awaitShutdown();
            EventPubSub.removeProcessor(publisher.getProcessor());
            LOG.info("Webhook publisher deleted for {}", (Object)publisher.getWebhook().getName());
        }
        webhookPublisherMap.remove(id);
    }

    public class WebhookUpdater
    extends EntityRepository.EntityUpdater {
        public WebhookUpdater(Webhook original, Webhook updated, EntityRepository.Operation operation) {
            super((EntityRepository)WebhookRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("enabled", ((Webhook)this.original).getEnabled(), ((Webhook)this.updated).getEnabled());
            this.recordChange("status", ((Webhook)this.original).getStatus(), ((Webhook)this.updated).getStatus());
            this.recordChange("endPoint", ((Webhook)this.original).getEndpoint(), ((Webhook)this.updated).getEndpoint());
            this.recordChange("batchSize", ((Webhook)this.original).getBatchSize(), ((Webhook)this.updated).getBatchSize());
            this.recordChange("timeout", ((Webhook)this.original).getTimeout(), ((Webhook)this.updated).getTimeout());
            this.updateEventFilters();
            if (this.fieldsChanged()) {
                WebhookPublisher publisher = WebhookRepository.this.getPublisher(((Webhook)this.original).getId());
                if (publisher != null && this.updated != publisher.getWebhook()) {
                    ((Webhook)this.updated).withStatus(publisher.getWebhook().getStatus()).withFailureDetails(publisher.getWebhook().getFailureDetails());
                    if (Boolean.FALSE.equals(((Webhook)this.updated).getEnabled())) {
                        ((Webhook)this.updated).setStatus(Webhook.Status.DISABLED);
                    }
                }
                this.recordChange("failureDetails", ((Webhook)this.original).getFailureDetails(), ((Webhook)this.updated).getFailureDetails(), true, EntityUtil.failureDetailsMatch);
            }
        }

        private void updateEventFilters() throws JsonProcessingException {
            List origFilter = ((Webhook)this.original).getEventFilters();
            List updatedFilter = ((Webhook)this.updated).getEventFilters();
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("eventFilters", origFilter, updatedFilter, added, deleted, EntityUtil.eventFilterMatch);
        }
    }
}

