/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.type.CollectionDescriptor;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1")
@Api(value="All collections in the catalog application", tags={"All collections in the Catalog"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="root")
public class CatalogResource {
    private static CollectionList collectionList;

    public static CollectionList getCollectionList(UriInfo uriInfo) {
        if (collectionList == null) {
            CollectionDescriptor[] collections = CollectionRegistry.getInstance().getCollectionForPath("/v1", uriInfo);
            collectionList = new CollectionList(Arrays.asList(collections));
        }
        return collectionList;
    }

    @GET
    @Operation(operationId="listCollections", summary="List all collections", tags={"catalog"}, description="List all the collections supported by OpenMetadata. This list provides all the collections and resource REST endpoints.", responses={@ApiResponse(responseCode="200", description="All collections", content={@Content(mediaType="application/json", schema=@Schema(implementation=CollectionList.class))})})
    public CollectionList getCollections(@Context UriInfo uriInfo) {
        return CatalogResource.getCollectionList(uriInfo);
    }

    public static class CollectionList
    extends ResultList<CollectionDescriptor> {
        public CollectionList() {
        }

        public CollectionList(List<CollectionDescriptor> data) {
            super(data);
        }
    }
}

