/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.charts;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateChart;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ChartRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/charts")
@Api(value="Chart data asset collection", tags={"Chart data asset collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="charts")
public class ChartResource
extends EntityResource<Chart, ChartRepository> {
    public static final String COLLECTION_PATH = "v1/charts/";
    static final String FIELDS = "owner,followers,tags";

    @Override
    public Chart addHref(UriInfo uriInfo, Chart chart) {
        chart.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, chart.getId()));
        Entity.withHref(uriInfo, chart.getOwner());
        Entity.withHref(uriInfo, chart.getService());
        Entity.withHref(uriInfo, chart.getFollowers());
        return chart;
    }

    public ChartResource(CollectionDAO dao, Authorizer authorizer) {
        super(Chart.class, new ChartRepository(dao), authorizer);
    }

    @GET
    @Operation(operationId="listCharts", summary="List charts", tags={"charts"}, description="Get a list of charts, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of charts", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChartList.class))})})
    public ResultList<Chart> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter charts by service name", schema=@Schema(type="string", example="superset")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number charts returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of charts before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of charts after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllChartVersions", summary="List chart versions", tags={"charts"}, description="Get a list of all the versions of a chart identified by `id`", responses={@ApiResponse(responseCode="200", description="List of chart versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Chart Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getChartByID", summary="Get a Chart", tags={"charts"}, description="Get a chart by `id`.", responses={@ApiResponse(responseCode="200", description="The chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=Chart.class))}), @ApiResponse(responseCode="404", description="Chart for instance {id} is not found")})
    public Chart get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Chart)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getChartByFQN", summary="Get a chart by name", tags={"charts"}, description="Get a chart by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=Chart.class))}), @ApiResponse(responseCode="404", description="Chart for instance {id} is not found")})
    public Chart getByName(@Context UriInfo uriInfo, @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Chart)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificChartVersion", summary="Get a version of the chart", tags={"charts"}, description="Get a version of the chart by given `id`", responses={@ApiResponse(responseCode="200", description="chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=Chart.class))}), @ApiResponse(responseCode="404", description="Chart for instance {id} and version {version} is not found")})
    public Chart getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Chart Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Chart version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Chart)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createChart", summary="Create a chart", tags={"charts"}, description="Create a chart under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The chart", content={@Content(mediaType="application/json", schema=@Schema(implementation=Chart.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateChart create) throws IOException {
        Chart chart = this.getChart(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, chart, true);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchChart", summary="Update a chart", tags={"charts"}, description="Update an existing chart using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PUT
    @Operation(operationId="createOrUpdateChart", summary="Create or update chart", tags={"charts"}, description="Create a chart, it it does not exist or update an existing chart.", responses={@ApiResponse(responseCode="200", description="The updated chart ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Chart.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateChart create) throws IOException {
        Chart chart = this.getChart(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, chart, true);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollowerToChart", summary="Add a follower", tags={"charts"}, description="Add a user identified by `userId` as followed of this chart", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Chart for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the chart", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) throws IOException {
        return ((ChartRepository)this.dao).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollowerFromChart", summary="Remove a follower", tags={"charts"}, description="Remove the user identified `userId` as a follower of the chart.")
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the chart", schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) throws IOException {
        return ((ChartRepository)this.dao).deleteFollower(securityContext.getUserPrincipal().getName(), UUID.fromString(id), UUID.fromString(userId)).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteChart", summary="Delete a Chart", tags={"charts"}, description="Delete a chart by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Chart for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Chart Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, false, hardDelete, true);
    }

    private Chart getChart(CreateChart create, String user) throws IOException {
        return this.copy(new Chart(), (CreateEntity)create, user).withService(create.getService()).withChartType(create.getChartType()).withChartUrl(create.getChartUrl()).withTables(create.getTables()).withTags(create.getTags());
    }

    public static class ChartList
    extends ResultList<Chart> {
        ChartList() {
        }

        public ChartList(List<Chart> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

