/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.config;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.slackChat.SlackChatConfiguration;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.airflow.AirflowConfigurationForAPI;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.sandbox.SandboxConfiguration;
import org.openmetadata.service.security.jwt.JWKSResponse;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;

@Path(value="/v1/config")
@Api(value="Get configuration")
@Produces(value={"application/json"})
@Collection(name="config")
public class ConfigResource {
    private OpenMetadataApplicationConfig openMetadataApplicationConfig;
    private final JWTTokenGenerator jwtTokenGenerator = JWTTokenGenerator.getInstance();

    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        this.openMetadataApplicationConfig = config;
    }

    @GET
    @Path(value="/auth")
    @Operation(operationId="getAuthConfiguration", summary="Get auth configuration", tags={"config"}, responses={@ApiResponse(responseCode="200", description="Auth configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationConfiguration.class))})})
    public AuthenticationConfiguration getAuthConfig() {
        AuthenticationConfiguration authenticationConfiguration = new AuthenticationConfiguration();
        if (this.openMetadataApplicationConfig.getAuthenticationConfiguration() != null) {
            authenticationConfiguration = this.openMetadataApplicationConfig.getAuthenticationConfiguration();
        }
        return authenticationConfiguration;
    }

    @GET
    @Path(value="/authorizer")
    @Operation(operationId="getAuthorizerConfig", summary="Get authorizer configuration", tags={"config"}, responses={@ApiResponse(responseCode="200", description="Authorizer configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthorizerConfiguration.class))})})
    public AuthorizerConfiguration getAuthorizerConfig() {
        AuthorizerConfiguration authorizerConfiguration = new AuthorizerConfiguration();
        if (this.openMetadataApplicationConfig.getAuthorizerConfiguration() != null) {
            authorizerConfiguration = this.openMetadataApplicationConfig.getAuthorizerConfiguration();
        }
        return authorizerConfiguration;
    }

    @GET
    @Path(value="/sandbox")
    @Operation(operationId="getSandboxConfiguration", summary="Get sandbox mode", tags={"config"}, responses={@ApiResponse(responseCode="200", description="Sandbox mode", content={@Content(mediaType="application/json", schema=@Schema(implementation=SandboxConfiguration.class))})})
    public SandboxConfiguration getSandboxMode() {
        SandboxConfiguration sandboxConfiguration = new SandboxConfiguration();
        if (this.openMetadataApplicationConfig.isSandboxModeEnabled()) {
            sandboxConfiguration.setSandboxModeEnabled(true);
        }
        return sandboxConfiguration;
    }

    @GET
    @Path(value="/slackChat")
    @Operation(operationId="getSlackChatConfiguration", summary="Get Slack Chat Configuration", tags={"config"}, responses={@ApiResponse(responseCode="200", description="Get Slack Chat Configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=SlackChatConfiguration.class))})})
    public SlackChatConfiguration getSlackChatConfiguration() {
        SlackChatConfiguration slackChatConfiguration = new SlackChatConfiguration();
        if (this.openMetadataApplicationConfig.getSlackChatConfiguration() != null) {
            slackChatConfiguration = this.openMetadataApplicationConfig.getSlackChatConfiguration();
        }
        return slackChatConfiguration;
    }

    @GET
    @Path(value="/airflow")
    @Operation(operationId="getAirflowConfiguration", summary="Get airflow configuration", tags={"config"}, responses={@ApiResponse(responseCode="200", description="Airflow configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AirflowConfigurationForAPI.class))})})
    public AirflowConfigurationForAPI getAirflowConfig() {
        AirflowConfigurationForAPI airflowConfigurationForAPI = new AirflowConfigurationForAPI();
        if (this.openMetadataApplicationConfig.getAirflowConfiguration() != null) {
            airflowConfigurationForAPI.setApiEndpoint(this.openMetadataApplicationConfig.getAirflowConfiguration().getApiEndpoint());
        }
        return airflowConfigurationForAPI;
    }

    @GET
    @Path(value="/jwks")
    @Operation(operationId="getJWKSResponse", summary="Get JWKS public key", tags={"config"}, responses={@ApiResponse(responseCode="200", description="JWKS public key", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWKSResponse.class))})})
    public JWKSResponse getJWKSResponse() {
        return this.jwtTokenGenerator.getJWKSResponse();
    }
}

