/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.events;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.events.CreateWebhook;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.schema.type.WebhookType;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.WebhookRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/webhook")
@Api(value="Webhook resource", tags={"webhook"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="webhook")
public class WebhookResource
extends EntityResource<Webhook, WebhookRepository> {
    public static final String COLLECTION_PATH = "v1/webhook/";
    private final CollectionDAO.WebhookDAO webhookDAO;

    @Override
    public Webhook addHref(UriInfo uriInfo, Webhook entity) {
        return entity;
    }

    public WebhookResource(CollectionDAO dao, Authorizer authorizer) {
        super(Webhook.class, new WebhookRepository(dao), authorizer);
        this.webhookDAO = dao.webhookDAO();
    }

    public void initialize(OpenMetadataApplicationConfig config) {
        try {
            List<String> listAllWebhooks = this.webhookDAO.listAllWebhooks(this.webhookDAO.getTableName());
            List<Webhook> webhookList = JsonUtils.readObjects(listAllWebhooks, Webhook.class);
            webhookList.forEach(((WebhookRepository)this.dao)::addWebhookPublisher);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @GET
    @Operation(operationId="listWebHooks", summary="List webhooks", tags={"webhook"}, description="Get a list of webhook subscriptions", responses={@ApiResponse(responseCode="200", description="List of webhooks", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebhookList.class))})})
    public ResultList<Webhook> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Filter webhooks by status", schema=@Schema(type="string", example="active")) @QueryParam(value="status") String statusParam, @Parameter(description="Filter webhooks by type", schema=@Schema(type="string", example="generic, slack, msteams")) @QueryParam(value="webhookType") String typeParam, @Parameter(description="Limit the number webhooks returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of webhooks before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of webhooks after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(Include.ALL).addQueryParam("status", statusParam).addQueryParam("webhookType", typeParam);
        return this.listInternal(uriInfo, securityContext, "", filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="getWebHookByID", summary="Get a webhook", tags={"webhook"}, description="Get a webhook by given Id", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Webhook get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="webhook Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Webhook)this.getInternal(uriInfo, securityContext, id, "", include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getWebHookByFQN", summary="Get a webhook by name", tags={"webhook"}, description="Get a webhook by name.", responses={@ApiResponse(responseCode="200", description="webhook", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="404", description="Webhook for instance {id} is not found")})
    public Webhook getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the webhook", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Webhook)this.getByNameInternal(uriInfo, securityContext, name, "", include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllWebHookVersion", summary="List webhook versions", tags={"webhook"}, description="Get a list of all the versions of a webhook identified by `id`", responses={@ApiResponse(responseCode="200", description="List of webhook versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="webhook Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificWebhookVersion", summary="Get a version of the webhook", tags={"webhook"}, description="Get a version of the webhook by given `id`", responses={@ApiResponse(responseCode="200", description="webhook", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="404", description="Webhook for instance {id} and version {version} is not found")})
    public Webhook getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="webhook Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="webhook version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Webhook)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createWebHook", summary="Subscribe to a new webhook", tags={"webhook"}, description="Subscribe to a new webhook", responses={@ApiResponse(responseCode="200", description="webhook", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createWebhook(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWebhook create) throws IOException {
        Webhook webhook = this.getWebhook(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, webhook, false);
        ((WebhookRepository)this.dao).addWebhookPublisher(webhook);
        return response;
    }

    @PUT
    @Operation(operationId="createOrUpdateWebhook", summary="Updated an existing or create a new webhook", tags={"webhook"}, description="Updated an existing or create a new webhook", responses={@ApiResponse(responseCode="200", description="webhook", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response updateWebhook(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWebhook create) throws IOException {
        Webhook webhook = this.getWebhook(create, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, webhook, true);
        ((WebhookRepository)this.dao).updateWebhookPublisher((Webhook)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchWebHook", summary="Update a webhook", tags={"webhook"}, description="Update an existing webhook using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        Response response = this.patchInternal(uriInfo, securityContext, id, patch);
        ((WebhookRepository)this.dao).updateWebhookPublisher((Webhook)response.getEntity());
        return response;
    }

    @DELETE
    @Path(value="/{id}")
    @Valid
    @Operation(operationId="deleteWebHook", summary="Delete a webhook", tags={"webhook"}, description="Get a webhook by given Id", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public Response deleteWebhook(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="webhook Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException, InterruptedException {
        Response response = this.delete(uriInfo, securityContext, id, false, true, false);
        ((WebhookRepository)this.dao).deleteWebhookPublisher(id);
        return response;
    }

    public Webhook getWebhook(CreateWebhook create, String user) throws IOException {
        return this.copy(new Webhook(), (CreateEntity)create, user).withEndpoint(create.getEndpoint()).withEventFilters(create.getEventFilters()).withBatchSize(create.getBatchSize()).withTimeout(create.getTimeout()).withEnabled(create.getEnabled()).withSecretKey(create.getSecretKey()).withStatus(Boolean.TRUE.equals(create.getEnabled()) ? Webhook.Status.ACTIVE : Webhook.Status.DISABLED).withWebhookType(create.getWebhookType() == null ? WebhookType.generic : create.getWebhookType());
    }

    public static class WebhookList
    extends ResultList<Webhook> {
        public WebhookList() {
        }

        public WebhookList(List<Webhook> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

