/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.glossary;

import com.google.inject.Inject;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateGlossary;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.GlossaryRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/glossaries")
@Api(value="Glossary collection", tags={"Glossary collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="glossaries")
public class GlossaryResource
extends EntityResource<Glossary, GlossaryRepository> {
    public static final String COLLECTION_PATH = "v1/glossaries/";
    static final String FIELDS = "owner,tags,reviewers,usageCount";

    @Override
    public Glossary addHref(UriInfo uriInfo, Glossary glossary) {
        glossary.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, glossary.getId()));
        Entity.withHref(uriInfo, glossary.getOwner());
        Entity.withHref(uriInfo, glossary.getReviewers());
        return glossary;
    }

    @Inject
    public GlossaryResource(CollectionDAO dao, Authorizer authorizer) {
        super(Glossary.class, new GlossaryRepository(dao), authorizer);
    }

    @GET
    @Valid
    @Operation(operationId="listGlossaries", summary="List Glossaries", tags={"glossaries"}, description="Get a list of glossaries. Use `fields` parameter to get only necessary fields.  Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of glossaries", content={@Content(mediaType="application/json", schema=@Schema(implementation=GlossaryList.class))})})
    public ResultList<Glossary> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,reviewers,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number glossaries returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of glossaries before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of glossaries after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getGlossaryByID", summary="Get a glossary", tags={"glossaries"}, description="Get a glossary by `id`.", responses={@ApiResponse(responseCode="200", description="The glossary", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {id} is not found")})
    public Glossary get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,reviewers,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Glossary)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getGlossaryByFQN", summary="Get a glossary by name", tags={"glossaries"}, description="Get a glossary by name.", responses={@ApiResponse(responseCode="200", description="The glossary", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {id} is not found")})
    public Glossary getByName(@Context UriInfo uriInfo, @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,reviewers,usageCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Glossary)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllGlossaryVersion", summary="List glossary versions", tags={"glossaries"}, description="Get a list of all the versions of a glossary identified by `id`", responses={@ApiResponse(responseCode="200", description="List of glossary versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="glossary Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificGlossaryVersion", summary="Get a version of the glossaries", tags={"glossaries"}, description="Get a version of the glossary by given `id`", responses={@ApiResponse(responseCode="200", description="glossaries", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="404", description="Glossary for instance {id} and version {version} is not found")})
    public Glossary getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="glossary Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="glossary version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Glossary)super.getVersionInternal(securityContext, id, version);
    }

    @POST
    @Operation(operationId="createGlossary", summary="Create a glossary", tags={"glossaries"}, description="Create a new glossary.", responses={@ApiResponse(responseCode="200", description="The glossary", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateGlossary create) throws IOException {
        Glossary glossary = this.getGlossary(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, glossary, true);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchGlossary", summary="Update a glossary", tags={"glossaries"}, description="Update an existing glossary using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PUT
    @Operation(operationId="createOrUpdateGlossary", summary="Create or update a glossary", tags={"glossaries"}, description="Create a new glossary, if it does not exist or update an existing glossary.", responses={@ApiResponse(responseCode="200", description="The glossary", content={@Content(mediaType="application/json", schema=@Schema(implementation=Glossary.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateGlossary create) throws IOException {
        Glossary glossary = this.getGlossary(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, glossary, true);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteGlossary", summary="Delete a Glossary", tags={"glossaries"}, description="Delete a glossary by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="glossary for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Glossary Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete, true);
    }

    private Glossary getGlossary(CreateGlossary create, String user) throws IOException {
        return this.copy(new Glossary(), (CreateEntity)create, user).withReviewers(create.getReviewers()).withTags(create.getTags());
    }

    public static class GlossaryList
    extends ResultList<Glossary> {
        GlossaryList() {
        }

        public GlossaryList(List<Glossary> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

