/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services;

import java.io.IOException;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.annotations.utils.AnnotationChecker;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.jdbi3.ServiceEntityRepository;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

public abstract class ServiceEntityResource<T extends ServiceEntityInterface, R extends ServiceEntityRepository<T, S>, S extends ServiceConnectionEntityInterface>
extends EntityResource<T, R> {
    private final ServiceEntityRepository<T, S> serviceEntityRepository;
    private final ServiceType serviceType;

    protected ServiceEntityResource(Class<T> entityClass, R serviceRepository, Authorizer authorizer, ServiceType serviceType) {
        super(entityClass, serviceRepository, authorizer);
        this.serviceEntityRepository = serviceRepository;
        this.serviceType = serviceType;
    }

    protected T decryptOrNullify(SecurityContext securityContext, T service) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        try {
            this.authorizer.authorizeAdmin(securityContext, secretsManager.isLocal());
        }
        catch (AuthorizationException e) {
            return this.nullifyRequiredConnectionParameters(service);
        }
        service.getConnection().setConfig(this.retrieveServiceConnectionConfig(service));
        return service;
    }

    private Object retrieveServiceConnectionConfig(T service) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        return secretsManager.encryptOrDecryptServiceConnectionConfig(service.getConnection().getConfig(), this.extractServiceType(service), service.getName(), this.serviceType, false);
    }

    protected ResultList<T> decryptOrNullify(SecurityContext securityContext, ResultList<T> services) {
        CommonUtil.listOrEmpty(services.getData()).forEach(service -> this.decryptOrNullify(securityContext, service));
        return services;
    }

    protected T nullifyRequiredConnectionParameters(T service) {
        Object connectionConfig = this.retrieveServiceConnectionConfig(service);
        if (AnnotationChecker.isExposedFieldPresent(connectionConfig.getClass())) {
            try {
                service.getConnection().setConfig(JsonUtils.toExposedEntity(connectionConfig, connectionConfig.getClass()));
                return service;
            }
            catch (IOException e) {
                throw new UnhandledServerException(e.getMessage(), e.getCause());
            }
        }
        return this.nullifyConnection(service);
    }

    protected abstract T nullifyConnection(T var1);

    protected abstract String extractServiceType(T var1);

    public ServiceEntityRepository<T, S> getServiceEntityRepository() {
        return this.serviceEntityRepository;
    }
}

