/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.messaging;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.services.CreateMessagingService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MessagingConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.MessagingServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/services/messagingServices")
@Api(value="Messaging service collection", tags={"Services -> Messaging service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="messagingServices")
public class MessagingServiceResource
extends ServiceEntityResource<MessagingService, MessagingServiceRepository, MessagingConnection> {
    public static final String COLLECTION_PATH = "v1/services/messagingServices/";
    public static final String FIELDS = "owner";

    @Override
    public MessagingService addHref(UriInfo uriInfo, MessagingService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        return service;
    }

    public MessagingServiceResource(CollectionDAO dao, Authorizer authorizer) {
        super(MessagingService.class, new MessagingServiceRepository(dao), authorizer, ServiceType.MESSAGING);
    }

    @GET
    @Operation(operationId="listMessagingService", summary="List messaging services", tags={"MessagingService"}, description="Get a list of messaging services. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of messaging services", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingServiceList.class))})})
    public ResultList<MessagingService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit number services returned. (1 to 1000000, default 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include);
        ResultList messagingServices = super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, messagingServices));
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getMessagingServiceByID", summary="Get a messaging service", tags={"MessagingService"}, description="Get a messaging service by `id`.", responses={@ApiResponse(responseCode="200", description="Messaging service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingService.class))}), @ApiResponse(responseCode="404", description="Messaging service for instance {id} is not found")})
    public MessagingService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        MessagingService messagingService = (MessagingService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, messagingService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getMessagingServiceByFQN", summary="Get messaging service by name", tags={"MessagingService"}, description="Get a messaging service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Messaging service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingService.class))}), @ApiResponse(responseCode="404", description="Messaging service for instance {id} is not found")})
    public MessagingService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        MessagingService messagingService = (MessagingService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, messagingService);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllMessagingServiceVersion", summary="List messaging service versions", tags={"MessagingService"}, description="Get a list of all the versions of a messaging service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of messaging service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="messaging service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                MessagingService messagingService = JsonUtils.readValue((String)json, MessagingService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, messagingService));
            }
            catch (IOException e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificMessagingServiceVersion", summary="Get a version of the messaging service", tags={"MessagingService"}, description="Get a version of the messaging service by given `id`", responses={@ApiResponse(responseCode="200", description="messaging service", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingService.class))}), @ApiResponse(responseCode="404", description="Messaging service for instance {id} and version {version} is not found")})
    public MessagingService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="messaging service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="messaging service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        MessagingService messagingService = (MessagingService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, messagingService);
    }

    @POST
    @Operation(operationId="createMessagingService", summary="Create a messaging service", tags={"MessagingService"}, description="Create a new messaging service.", responses={@ApiResponse(responseCode="200", description="Messaging service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMessagingService create) throws IOException {
        MessagingService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service, true);
        this.decryptOrNullify(securityContext, (MessagingService)response.getEntity());
        return response;
    }

    @PUT
    @Operation(operationId="createOrUpdateMessagingService", summary="Update messaging service", tags={"MessagingService"}, description="Create a new messaging service or Update an existing messaging service identified by `id`.", responses={@ApiResponse(responseCode="200", description="Messaging service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=MessagingService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateMessagingService update) throws IOException {
        MessagingService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, service, true);
        this.decryptOrNullify(securityContext, (MessagingService)response.getEntity());
        return response;
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteMessagingService", summary="Delete a messaging service", tags={"MessagingService"}, description="Delete a messaging service. If topics belong the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="MessagingService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the messaging service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete, true);
    }

    private MessagingService getService(CreateMessagingService create, String user) throws IOException {
        return this.copy(new MessagingService(), (CreateEntity)create, user).withConnection(create.getConnection()).withServiceType(create.getServiceType());
    }

    @Override
    protected MessagingService nullifyConnection(MessagingService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(MessagingService service) {
        return service.getServiceType().value();
    }

    public static class MessagingServiceList
    extends ResultList<MessagingService> {
        public MessagingServiceList() {
        }

        public MessagingServiceList(List<MessagingService> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

