/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.settings;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.SettingsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsCache {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsCache.class);
    private static final SettingsCache INSTANCE = new SettingsCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<String, Settings> SETTINGS_CACHE;
    protected static SettingsRepository SETTINGS_REPOSITORY;

    public static void initialize(CollectionDAO dao) {
        if (!INITIALIZED) {
            SETTINGS_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new SettingsLoader());
            SETTINGS_REPOSITORY = new SettingsRepository(dao);
            INITIALIZED = true;
        }
    }

    public static SettingsCache getInstance() {
        return INSTANCE;
    }

    public Settings getEventFilters() throws EntityNotFoundException {
        try {
            return (Settings)SETTINGS_CACHE.get((Object)SettingsType.ACTIVITY_FEED_FILTER_SETTING.toString());
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public void putSettings(Settings setting) throws RuntimeException {
        SETTINGS_CACHE.put((Object)setting.getConfigType().toString(), (Object)setting);
    }

    public static void cleanUp() {
        SETTINGS_CACHE.invalidateAll();
        INITIALIZED = false;
    }

    public void invalidateSettings(String settingsName) {
        try {
            SETTINGS_CACHE.invalidate((Object)settingsName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for settings {}", (Object)settingsName, (Object)ex);
        }
    }

    static class SettingsLoader
    extends CacheLoader<String, Settings> {
        SettingsLoader() {
        }

        public Settings load(@CheckForNull String settingsName) {
            Settings setting = SETTINGS_REPOSITORY.getConfigWithKey(settingsName);
            LOG.info("Loaded Setting {}", (Object)setting.getConfigType());
            return setting;
        }
    }
}

