/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openmetadata.schema.api.services.ingestionPipelines.TestServiceConnection;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.JsonUtils;

public class NoopSecretsManager
extends SecretsManager {
    private static NoopSecretsManager INSTANCE;
    private Fernet fernet = Fernet.getInstance();

    private NoopSecretsManager(String clusterPrefix) {
        super(SecretsManagerProvider.NOOP, clusterPrefix);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Object encryptOrDecryptServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType, boolean encrypt) {
        try {
            Class<?> clazz = this.createConnectionConfigClass(connectionType, this.extractConnectionPackageName(serviceType));
            Object newConnectionConfig = JsonUtils.convertValue(connectionConfig, clazz);
            this.encryptOrDecryptField(newConnectionConfig, "Password", clazz, encrypt);
            return newConnectionConfig;
        }
        catch (Exception e) {
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to construct connection instance of %s", connectionType));
        }
    }

    @Override
    public Object encryptOrDecryptDbtConfigSource(Object dbtConfigSource, String serviceName, boolean encrypt) {
        return dbtConfigSource;
    }

    @Override
    public Object storeTestConnectionObject(TestServiceConnection testServiceConnection) {
        return testServiceConnection.getConnection();
    }

    @Override
    public Object encryptOrDecryptBotUserCredentials(String botUserName, Object securityConfig, boolean encrypt) {
        return securityConfig;
    }

    @Override
    public Object encryptOrDecryptBotCredentials(String botName, String botUserName, boolean encrypt) {
        return null;
    }

    private void encryptOrDecryptField(Object connConfig, String field, Class<?> clazz, boolean encrypt) throws InvocationTargetException, IllegalAccessException {
        try {
            Method getPasswordMethod = clazz.getMethod("get" + field, new Class[0]);
            Method setPasswordMethod = clazz.getMethod("set" + field, String.class);
            String password = (String)getPasswordMethod.invoke(connConfig, new Object[0]);
            if (password != null) {
                if (!Fernet.isTokenized(password) && encrypt) {
                    password = this.fernet.encrypt(password);
                } else if (Fernet.isTokenized(password) && !encrypt) {
                    password = this.fernet.decrypt(password);
                }
                setPasswordMethod.invoke(connConfig, password);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static NoopSecretsManager getInstance(String clusterPrefix) {
        if (INSTANCE == null) {
            INSTANCE = new NoopSecretsManager(clusterPrefix);
        }
        return INSTANCE;
    }

    @VisibleForTesting
    void setFernet(Fernet fernet) {
        this.fernet = fernet;
    }
}

