/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.openmetadata.schema.api.services.ingestionPipelines.TestServiceConnection;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataServerConnection;
import org.openmetadata.schema.services.connections.metadata.SecretsManagerProvider;
import org.openmetadata.schema.teams.authn.JWTAuthMechanism;
import org.openmetadata.schema.teams.authn.SSOAuthMechanism;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;

public abstract class ThirdPartySecretsManager
extends SecretsManager {
    public static final String DATABASE_METADATA_PIPELINE_SECRET_ID_PREFIX = "database-metadata-pipeline";
    public static final String TEST_CONNECTION_TEMP_SECRET_ID_PREFIX = "test-connection-temp";
    public static final String BOT_USER_PREFIX = "bot-user";
    public static final String BOT_PREFIX = "bot";
    public static final String AUTH_PROVIDER = "auth-provider";
    public static final String NULL_SECRET_STRING = "null";

    protected ThirdPartySecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        super(secretsManagerProvider, clusterPrefix);
    }

    @Override
    public Object encryptOrDecryptServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType, boolean encrypt) {
        String secretName = this.buildSecretId("service", serviceType.value(), connectionType, connectionName);
        try {
            if (encrypt) {
                this.validateServiceConnection(connectionConfig, connectionType, serviceType);
                String connectionConfigJson = JsonUtils.pojoToJson(connectionConfig);
                if (connectionConfigJson != null) {
                    this.upsertSecret(secretName, connectionConfigJson);
                }
                return null;
            }
            Class<?> clazz = this.createConnectionConfigClass(connectionType, this.extractConnectionPackageName(serviceType));
            return JsonUtils.readValue(this.getSecret(secretName), clazz);
        }
        catch (ClassNotFoundException | InvalidServiceConnectionException ex) {
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to construct connection instance of %s", connectionType));
        }
        catch (Exception e) {
            throw SecretsManagerException.byMessage(this.getClass().getSimpleName(), secretName, e.getMessage());
        }
    }

    @Override
    public Object storeTestConnectionObject(TestServiceConnection testServiceConnection) {
        String secretName = this.buildSecretId(TEST_CONNECTION_TEMP_SECRET_ID_PREFIX, testServiceConnection.getConnectionType().value());
        try {
            String connectionConfigJson = JsonUtils.pojoToJson(testServiceConnection.getConnection());
            this.upsertSecret(secretName, connectionConfigJson);
        }
        catch (JsonProcessingException e) {
            throw new SecretsManagerException("Error parsing to JSON the service connection config: " + e.getMessage());
        }
        return null;
    }

    @Override
    public Object encryptOrDecryptBotUserCredentials(String botUserName, Object securityConfig, boolean encrypt) {
        String secretName = this.buildSecretId(BOT_USER_PREFIX, botUserName);
        return this.encryptOrDecryptObject(securityConfig, encrypt, secretName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object encryptOrDecryptBotCredentials(String botName, String botUserName, boolean encrypt) {
        String secretName = this.buildSecretId(BOT_PREFIX, botName);
        if (!encrypt) return this.encryptOrDecryptObject(null, false, secretName);
        try {
            Object authConfig = this.encryptOrDecryptBotUserCredentials(botUserName, null, false);
            User botUser = (User)((UserRepository)UserRepository.class.cast(Entity.getEntityRepository("user"))).getByName(null, botUserName, new EntityUtil.Fields(List.of("authenticationMechanism")));
            AuthenticationMechanism authMechanism = botUser.getAuthenticationMechanism();
            if (authMechanism == null) return null;
            String authProviderSecretName = this.buildSecretId(BOT_PREFIX, botName, AUTH_PROVIDER);
            String authProvider = null;
            if (AuthenticationMechanism.AuthType.JWT.equals((Object)authMechanism.getAuthType())) {
                JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authConfig, JWTAuthMechanism.class);
                this.encryptOrDecryptObject(new OpenMetadataJWTClientConfig().withJwtToken(jwtAuthMechanism.getJWTToken()), true, secretName);
                authProvider = OpenMetadataServerConnection.AuthProvider.OPENMETADATA.value();
            } else if (authConfig != null && AuthenticationMechanism.AuthType.SSO.equals((Object)authMechanism.getAuthType())) {
                this.encryptOrDecryptObject(JsonUtils.convertValue(authConfig, SSOAuthMechanism.class).getAuthConfig(), true, secretName);
                authProvider = OpenMetadataServerConnection.AuthProvider.fromValue((String)((String)JsonUtils.getMap(authConfig).get("ssoServiceType"))).value();
            }
            this.encryptOrDecryptObject(authProvider, true, authProviderSecretName);
            return null;
        }
        catch (Exception e) {
            throw SecretsManagerException.byMessage(this.getClass().getSimpleName(), secretName, e.getMessage());
        }
    }

    @Override
    public Object encryptOrDecryptDbtConfigSource(Object dbtConfigSource, String serviceName, boolean encrypt) {
        String secretName = this.buildSecretId(DATABASE_METADATA_PIPELINE_SECRET_ID_PREFIX, serviceName);
        return this.encryptOrDecryptObject(dbtConfigSource, encrypt, secretName);
    }

    @Nullable
    private Object encryptOrDecryptObject(Object objectValue, boolean encrypt, String secretName) {
        try {
            if (encrypt) {
                String securityConfigJson = JsonUtils.pojoToJson(objectValue);
                this.upsertSecret(secretName, securityConfigJson);
                return null;
            }
            String securityConfigJson = this.getSecret(secretName);
            return NULL_SECRET_STRING.equals(securityConfigJson) ? null : JsonUtils.readValue(securityConfigJson, Object.class);
        }
        catch (Exception e) {
            throw SecretsManagerException.byMessage(this.getClass().getSimpleName(), secretName, e.getMessage());
        }
    }

    private void upsertSecret(String secretName, String secretValue) {
        if (this.existSecret(secretName)) {
            this.updateSecret(secretName, secretValue != null ? secretValue : NULL_SECRET_STRING);
        } else {
            this.storeSecret(secretName, secretValue != null ? secretValue : NULL_SECRET_STRING);
        }
    }

    public boolean existSecret(String secretName) {
        try {
            return this.getSecret(secretName) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    abstract void storeSecret(String var1, String var2);

    abstract void updateSecret(String var1, String var2);

    abstract String getSecret(String var1);
}

