/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.schema.api.configuration.airflow.AirflowConfiguration;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.BotType;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.teams.authn.BasicAuthMechanism;
import org.openmetadata.schema.teams.authn.JWTAuthMechanism;
import org.openmetadata.schema.teams.authn.JWTTokenExpiry;
import org.openmetadata.schema.teams.authn.SSOAuthMechanism;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.PolicyCache;
import org.openmetadata.service.security.policyevaluator.PolicyEvaluator;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.RoleCache;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.PasswordUtil;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizer
implements Authorizer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizer.class);
    private static final String COLON_DELIMITER = ":";
    private static final String DEFAULT_ADMIN = "admin";
    private Set<String> adminUsers;
    private Set<String> botPrincipalUsers;
    private Set<String> testUsers;
    private String principalDomain;
    private String providerType;
    private boolean isSmtpEnabled;

    @Override
    public void init(OpenMetadataApplicationConfig openMetadataApplicationConfig, Jdbi dbi) {
        LOG.info("Initializing DefaultAuthorizer with config {}", (Object)openMetadataApplicationConfig.getAuthorizerConfiguration());
        this.adminUsers = new HashSet<String>(openMetadataApplicationConfig.getAuthorizerConfiguration().getAdminPrincipals());
        this.botPrincipalUsers = new HashSet<String>(openMetadataApplicationConfig.getAuthorizerConfiguration().getBotPrincipals());
        this.testUsers = new HashSet<String>(openMetadataApplicationConfig.getAuthorizerConfiguration().getTestPrincipals());
        this.principalDomain = openMetadataApplicationConfig.getAuthorizerConfiguration().getPrincipalDomain();
        this.providerType = openMetadataApplicationConfig.getAuthenticationConfiguration().getProvider();
        SmtpSettings smtpSettings = openMetadataApplicationConfig.getSmtpSettings();
        this.isSmtpEnabled = smtpSettings != null && smtpSettings.getEnableSmtpServer() != false;
        SubjectCache.initialize();
        PolicyCache.initialize();
        RoleCache.initialize();
        LOG.debug("Admin users: {}", this.adminUsers);
        this.initializeUsers(openMetadataApplicationConfig);
    }

    private void initializeUsers(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        User user;
        String domain;
        LOG.debug("Checking user entries for admin users");
        String string = domain = this.principalDomain.isEmpty() ? "openmetadata.org" : this.principalDomain;
        if (!this.providerType.equals(SSOAuthMechanism.SsoServiceType.BASIC.value())) {
            for (String adminUser : this.adminUsers) {
                User user2 = this.user(adminUser, domain, adminUser).withIsAdmin(Boolean.valueOf(true));
                this.addOrUpdateUser(user2);
            }
        } else {
            try {
                this.handleBasicAuth(this.adminUsers, domain);
            }
            catch (IOException e) {
                LOG.error("Failed in Basic Auth Setup. Reason : {}", (Object)e.getMessage());
            }
        }
        LOG.debug("Checking user entries for bot users");
        Set botUsers = Arrays.stream(BotType.values()).map(BotType::value).collect(Collectors.toSet());
        botUsers.remove(BotType.BOT.value());
        botUsers.addAll(this.botPrincipalUsers);
        for (String botUser : botUsers) {
            BotType botType;
            user = this.user(botUser, domain, botUser).withIsBot(Boolean.valueOf(true)).withIsAdmin(Boolean.valueOf(false));
            if ((user = this.addOrUpdateBotUser(user, openMetadataApplicationConfig)) == null) continue;
            try {
                botType = BotType.fromValue((String)botUser);
            }
            catch (IllegalArgumentException e) {
                botType = BotType.BOT;
            }
            Bot bot = this.bot(user).withBotUser(user.getEntityReference()).withBotType(botType);
            this.addOrUpdateBot(bot);
        }
        LOG.debug("Checking user entries for test users");
        for (String testUser : this.testUsers) {
            user = this.user(testUser, domain, testUser);
            this.addOrUpdateUser(user);
        }
    }

    private void handleBasicAuth(Set<String> adminUsers, String domain) throws IOException {
        for (String adminUser : adminUsers) {
            if (adminUser.contains(COLON_DELIMITER)) {
                String[] tokens = adminUser.split(COLON_DELIMITER);
                this.addUserForBasicAuth(tokens[0], tokens[1], domain);
                continue;
            }
            boolean isDefaultAdmin = adminUser.equals(DEFAULT_ADMIN);
            String token = PasswordUtil.generateRandomPassword();
            if (isDefaultAdmin || !this.isSmtpEnabled) {
                token = DEFAULT_ADMIN;
            }
            this.addUserForBasicAuth(adminUser, token, domain);
        }
    }

    private void addUserForBasicAuth(String username, String pwd, String domain) throws IOException {
        block3: {
            EntityRepository userRepository = Entity.getEntityRepository("user");
            try {
                List<String> fields = userRepository.getAllowedFieldsCopy();
                fields.add("authenticationMechanism");
                User originalUser = (User)userRepository.getByName(null, username, new EntityUtil.Fields(fields, String.join((CharSequence)",", fields)));
                if (originalUser.getAuthenticationMechanism() == null) {
                    this.updateUserWithHashedPwd(originalUser, pwd);
                }
                this.addOrUpdateUser(originalUser);
            }
            catch (EntityNotFoundException e) {
                User user = this.user(username, domain, username).withIsAdmin(Boolean.valueOf(true)).withIsEmailVerified(Boolean.valueOf(true));
                this.updateUserWithHashedPwd(user, pwd);
                this.addOrUpdateUser(user);
                if (!this.isSmtpEnabled) break block3;
                this.sendInviteMailToAdmin(user, pwd);
            }
        }
    }

    private void sendInviteMailToAdmin(User user, String pwd) {
        HashMap<String, String> templatePopulator = new HashMap<String, String>();
        templatePopulator.put("entity", EmailUtil.getInstance().getEmailingEntity());
        templatePopulator.put("supportUrl", EmailUtil.getInstance().getSupportUrl());
        templatePopulator.put("userName", user.getName());
        templatePopulator.put("password", pwd);
        templatePopulator.put("applicationLoginLink", EmailUtil.getInstance().getOMUrl());
        try {
            EmailUtil.getInstance().sendMail(EmailUtil.getInstance().getEmailInviteSubject(), templatePopulator, user.getEmail(), "/emailTemplates", "invite-randompwd.ftl");
        }
        catch (Exception ex) {
            LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)user.getEmail(), (Object)ex.getMessage());
        }
    }

    private void updateUserWithHashedPwd(User user, String pwd) {
        String hashedPwd = BCrypt.withDefaults().hashToString(12, pwd.toCharArray());
        user.setAuthenticationMechanism(new AuthenticationMechanism().withAuthType(AuthenticationMechanism.AuthType.BASIC).withConfig((Object)new BasicAuthMechanism().withPassword(hashedPwd)));
    }

    private User user(String name, String domain, String updatedBy) {
        return new User().withId(UUID.randomUUID()).withName(name).withFullyQualifiedName(name).withEmail(name + "@" + domain).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withIsBot(Boolean.valueOf(false));
    }

    private Bot bot(User user) {
        return new Bot().withId(UUID.randomUUID()).withName(user.getName()).withFullyQualifiedName(user.getName()).withUpdatedBy(user.getUpdatedBy()).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withDisplayName(user.getName());
    }

    @Override
    public List<ResourcePermission> listPermissions(SecurityContext securityContext, String user) {
        SubjectContext subjectContext = this.getSubjectContext(securityContext);
        if ((subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() || subjectContext.isBot()) {
            return PolicyEvaluator.getResourcePermissions(Permission.Access.ALLOW);
        }
        return PolicyEvaluator.listPermission(subjectContext);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, String resourceType) {
        SubjectContext subjectContext = this.getSubjectContext(securityContext);
        if ((subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() || subjectContext.isBot()) {
            return PolicyEvaluator.getResourcePermission(resourceType, Permission.Access.ALLOW);
        }
        return PolicyEvaluator.getPermission(subjectContext, resourceType);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, ResourceContextInterface resourceContext) {
        SubjectContext subjectContext = this.getSubjectContext(securityContext);
        if ((subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() || subjectContext.isBot()) {
            return PolicyEvaluator.getResourcePermission(resourceContext.getResource(), Permission.Access.ALLOW);
        }
        return PolicyEvaluator.getPermission(subjectContext, resourceContext);
    }

    @Override
    public boolean isOwner(SecurityContext securityContext, EntityReference owner) {
        if (owner == null) {
            return false;
        }
        try {
            SubjectContext subjectContext = this.getSubjectContext(securityContext);
            return subjectContext.isOwner(owner);
        }
        catch (EntityNotFoundException ex) {
            return false;
        }
    }

    @Override
    public void authorize(SecurityContext securityContext, OperationContext operationContext, ResourceContextInterface resourceContext, boolean allowBots) throws IOException {
        SubjectContext subjectContext = this.getSubjectContext(securityContext);
        if (subjectContext.isAdmin() || allowBots && subjectContext.isBot()) {
            return;
        }
        PolicyEvaluator.hasPermission(subjectContext, resourceContext, operationContext);
    }

    @Override
    public void authorizeAdmin(SecurityContext securityContext, boolean allowBots) {
        SubjectContext subjectContext = this.getSubjectContext(securityContext);
        if (subjectContext.isAdmin() || allowBots && subjectContext.isBot()) {
            return;
        }
        throw new AuthorizationException(CatalogExceptionMessage.notAdmin(securityContext.getUserPrincipal().getName()));
    }

    private User addOrUpdateUser(User user) {
        EntityRepository<User> userRepository = Entity.getEntityRepository("user");
        try {
            RestUtil.PutResponse<User> addedUser = userRepository.createOrUpdate(null, user);
            LOG.debug("Added user entry: {}", (Object)addedUser.getEntity().getName());
            return addedUser.getEntity();
        }
        catch (Exception exception) {
            LOG.debug("Caught exception: {}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            user.setAuthenticationMechanism(null);
            LOG.debug("User entry: {} already exists.", (Object)user.getName());
            return null;
        }
    }

    private User addOrUpdateBotUser(User user, OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        AuthenticationMechanism authMechanism;
        User originalUser = this.retrieveAuthMechanism(user);
        AuthenticationMechanism authenticationMechanism = authMechanism = originalUser != null ? originalUser.getAuthenticationMechanism() : null;
        if (authMechanism == null) {
            AuthenticationConfiguration authConfig = openMetadataApplicationConfig.getAuthenticationConfiguration();
            AirflowConfiguration airflowConfig = openMetadataApplicationConfig.getAirflowConfiguration();
            if ("openmetadata".equals(airflowConfig.getAuthProvider()) && !"basic".equals(authConfig.getProvider())) {
                OpenMetadataJWTClientConfig jwtClientConfig = airflowConfig.getAuthConfig().getOpenmetadata();
                authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, new JWTAuthMechanism().withJWTToken(jwtClientConfig.getJwtToken()).withJWTTokenExpiry(JWTTokenExpiry.Unlimited));
            } else if (airflowConfig.getAuthConfig() != null && !"basic".equals(authConfig.getProvider())) {
                switch (authConfig.getProvider()) {
                    case "no-auth": {
                        break;
                    }
                    case "azure": {
                        authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, this.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AZURE, airflowConfig.getAuthConfig().getAzure()));
                        break;
                    }
                    case "google": {
                        authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, this.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.GOOGLE, airflowConfig.getAuthConfig().getGoogle()));
                        break;
                    }
                    case "okta": {
                        authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, this.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.OKTA, airflowConfig.getAuthConfig().getOkta()));
                        break;
                    }
                    case "auth0": {
                        authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, this.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.AUTH_0, airflowConfig.getAuthConfig().getAuth0()));
                        break;
                    }
                    case "custom-oidc": {
                        authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.SSO, this.buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType.CUSTOM_OIDC, airflowConfig.getAuthConfig().getCustomOidc()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unexpected auth provider [%s] for bot [%s]", authConfig.getProvider(), user.getName()));
                    }
                }
            } else if ("basic".equals(authConfig.getProvider())) {
                authMechanism = this.buildAuthMechanism(AuthenticationMechanism.AuthType.JWT, JWTTokenGenerator.getInstance().generateJWTToken(user, JWTTokenExpiry.Unlimited));
            }
        }
        user.setAuthenticationMechanism(authMechanism);
        user.setDescription(user.getDescription());
        user.setDisplayName(user.getDisplayName());
        return this.addOrUpdateUser(user);
    }

    private SSOAuthMechanism buildAuthMechanismConfig(SSOAuthMechanism.SsoServiceType ssoServiceType, Object config) {
        return new SSOAuthMechanism().withSsoServiceType(ssoServiceType).withAuthConfig(config);
    }

    private AuthenticationMechanism buildAuthMechanism(AuthenticationMechanism.AuthType authType, Object config) {
        return new AuthenticationMechanism().withAuthType(authType).withConfig(config);
    }

    private User retrieveAuthMechanism(User user) {
        EntityRepository userRepository = (EntityRepository)UserRepository.class.cast(Entity.getEntityRepository("user"));
        try {
            User originalUser = (User)userRepository.getByName(null, user.getName(), new EntityUtil.Fields(List.of("authenticationMechanism")));
            AuthenticationMechanism authMechanism = originalUser.getAuthenticationMechanism();
            SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
            if (authMechanism != null) {
                Object config = secretsManager.encryptOrDecryptBotUserCredentials(user.getName(), authMechanism.getConfig(), false);
                authMechanism.setConfig(config != null ? config : authMechanism.getConfig());
            }
            return originalUser;
        }
        catch (IOException | EntityNotFoundException e) {
            LOG.debug("Bot entity: {} does not exists.", (Object)user);
            return null;
        }
    }

    private void addOrUpdateBot(Bot bot) {
        EntityRepository botRepository = (EntityRepository)BotRepository.class.cast(Entity.getEntityRepository("bot"));
        try {
            Bot originalBot = (Bot)botRepository.getByName(null, bot.getName(), EntityUtil.Fields.EMPTY_FIELDS);
            bot.setBotUser(originalBot.getBotUser());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RestUtil.PutResponse<Bot> addedBot = botRepository.createOrUpdate(null, bot);
            LOG.debug("Added bot entry: {}", (Object)addedBot.getEntity().getName());
        }
        catch (Exception exception) {
            LOG.debug("Caught exception: {}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            LOG.debug("Bot entry: {} already exists.", (Object)bot.getName());
        }
    }

    private SubjectContext getSubjectContext(SecurityContext securityContext) {
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw new AuthenticationException("No principal in security context");
        }
        return this.getSubjectContext(SecurityUtil.getUserName(securityContext.getUserPrincipal()));
    }

    private SubjectContext getSubjectContext(String userName) {
        return SubjectCache.getInstance().getSubjectContext(userName);
    }

    private SubjectContext changeSubjectContext(String user, SubjectContext loggedInUser) {
        if (user != null && !loggedInUser.getUser().getName().equals(user)) {
            if (!loggedInUser.isAdmin()) {
                throw new AuthorizationException(CatalogExceptionMessage.notAdmin(loggedInUser.getUser().getName()));
            }
            LOG.debug("Changing subject context from logged-in user to {}", (Object)user);
            return this.getSubjectContext(user);
        }
        return loggedInUser;
    }
}

