/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonPatch;
import lombok.NonNull;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.util.JsonPatchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationContext {
    private static final Logger LOG = LoggerFactory.getLogger(OperationContext.class);
    @NonNull
    private final String resource;
    List<MetadataOperation> operations;
    private JsonPatch patch;

    public OperationContext(@NonNull String resource, MetadataOperation ... operations) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
        this.operations = new ArrayList<MetadataOperation>();
        this.operations.addAll(List.of(operations));
    }

    public OperationContext(@NonNull String resource, JsonPatch patch) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
        this.patch = patch;
    }

    public List<MetadataOperation> getOperations() {
        if (this.operations != null) {
            return this.operations;
        }
        if (this.patch != null) {
            this.operations = new ArrayList<MetadataOperation>();
            this.operations.addAll(JsonPatchUtils.getMetadataOperations(this.patch));
        }
        return this.operations;
    }

    public void allowAll() {
        LOG.debug("allowAll operations");
        this.operations.clear();
    }

    public void allowViewAll() {
        LOG.debug("allowViewAll operations");
        this.operations.removeIf(OperationContext::isViewOperation);
    }

    public void allowEditAll() {
        LOG.debug("allowEditAll operations");
        this.operations.removeIf(OperationContext::isEditOperation);
    }

    public static boolean isEditOperation(MetadataOperation operation) {
        return operation.value().startsWith("Edit");
    }

    public static boolean isViewOperation(MetadataOperation operation) {
        return operation.value().startsWith("View");
    }

    @NonNull
    public String getResource() {
        return this.resource;
    }

    public JsonPatch getPatch() {
        return this.patch;
    }
}

