/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;

public class ResourceContext
implements ResourceContextInterface {
    @NonNull
    private String resource;
    @NonNull
    private EntityRepository<? extends EntityInterface> entityRepository;
    private UUID id;
    private String name;
    private EntityInterface entity;

    @Override
    public EntityReference getOwner() throws IOException {
        this.resolveEntity();
        return this.entity == null ? null : this.entity.getOwner();
    }

    @Override
    public List<TagLabel> getTags() throws IOException {
        this.resolveEntity();
        return this.entity == null ? null : CommonUtil.listOrEmpty((List)this.entity.getTags());
    }

    @Override
    public EntityInterface getEntity() throws IOException {
        return this.resolveEntity();
    }

    private EntityInterface resolveEntity() throws IOException {
        if (this.entity == null) {
            String fields = "";
            if (this.entityRepository.isSupportsOwner()) {
                fields = EntityUtil.addField(fields, "owner");
            }
            if (this.entityRepository.isSupportsTags()) {
                fields = EntityUtil.addField(fields, "tags");
            }
            if (this.id != null) {
                this.entity = this.entityRepository.get(null, this.id, this.entityRepository.getFields(fields));
            } else if (this.name != null) {
                this.entity = this.entityRepository.getByName(null, this.name, this.entityRepository.getFields(fields));
            }
        }
        return this.entity;
    }

    ResourceContext(@NonNull String resource, @NonNull EntityRepository<? extends EntityInterface> entityRepository, UUID id, String name, EntityInterface entity) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (entityRepository == null) {
            throw new NullPointerException("entityRepository is marked non-null but is null");
        }
        this.resource = resource;
        this.entityRepository = entityRepository;
        this.id = id;
        this.name = name;
        this.entity = entity;
    }

    public static ResourceContextBuilder builder() {
        return new ResourceContextBuilder();
    }

    @Override
    @NonNull
    public String getResource() {
        return this.resource;
    }

    public static class ResourceContextBuilder {
        private String resource;
        private EntityRepository<? extends EntityInterface> entityRepository;
        private UUID id;
        private String name;
        private EntityInterface entity;

        ResourceContextBuilder() {
        }

        public ResourceContextBuilder resource(@NonNull String resource) {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.resource = resource;
            return this;
        }

        public ResourceContextBuilder entityRepository(@NonNull EntityRepository<? extends EntityInterface> entityRepository) {
            if (entityRepository == null) {
                throw new NullPointerException("entityRepository is marked non-null but is null");
            }
            this.entityRepository = entityRepository;
            return this;
        }

        public ResourceContextBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public ResourceContextBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ResourceContextBuilder entity(EntityInterface entity) {
            this.entity = entity;
            return this;
        }

        public ResourceContext build() {
            return new ResourceContext(this.resource, this.entityRepository, this.id, this.name, this.entity);
        }

        public String toString() {
            return "ResourceContext.ResourceContextBuilder(resource=" + this.resource + ", entityRepository=" + this.entityRepository + ", id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + ")";
        }
    }
}

