/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache {
    private static final Logger LOG = LoggerFactory.getLogger(RoleCache.class);
    private static final RoleCache INSTANCE = new RoleCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<UUID, Role> ROLE_CACHE;
    private static EntityRepository<Role> ROLE_REPOSITORY;
    private static EntityUtil.Fields FIELDS;

    public static RoleCache getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!INITIALIZED) {
            ROLE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new RoleLoader());
            ROLE_REPOSITORY = Entity.getEntityRepository("role");
            FIELDS = ROLE_REPOSITORY.getFields("policies");
            INITIALIZED = true;
        }
    }

    public Role getRole(UUID roleId) {
        try {
            return (Role)ROLE_CACHE.get((Object)roleId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public void invalidateRole(UUID roleId) {
        try {
            ROLE_CACHE.invalidate((Object)roleId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for role {}", (Object)roleId, (Object)ex);
        }
    }

    public static void cleanUp() {
        ROLE_CACHE.cleanUp();
        INITIALIZED = false;
    }

    static class RoleLoader
    extends CacheLoader<UUID, Role> {
        RoleLoader() {
        }

        public Role load(@CheckForNull UUID roleId) throws IOException {
            Role role = ROLE_REPOSITORY.get(null, roleId, FIELDS);
            LOG.info("Loaded role {}:{}", (Object)role.getName(), (Object)role.getId());
            return role;
        }
    }
}

