/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.slack;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.WebhookPublisher;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.slack.SlackMessage;
import org.openmetadata.service.slack.SlackRetriableException;
import org.openmetadata.service.util.ChangeEventParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWebhookEventPublisher
extends WebhookPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SlackWebhookEventPublisher.class);
    private final Invocation.Builder target;
    private final Client client;

    public SlackWebhookEventPublisher(Webhook webhook, CollectionDAO dao) {
        super(webhook, dao);
        String slackWebhookURL = webhook.getEndpoint().toString();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)webhook.getTimeout().intValue(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)webhook.getReadTimeout().intValue(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
        this.target = this.client.target(slackWebhookURL).request();
    }

    @Override
    public void onStart() {
        LOG.info("Slack Webhook Publisher Started");
    }

    @Override
    public void onShutdown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void publish(EventResource.ChangeEventList events) throws EventPublisherException {
        for (ChangeEvent event : events.getData()) {
            try {
                SlackMessage slackMessage = ChangeEventParser.buildSlackMessage(event);
                Response response = this.target.post(Entity.entity((Object)slackMessage, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                if (response.getStatus() >= 300 && response.getStatus() < 400) {
                    throw new EventPublisherException("Slack webhook callback is getting redirected. Please check your configuration");
                }
                if (response.getStatus() < 300 || response.getStatus() >= 600) continue;
                throw new SlackRetriableException(response.getStatusInfo().getReasonPhrase());
            }
            catch (Exception e) {
                LOG.error("Failed to publish event {} to slack due to {} ", (Object)event, (Object)e.getMessage());
            }
        }
    }
}

