/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.openmetadata.schema.api.configuration.elasticsearch.ElasticSearchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticSearchClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClientUtils.class);

    private ElasticSearchClientUtils() {
    }

    public static RestHighLevelClient createElasticSearchClient(ElasticSearchConfiguration esConfig) {
        try {
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
            if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                SSLContext sslContext = ElasticSearchClientUtils.createSSLContext(esConfig);
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchClientUtils.lambda$createElasticSearchClient$0((CredentialsProvider)credentialsProvider, sslContext, arg_0));
            }
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
            return new RestHighLevelClient(restClientBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elastic search client ", e);
        }
    }

    private static SSLContext createSSLContext(ElasticSearchConfiguration elasticSearchConfiguration) throws KeyStoreException {
        if (elasticSearchConfiguration.getScheme().equals("https") && elasticSearchConfiguration.getTruststorePath() != null && !elasticSearchConfiguration.getTruststorePath().isEmpty()) {
            SSLContext sSLContext;
            block9: {
                Path trustStorePath = Paths.get(elasticSearchConfiguration.getTruststorePath(), new String[0]);
                KeyStore truststore = KeyStore.getInstance("jks");
                InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);
                try {
                    truststore.load(is, elasticSearchConfiguration.getTruststorePassword().toCharArray());
                    SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, null);
                    sSLContext = sslBuilder.build();
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        throw new RuntimeException("Failed to crete SSLContext to for ElasticSearch Client", e);
                    }
                }
                is.close();
            }
            return sSLContext;
        }
        return null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticSearchClient$0(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        return httpAsyncClientBuilder;
    }
}

