/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import lombok.NonNull;
import org.joda.time.Period;
import org.joda.time.format.ISOPeriodFormat;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.TermReference;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.entity.tags.Tag;
import org.openmetadata.schema.entity.type.CustomProperty;
import org.openmetadata.schema.filter.EventFilter;
import org.openmetadata.schema.filter.Filters;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FailureDetails;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.MlFeature;
import org.openmetadata.schema.type.MlHyperParameter;
import org.openmetadata.schema.type.Schedule;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Task;
import org.openmetadata.schema.type.UsageDetails;
import org.openmetadata.schema.type.UsageStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EntityUtil.class);
    public static final Comparator<EntityReference> compareEntityReference = Comparator.comparing(EntityReference::getName);
    public static final Comparator<CollectionDAO.EntityVersionPair> compareVersion = Comparator.comparing(CollectionDAO.EntityVersionPair::getVersion);
    public static final Comparator<TagLabel> compareTagLabel = Comparator.comparing(TagLabel::getTagFQN);
    public static final Comparator<FieldChange> compareFieldChange = Comparator.comparing(FieldChange::getName);
    public static final Comparator<TableConstraint> compareTableConstraint = Comparator.comparing(TableConstraint::getConstraintType);
    public static final Comparator<ChangeEvent> compareChangeEvent = Comparator.comparing(ChangeEvent::getTimestamp);
    public static final Comparator<GlossaryTerm> compareGlossaryTerm = Comparator.comparing(GlossaryTerm::getName);
    public static final Comparator<CustomProperty> compareCustomProperty = Comparator.comparing(CustomProperty::getName);
    public static final Comparator<Filters> compareFilters = Comparator.comparing(Filters::getEventType);
    public static final Comparator<EventFilter> compareEventFilters = Comparator.comparing(EventFilter::getEntityType);
    public static final Comparator<MetadataOperation> compareOperation = Comparator.comparing(MetadataOperation::value);
    public static final BiPredicate<Object, Object> objectMatch = Object::equals;
    public static final BiPredicate<EntityReference, EntityReference> entityReferenceMatch = (ref1, ref2) -> ref1.getId().equals(ref2.getId()) && ref1.getType().equals(ref2.getType());
    public static final BiPredicate<TagLabel, TagLabel> tagLabelMatch = (tag1, tag2) -> tag1.getTagFQN().equals(tag2.getTagFQN());
    public static final BiPredicate<Task, Task> taskMatch = (task1, task2) -> task1.getName().equals(task2.getName());
    public static final BiPredicate<String, String> stringMatch = String::equals;
    public static final BiPredicate<Column, Column> columnMatch = (column1, column2) -> column1.getName().equalsIgnoreCase(column2.getName()) && column1.getDataType() == column2.getDataType() && column1.getArrayDataType() == column2.getArrayDataType();
    public static final BiPredicate<Column, Column> columnNameMatch = (column1, column2) -> column1.getName().equalsIgnoreCase(column2.getName());
    public static final BiPredicate<TableConstraint, TableConstraint> tableConstraintMatch = (constraint1, constraint2) -> constraint1.getConstraintType() == constraint2.getConstraintType() && constraint1.getColumns().equals(constraint2.getColumns());
    public static final BiPredicate<MlFeature, MlFeature> mlFeatureMatch = MlFeature::equals;
    public static final BiPredicate<MlHyperParameter, MlHyperParameter> mlHyperParameterMatch = MlHyperParameter::equals;
    public static final BiPredicate<FailureDetails, FailureDetails> failureDetailsMatch = (failureDetails1, failureDetails2) -> Objects.equals(failureDetails2.getLastFailedAt(), failureDetails1.getLastFailedAt()) && Objects.equals(failureDetails2.getLastSuccessfulAt(), failureDetails1.getLastSuccessfulAt());
    public static final BiPredicate<EventFilter, EventFilter> eventFilterMatch = (filter1, filter2) -> filter1.getEntityType().equals(filter2.getEntityType()) && filter1.getFilters().equals(filter2.getFilters());
    public static final BiPredicate<GlossaryTerm, GlossaryTerm> glossaryTermMatch = (filter1, filter2) -> filter1.getFullyQualifiedName().equals(filter2.getFullyQualifiedName());
    public static final BiPredicate<TermReference, TermReference> termReferenceMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName()) && ref1.getEndpoint().equals(ref2.getEndpoint());
    public static final BiPredicate<CustomProperty, CustomProperty> customFieldMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName()) && entityReferenceMatch.test(ref1.getPropertyType(), ref2.getPropertyType());
    public static final BiPredicate<Rule, Rule> ruleMatch = (ref1, ref2) -> ref1.getName().equals(ref2.getName());

    private EntityUtil() {
    }

    public static void validateIngestionSchedule(Schedule ingestion) {
        Period period;
        if (ingestion == null) {
            return;
        }
        String duration = ingestion.getRepeatFrequency();
        String[] splits = duration.split("T");
        if (splits[0].contains("Y") || splits[0].contains("M") || splits.length == 2 && splits[1].contains("S")) {
            throw new IllegalArgumentException("Ingestion repeatFrequency can only contain Days, Hours, and Minutes - example P{d}DT{h}H{m}M");
        }
        try {
            period = ISOPeriodFormat.standard().parsePeriod(duration);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid ingestion repeatFrequency " + duration, e);
        }
        if (period.toStandardMinutes().getMinutes() < 60) {
            throw new IllegalArgumentException("Ingestion repeatFrequency is too short and must be more than 60 minutes");
        }
    }

    public static <T> T validate(String identity, String json, Class<T> clz) throws WebApplicationException, IOException {
        T entity = null;
        if (json != null) {
            entity = JsonUtils.readValue(json, clz);
        }
        if (entity == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(clz.getSimpleName(), identity));
        }
        return entity;
    }

    public static List<EntityReference> populateEntityReferences(List<EntityReference> list) throws IOException {
        if (list != null) {
            for (EntityReference ref : list) {
                EntityReference ref2 = Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL);
                EntityUtil.copy(ref2, ref);
            }
            list.sort(compareEntityReference);
        }
        return list;
    }

    public static List<EntityReference> getEntityReferences(List<CollectionDAO.EntityRelationshipRecord> list) throws IOException {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord ref : list) {
            refs.add(Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.ALL));
        }
        refs.sort(compareEntityReference);
        return refs;
    }

    public static List<EntityReference> populateEntityReferences(List<CollectionDAO.EntityRelationshipRecord> records, @NonNull String entityType) throws IOException {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>(records.size());
        for (CollectionDAO.EntityRelationshipRecord id : records) {
            refs.add(Entity.getEntityReferenceById(entityType, id.getId(), Include.ALL));
        }
        refs.sort(compareEntityReference);
        return refs;
    }

    public static List<EntityReference> populateEntityReferencesById(List<String> ids, @NonNull String entityType) throws IOException {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        ArrayList<EntityReference> refs = new ArrayList<EntityReference>(ids.size());
        for (String id : ids) {
            refs.add(Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.ALL));
        }
        refs.sort(compareEntityReference);
        return refs;
    }

    public static EntityReference validateEntityLink(MessageParser.EntityLink entityLink) {
        String entityType = entityLink.getEntityType();
        String fqn = entityLink.getEntityFQN();
        return Entity.getEntityReferenceByName(entityType, fqn, Include.ALL);
    }

    public static UsageDetails getLatestUsage(CollectionDAO.UsageDAO usageDAO, UUID entityId) {
        LOG.debug("Getting latest usage for {}", (Object)entityId);
        UsageDetails details = usageDAO.getLatestUsage(entityId.toString());
        if (details == null) {
            LOG.debug("Usage details not found. Sending default usage");
            UsageStats stats = new UsageStats().withCount(Integer.valueOf(0)).withPercentileRank(Double.valueOf(0.0));
            details = new UsageDetails().withDailyStats(stats).withWeeklyStats(stats).withMonthlyStats(stats).withDate(RestUtil.DATE_FORMAT.format(new Date()));
        }
        return details;
    }

    public static void mergeTags(List<TagLabel> tags, List<TagLabel> derivedTags) {
        if (CommonUtil.nullOrEmpty(derivedTags)) {
            return;
        }
        for (TagLabel derivedTag : derivedTags) {
            TagLabel tag = tags.stream().filter(t -> tagLabelMatch.test((TagLabel)t, derivedTag)).findAny().orElse(null);
            if (tag != null) continue;
            tags.add(derivedTag);
        }
    }

    public static List<String> getJsonDataResources(String path) throws IOException {
        return CommonUtil.getResources((Pattern)Pattern.compile(path));
    }

    public static <T extends EntityInterface> List<EntityReference> toEntityReferences(List<T> entities) {
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> entityReferences = new ArrayList<EntityReference>();
        for (EntityInterface entity : entities) {
            entityReferences.add(entity.getEntityReference());
        }
        return entityReferences;
    }

    public static List<EntityReference> toEntityReferences(List<UUID> ids, String entityType) {
        if (ids == null) {
            return null;
        }
        ArrayList<EntityReference> entityReferences = new ArrayList<EntityReference>();
        for (UUID id : ids) {
            entityReferences.add(new EntityReference().withId(id).withType(entityType));
        }
        return entityReferences;
    }

    public static List<UUID> toIds(List<EntityReference> refs) {
        if (refs == null) {
            return null;
        }
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (EntityReference ref : refs) {
            ids.add(ref.getId());
        }
        return ids;
    }

    public static List<UUID> getIDList(List<EntityReference> refList) {
        if (refList == null) {
            return Collections.emptyList();
        }
        return refList.stream().sorted(compareEntityReference).map(EntityReference::getId).collect(Collectors.toList());
    }

    public static String getVersionExtension(String entityType, Double version) {
        return String.format("%s.%s", EntityUtil.getVersionExtensionPrefix(entityType), version.toString());
    }

    public static String getVersionExtensionPrefix(String entityType) {
        return String.format("%s.%s", entityType, "version");
    }

    public static Double getVersion(String extension) {
        String[] s = extension.split("\\.");
        String versionString = s[2] + "." + s[3];
        return Double.valueOf(versionString);
    }

    public static String getLocalColumnName(String tableFqn, String columnFqn) {
        return columnFqn.replace(tableFqn + ".", "");
    }

    public static String getFieldName(String ... strings) {
        return String.join((CharSequence)".", strings);
    }

    public static String getColumnField(Table table, Column column, String columnField) {
        String localColumnName = EntityUtil.getLocalColumnName(table.getFullyQualifiedName(), column.getFullyQualifiedName());
        return columnField == null ? FullyQualifiedName.build("columns", localColumnName) : FullyQualifiedName.build("columns", localColumnName, columnField);
    }

    public static String getRuleField(Rule rule, String ruleField) {
        return ruleField == null ? FullyQualifiedName.build("rules", rule.getName()) : FullyQualifiedName.build("rules", rule.getName(), ruleField);
    }

    public static String getCustomField(CustomProperty property, String propertyFieldName) {
        return propertyFieldName == null ? FullyQualifiedName.build("customProperties", property.getName()) : FullyQualifiedName.build("customProperties", property.getName(), propertyFieldName);
    }

    public static String getExtensionField(String key) {
        return FullyQualifiedName.build("extension", key);
    }

    public static Double nextVersion(Double version) {
        return (double)Math.round((version + 0.1) * 10.0) / 10.0;
    }

    public static Double nextMajorVersion(Double version) {
        return (double)Math.round((version + 1.0) * 10.0) / 10.0;
    }

    public static void addSoftDeleteFilter(List<Filters> filters) {
        Optional<Filters> deleteFilter = filters.stream().filter(eventFilter -> eventFilter.getEventType().equals((Object)EventType.ENTITY_DELETED)).findAny();
        deleteFilter.ifPresent(eventFilter -> filters.add(new Filters().withEventType(EventType.ENTITY_SOFT_DELETED).withInclude(eventFilter.getInclude()).withExclude(eventFilter.getExclude())));
    }

    public static EntityReference copy(EntityReference from, EntityReference to) {
        return to.withType(from.getType()).withId(from.getId()).withName(from.getName()).withDisplayName(from.getDisplayName()).withFullyQualifiedName(from.getFullyQualifiedName()).withDeleted(from.getDeleted());
    }

    public static TagLabel getTagLabel(GlossaryTerm term) {
        return new TagLabel().withTagFQN(term.getFullyQualifiedName()).withDescription(term.getDescription()).withSource(TagLabel.TagSource.GLOSSARY);
    }

    public static TagLabel getTagLabel(Tag tag) {
        return new TagLabel().withTagFQN(tag.getFullyQualifiedName()).withDescription(tag.getDescription()).withSource(TagLabel.TagSource.TAG);
    }

    public static String addField(String fields, String newField) {
        fields = fields == null ? "" : fields;
        return fields.isEmpty() ? newField : fields + ", " + newField;
    }

    public static void fieldAdded(ChangeDescription change, String fieldName, Object newValue) {
        change.getFieldsAdded().add(new FieldChange().withName(fieldName).withNewValue(newValue));
    }

    public static void fieldDeleted(ChangeDescription change, String fieldName, Object oldValue) {
        change.getFieldsDeleted().add(new FieldChange().withName(fieldName).withOldValue(oldValue));
    }

    public static void fieldUpdated(ChangeDescription change, String fieldName, Object oldValue, Object newValue) {
        FieldChange fieldChange = new FieldChange().withName(fieldName).withOldValue(oldValue).withNewValue(newValue);
        change.getFieldsUpdated().add(fieldChange);
    }

    public static class Fields {
        public static final Fields EMPTY_FIELDS = new Fields(null, null);
        private final List<String> fieldList;

        public Fields(List<String> allowedFields, String fieldsParam) {
            if (CommonUtil.nullOrEmpty((String)fieldsParam)) {
                this.fieldList = new ArrayList<String>();
                return;
            }
            this.fieldList = Arrays.asList(fieldsParam.replace(" ", "").split(","));
            for (String field : this.fieldList) {
                if (allowedFields.contains(field)) continue;
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidField(field));
            }
        }

        public String toString() {
            return this.fieldList.toString();
        }

        public void add(Fields fields) {
            this.fieldList.addAll(fields.fieldList);
        }

        public boolean contains(String field) {
            return this.fieldList.contains(field);
        }

        public Fields(List<String> fieldList) {
            this.fieldList = fieldList;
        }

        public List<String> getFieldList() {
            return this.fieldList;
        }
    }
}

