/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.util.JsonUtils;

public class JsonPatchUtils {
    private JsonPatchUtils() {
    }

    public static List<MetadataOperation> getMetadataOperations(JsonPatch jsonPatch) {
        return jsonPatch.toJsonArray().stream().map(JsonPatchUtils::getMetadataOperation).distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static MetadataOperation getMetadataOperation(Object jsonPatchObject) {
        Map<String, Object> jsonPatchMap = JsonUtils.getMap(jsonPatchObject);
        String path = jsonPatchMap.get("path").toString();
        if (path.contains("description")) {
            return MetadataOperation.EDIT_DESCRIPTION;
        }
        if (path.contains("displayName")) {
            return MetadataOperation.EDIT_DISPLAY_NAME;
        }
        if (path.contains("tags")) {
            return MetadataOperation.EDIT_TAGS;
        }
        if (path.contains("owner")) {
            return MetadataOperation.EDIT_OWNER;
        }
        if (path.startsWith("/users")) {
            return MetadataOperation.EDIT_USERS;
        }
        return null;
    }
}

