/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.api.services.ingestionPipelines.TestServiceConnection;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.service.OpenMetadataApplication;
import org.openmetadata.service.exception.PipelineServiceClientException;
import org.openmetadata.service.exception.PipelineServiceVersionException;

public abstract class PipelineServiceClient {
    protected final URL serviceURL;
    protected final String username;
    protected final String password;
    protected final String hostIp;
    protected final HttpClient client;
    protected static final String AUTH_HEADER = "Authorization";
    protected static final String CONTENT_HEADER = "Content-Type";
    protected static final String CONTENT_TYPE = "application/json";
    public static final String SERVER_VERSION;

    public PipelineServiceClient(String userName, String password, String apiEndpoint, String hostIp, int apiTimeout) {
        try {
            this.serviceURL = new URL(apiEndpoint);
        }
        catch (MalformedURLException e) {
            throw new PipelineServiceClientException(apiEndpoint + " Malformed.");
        }
        this.username = userName;
        this.password = password;
        this.hostIp = hostIp;
        this.client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(apiTimeout)).build();
    }

    public final HttpResponse<String> post(String endpoint, String payload) throws IOException, InterruptedException {
        return this.post(endpoint, payload, true);
    }

    public final String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public final HttpResponse<String> post(String endpoint, String payload, boolean authenticate) throws IOException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(URI.create(endpoint)).header(CONTENT_HEADER, CONTENT_TYPE).POST(HttpRequest.BodyPublishers.ofString(payload));
        if (authenticate) {
            requestBuilder.header(AUTH_HEADER, this.getBasicAuthenticationHeader(this.username, this.password));
        }
        return this.client.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
    }

    public static String getServerVersion() throws IOException {
        InputStream fileInput = OpenMetadataApplication.class.getResourceAsStream("/catalog/VERSION");
        Properties props = new Properties();
        props.load(fileInput);
        return props.getProperty("version", "unknown");
    }

    public final String getVersionFromString(String version) {
        if (version != null) {
            return Pattern.compile("(\\d+.\\d+.\\d+)").matcher(version).results().map(m -> m.group(1)).findFirst().orElseThrow(() -> new PipelineServiceVersionException(String.format("Cannot extract version x.y.z from %s", version)));
        }
        throw new PipelineServiceVersionException("Received version as null");
    }

    public final Boolean validServerClientVersions(String clientVersion) {
        return this.getVersionFromString(clientVersion).equals(this.getVersionFromString(SERVER_VERSION));
    }

    public final Map<String, String> getHostIp() {
        try {
            if (this.hostIp == null || this.hostIp.isEmpty()) {
                return this.requestGetHostIp();
            }
            return Map.of("ip", this.hostIp);
        }
        catch (Exception e) {
            throw PipelineServiceClientException.byMessage("Failed to get Pipeline Service host IP.", e.getMessage());
        }
    }

    public abstract Response getServiceStatus();

    public abstract HttpResponse<String> testConnection(TestServiceConnection var1);

    public abstract String deployPipeline(IngestionPipeline var1);

    public abstract String runPipeline(String var1);

    public abstract String deletePipeline(String var1);

    public abstract IngestionPipeline getPipelineStatus(IngestionPipeline var1);

    public abstract IngestionPipeline toggleIngestion(IngestionPipeline var1);

    public abstract Map<String, String> getLastIngestionLogs(IngestionPipeline var1);

    public abstract HttpResponse<String> killIngestion(IngestionPipeline var1);

    public abstract Map<String, String> requestGetHostIp();

    static {
        String rawServerVersion;
        try {
            rawServerVersion = PipelineServiceClient.getServerVersion();
        }
        catch (IOException e) {
            rawServerVersion = "unknown";
        }
        SERVER_VERSION = rawServerVersion;
    }
}

