/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.health.conf.HealthConfiguration;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.api.configuration.airflow.AirflowConfiguration;
import org.openmetadata.schema.api.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.api.configuration.events.EventHandlerConfiguration;
import org.openmetadata.schema.api.fernet.FernetConfiguration;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.security.jwt.JWTTokenConfiguration;
import org.openmetadata.schema.api.slackChat.SlackChatConfiguration;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.service.migration.MigrationConfiguration;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;
import org.openmetadata.service.secrets.SecretsManagerConfiguration;

public class OpenMetadataApplicationConfig
extends Configuration {
    @JsonProperty(value="database")
    @NotNull
    @Valid
    private DataSourceFactory dataSourceFactory;
    @JsonProperty(value="swagger")
    private SwaggerBundleConfiguration swaggerBundleConfig;
    @JsonProperty(value="authorizerConfiguration")
    private AuthorizerConfiguration authorizerConfiguration;
    @JsonProperty(value="authenticationConfiguration")
    private AuthenticationConfiguration authenticationConfiguration;
    @JsonProperty(value="jwtTokenConfiguration")
    private JWTTokenConfiguration jwtTokenConfiguration;
    @JsonProperty(value="elasticsearch")
    private ElasticSearchConfiguration elasticSearchConfiguration;
    @JsonProperty(value="eventHandlerConfiguration")
    private EventHandlerConfiguration eventHandlerConfiguration;
    @NotNull
    @Valid
    @JsonProperty(value="airflowConfiguration")
    private AirflowConfiguration airflowConfiguration;
    @JsonProperty(value="migrationConfiguration")
    @NotNull
    private MigrationConfiguration migrationConfiguration;
    @JsonProperty(value="fernetConfiguration")
    private FernetConfiguration fernetConfiguration;
    @JsonProperty(value="health")
    @NotNull
    @Valid
    private HealthConfiguration healthConfiguration = new HealthConfiguration();
    @JsonProperty(value="sandboxModeEnabled")
    private boolean sandboxModeEnabled;
    @JsonProperty(value="slackChat")
    private SlackChatConfiguration slackChatConfiguration = new SlackChatConfiguration();
    @JsonProperty(value="secretsManagerConfiguration")
    private SecretsManagerConfiguration secretsManagerConfiguration;
    @JsonProperty(value="eventMonitoringConfiguration")
    private EventMonitorConfiguration eventMonitorConfiguration;
    @JsonProperty(value="clusterName")
    private String clusterName;
    @JsonProperty(value="email")
    private SmtpSettings smtpSettings;
    @JsonProperty(value="login")
    private LoginConfiguration loginSettings;

    public String toString() {
        return "catalogConfig{, dataSourceFactory=" + String.valueOf(this.dataSourceFactory) + ", swaggerBundleConfig=" + String.valueOf(this.swaggerBundleConfig) + ", authorizerConfiguration=" + String.valueOf(this.authorizerConfiguration) + "}";
    }

    @NotNull
    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public SwaggerBundleConfiguration getSwaggerBundleConfig() {
        return this.swaggerBundleConfig;
    }

    public AuthorizerConfiguration getAuthorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public JWTTokenConfiguration getJwtTokenConfiguration() {
        return this.jwtTokenConfiguration;
    }

    public ElasticSearchConfiguration getElasticSearchConfiguration() {
        return this.elasticSearchConfiguration;
    }

    public EventHandlerConfiguration getEventHandlerConfiguration() {
        return this.eventHandlerConfiguration;
    }

    @NotNull
    public AirflowConfiguration getAirflowConfiguration() {
        return this.airflowConfiguration;
    }

    @NotNull
    public MigrationConfiguration getMigrationConfiguration() {
        return this.migrationConfiguration;
    }

    public FernetConfiguration getFernetConfiguration() {
        return this.fernetConfiguration;
    }

    @NotNull
    public HealthConfiguration getHealthConfiguration() {
        return this.healthConfiguration;
    }

    public boolean isSandboxModeEnabled() {
        return this.sandboxModeEnabled;
    }

    public SlackChatConfiguration getSlackChatConfiguration() {
        return this.slackChatConfiguration;
    }

    public SecretsManagerConfiguration getSecretsManagerConfiguration() {
        return this.secretsManagerConfiguration;
    }

    public EventMonitorConfiguration getEventMonitorConfiguration() {
        return this.eventMonitorConfiguration;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public SmtpSettings getSmtpSettings() {
        return this.smtpSettings;
    }

    public LoginConfiguration getLoginSettings() {
        return this.loginSettings;
    }

    @JsonProperty(value="database")
    public void setDataSourceFactory(@NotNull DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    @JsonProperty(value="swagger")
    public void setSwaggerBundleConfig(SwaggerBundleConfiguration swaggerBundleConfig) {
        this.swaggerBundleConfig = swaggerBundleConfig;
    }

    @JsonProperty(value="authorizerConfiguration")
    public void setAuthorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    @JsonProperty(value="authenticationConfiguration")
    public void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    @JsonProperty(value="jwtTokenConfiguration")
    public void setJwtTokenConfiguration(JWTTokenConfiguration jwtTokenConfiguration) {
        this.jwtTokenConfiguration = jwtTokenConfiguration;
    }

    @JsonProperty(value="elasticsearch")
    public void setElasticSearchConfiguration(ElasticSearchConfiguration elasticSearchConfiguration) {
        this.elasticSearchConfiguration = elasticSearchConfiguration;
    }

    @JsonProperty(value="eventHandlerConfiguration")
    public void setEventHandlerConfiguration(EventHandlerConfiguration eventHandlerConfiguration) {
        this.eventHandlerConfiguration = eventHandlerConfiguration;
    }

    @JsonProperty(value="airflowConfiguration")
    public void setAirflowConfiguration(@NotNull AirflowConfiguration airflowConfiguration) {
        this.airflowConfiguration = airflowConfiguration;
    }

    @JsonProperty(value="migrationConfiguration")
    public void setMigrationConfiguration(@NotNull MigrationConfiguration migrationConfiguration) {
        this.migrationConfiguration = migrationConfiguration;
    }

    @JsonProperty(value="fernetConfiguration")
    public void setFernetConfiguration(FernetConfiguration fernetConfiguration) {
        this.fernetConfiguration = fernetConfiguration;
    }

    @JsonProperty(value="health")
    public void setHealthConfiguration(@NotNull HealthConfiguration healthConfiguration) {
        this.healthConfiguration = healthConfiguration;
    }

    @JsonProperty(value="sandboxModeEnabled")
    public void setSandboxModeEnabled(boolean sandboxModeEnabled) {
        this.sandboxModeEnabled = sandboxModeEnabled;
    }

    @JsonProperty(value="slackChat")
    public void setSlackChatConfiguration(SlackChatConfiguration slackChatConfiguration) {
        this.slackChatConfiguration = slackChatConfiguration;
    }

    @JsonProperty(value="secretsManagerConfiguration")
    public void setSecretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
        this.secretsManagerConfiguration = secretsManagerConfiguration;
    }

    @JsonProperty(value="eventMonitoringConfiguration")
    public void setEventMonitorConfiguration(EventMonitorConfiguration eventMonitorConfiguration) {
        this.eventMonitorConfiguration = eventMonitorConfiguration;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="email")
    public void setSmtpSettings(SmtpSettings smtpSettings) {
        this.smtpSettings = smtpSettings;
    }

    @JsonProperty(value="login")
    public void setLoginSettings(LoginConfiguration loginSettings) {
        this.loginSettings = loginSettings;
    }
}

