/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.AlertRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityFeedAlertCache {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityFeedAlertCache.class);
    private static final ActivityFeedAlertCache INSTANCE = new ActivityFeedAlertCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<String, Alert> ALERTS_CACHE;
    protected static AlertRepository ALERT_REPOSITORY;
    private static String activityFeedAlertName;

    public static void initialize(String alertName, CollectionDAO dao) {
        if (!INITIALIZED) {
            ALERTS_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new ActivityFeedAlertLoader());
            ALERT_REPOSITORY = new AlertRepository(dao);
            INITIALIZED = true;
            activityFeedAlertName = alertName;
        }
    }

    public static ActivityFeedAlertCache getInstance() {
        return INSTANCE;
    }

    public Alert getActivityFeedAlert() throws EntityNotFoundException {
        try {
            return (Alert)ALERTS_CACHE.get((Object)activityFeedAlertName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    static class ActivityFeedAlertLoader
    extends CacheLoader<String, Alert> {
        ActivityFeedAlertLoader() {
        }

        public Alert load(@CheckForNull String alertName) throws IOException {
            Alert alert = (Alert)ALERT_REPOSITORY.getByName(null, alertName, ALERT_REPOSITORY.getFields("*"));
            LOG.debug("Loaded Alert {}", (Object)alert);
            return alert;
        }
    }
}

