/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertFilterRule;
import org.openmetadata.schema.entity.alerts.TriggerConfig;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Function;
import org.openmetadata.schema.type.ParamAdditionalContext;
import org.openmetadata.service.Entity;
import org.openmetadata.service.alerts.ActivityFeedAlertCache;
import org.openmetadata.service.alerts.AlertsActionPublisher;
import org.openmetadata.service.alerts.AlertsRuleEvaluator;
import org.openmetadata.service.alerts.emailAlert.EmailAlertPublisher;
import org.openmetadata.service.alerts.generic.GenericWebhookPublisher;
import org.openmetadata.service.alerts.msteams.MSTeamsWebhookPublisher;
import org.openmetadata.service.alerts.slack.SlackWebhookEventPublisher;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AlertUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AlertUtil.class);

    public static AlertsActionPublisher getAlertPublisher(Alert alert, AlertAction alertAction, CollectionDAO daoCollection) {
        AlertsActionPublisher publisher;
        switch (alertAction.getAlertActionType()) {
            case SLACK_WEBHOOK: {
                publisher = new SlackWebhookEventPublisher(alert, alertAction);
                break;
            }
            case MS_TEAMS_WEBHOOK: {
                publisher = new MSTeamsWebhookPublisher(alert, alertAction);
                break;
            }
            case GENERIC_WEBHOOK: {
                publisher = new GenericWebhookPublisher(alert, alertAction);
                break;
            }
            case EMAIL: {
                publisher = new EmailAlertPublisher(alert, alertAction, daoCollection);
                break;
            }
            case ACTIVITY_FEED: {
                throw new IllegalArgumentException("Cannot create Activity Feed as Publisher.");
            }
            default: {
                throw new IllegalArgumentException("Invalid Alert Action Specified.");
            }
        }
        return publisher;
    }

    public static <T> T validateExpression(String condition, Class<T> clz) {
        if (condition == null) {
            return null;
        }
        Expression expression = CompiledRule.parseExpression(condition);
        AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(null);
        try {
            return (T)expression.getValue((Object)ruleEvaluator, clz);
        }
        catch (Exception exception) {
            String message = exception.getMessage().replaceAll("on type .*$", "").replaceAll("on object .*$", "");
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToEvaluate(message));
        }
    }

    public static Map<String, Function> getAlertFilterFunctions() {
        HashMap<String, Function> alertFunctions = new HashMap<String, Function>();
        for (Function func : CollectionRegistry.getInstance().getFunctions(AlertsRuleEvaluator.class)) {
            AlertsRuleEvaluator.AlertRuleType type = AlertsRuleEvaluator.AlertRuleType.valueOf(func.getName());
            ParamAdditionalContext paramAdditionalContext = new ParamAdditionalContext();
            switch (type) {
                case matchAnySource: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet<String>(Entity.getEntityList())));
                    break;
                }
                case matchUpdatedBy: 
                case matchAnyOwnerName: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(AlertUtil.getEntitiesIndex(List.of("user", "team"))));
                    break;
                }
                case matchAnyEntityFqn: 
                case matchAnyEntityId: {
                    func.setParamAdditionalContext(paramAdditionalContext.withData(AlertUtil.getEntitiesIndex(Entity.getEntityList())));
                    break;
                }
                case matchAnyEventType: {
                    List eventTypes = Stream.of(EventType.values()).map(EventType::value).collect(Collectors.toList());
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet(eventTypes)));
                    break;
                }
                case matchTestResult: {
                    List testResultStatus = Stream.of(TestCaseStatus.values()).map(TestCaseStatus::value).collect(Collectors.toList());
                    func.setParamAdditionalContext(paramAdditionalContext.withData(new HashSet(testResultStatus)));
                }
            }
            alertFunctions.put(func.getName(), func);
        }
        return alertFunctions;
    }

    public static Set<String> getEntitiesIndex(List<String> entities) {
        HashSet<String> indexesToSearch = new HashSet<String>();
        for (String entityType : entities) {
            try {
                ElasticSearchIndexDefinition.ElasticSearchIndexType type = ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType);
                indexesToSearch.add(type.indexName);
            }
            catch (RuntimeException ex) {
                LOG.error("Failing to get Index for EntityType");
            }
        }
        return indexesToSearch;
    }

    public static boolean evaluateAlertConditions(ChangeEvent changeEvent, List<AlertFilterRule> alertFilterRules) {
        if (alertFilterRules.size() > 0) {
            String completeCondition = AlertUtil.buildCompleteCondition(alertFilterRules);
            AlertsRuleEvaluator ruleEvaluator = new AlertsRuleEvaluator(changeEvent);
            StandardEvaluationContext evaluationContext = new StandardEvaluationContext((Object)ruleEvaluator);
            Expression expression = CompiledRule.parseExpression(completeCondition);
            boolean result = Boolean.TRUE.equals(expression.getValue((EvaluationContext)evaluationContext, Boolean.class));
            LOG.debug("Alert evaluated as Result : {}", (Object)result);
            return result;
        }
        return true;
    }

    public static String buildCompleteCondition(List<AlertFilterRule> alertFilterRules) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < alertFilterRules.size(); ++i) {
            AlertFilterRule rule = alertFilterRules.get(i);
            builder.append("(");
            if (rule.getEffect() == AlertFilterRule.Effect.INCLUDE) {
                builder.append(rule.getCondition());
            } else {
                builder.append("!");
                builder.append(rule.getCondition());
            }
            builder.append(")");
            if (i == alertFilterRules.size() - 1) continue;
            builder.append(" && ");
        }
        return builder.toString();
    }

    public static List<TriggerConfig> getDefaultAlertTriggers() {
        ArrayList<TriggerConfig> triggerConfigs = new ArrayList<TriggerConfig>();
        TriggerConfig allMetadataTrigger = new TriggerConfig().withType(TriggerConfig.AlertTriggerType.ALL_DATA_ASSETS);
        TriggerConfig specificDataAsset = new TriggerConfig().withType(TriggerConfig.AlertTriggerType.SPECIFIC_DATA_ASSET);
        HashSet<String> entitites = new HashSet<String>(Entity.getEntityList());
        entitites.remove("alert");
        entitites.remove("alertAction");
        specificDataAsset.setEntities(entitites);
        triggerConfigs.add(allMetadataTrigger);
        triggerConfigs.add(specificDataAsset);
        return triggerConfigs;
    }

    public static boolean shouldTriggerAlert(String entityType, TriggerConfig config) {
        if (config.getType() == TriggerConfig.AlertTriggerType.ALL_DATA_ASSETS) {
            return true;
        }
        return config.getEntities().contains(entityType);
    }

    public static boolean shouldProcessActivityFeedRequest(ChangeEvent event) {
        if (!AlertUtil.shouldTriggerAlert(event.getEntityType(), ActivityFeedAlertCache.getInstance().getActivityFeedAlert().getTriggerConfig())) {
            return false;
        }
        return AlertUtil.evaluateAlertConditions(event, ActivityFeedAlertCache.getInstance().getActivityFeedAlert().getFilteringRules());
    }
}

