/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import com.lmax.disruptor.BatchEventProcessor;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertActionStatus;
import org.openmetadata.schema.type.FailureDetails;
import org.openmetadata.service.alerts.AbstractAlertPublisher;
import org.openmetadata.service.alerts.AlertsPublisherManager;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.resources.events.EventResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertsActionPublisher
extends AbstractAlertPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsActionPublisher.class);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private BatchEventProcessor<EventPubSub.ChangeEventHolder> processor;

    public AlertsActionPublisher(Alert alert, AlertAction alertAction) {
        super(alert, alertAction);
    }

    public void onStart() {
        this.setSuccessStatus(System.currentTimeMillis());
        this.onStartDelegate();
        LOG.info("Alert-lifecycle-onStart {}", (Object)this.alert.getName());
    }

    public void onShutdown() {
        this.currentBackoffTime = 0;
        this.shutdownLatch.countDown();
        this.onShutdownDelegate();
        LOG.info("Alert-lifecycle-onShutdown {}", (Object)this.alert.getName());
    }

    public synchronized Alert getAlert() {
        return this.alert;
    }

    public synchronized AlertAction getAlertAction() {
        return this.alertAction;
    }

    protected void setErrorStatus(Long updateTime, Integer statusCode, String reason) throws IOException {
        FailureDetails failureDetails = new FailureDetails().withLastFailedAt(updateTime).withLastFailedStatusCode(statusCode).withLastFailedReason(reason).withNextAttempt(Long.valueOf(updateTime + (long)this.currentBackoffTime));
        AlertActionStatus status = new AlertActionStatus().withStatus(AlertActionStatus.Status.FAILED).withTimestamp(updateTime).withLastSuccessfulAt(null).withFailureDetails(failureDetails);
        this.setStatus(status);
        throw new RuntimeException(reason);
    }

    protected void setAwaitingRetry(Long updateTime, int statusCode, String reason) throws IOException {
        FailureDetails failureDetails = new FailureDetails().withLastFailedAt(updateTime).withLastFailedStatusCode(Integer.valueOf(statusCode)).withLastFailedReason(reason).withNextAttempt(Long.valueOf(updateTime + (long)this.currentBackoffTime));
        AlertActionStatus status = new AlertActionStatus().withStatus(AlertActionStatus.Status.AWAITING_RETRY).withTimestamp(updateTime).withLastSuccessfulAt(null).withFailureDetails(failureDetails);
        this.setStatus(status);
    }

    protected void setSuccessStatus(Long updateTime) throws IOException {
        AlertActionStatus status = new AlertActionStatus().withStatus(AlertActionStatus.Status.ACTIVE).withTimestamp(updateTime).withLastSuccessfulAt(updateTime).withFailureDetails(null);
        this.setStatus(status);
    }

    protected void setStatus(AlertActionStatus status) throws IOException {
        AlertsPublisherManager.getInstance().setStatus(this.alert.getId(), this.alertAction.getId(), status);
        this.alertAction.setStatusDetails(status);
    }

    public void awaitShutdown() throws InterruptedException {
        LOG.info("Awaiting shutdown alertActionPublisher-lifecycle {}", (Object)this.alert.getName());
        this.shutdownLatch.await(5L, TimeUnit.SECONDS);
    }

    public void setProcessor(BatchEventProcessor<EventPubSub.ChangeEventHolder> processor) {
        this.processor = processor;
    }

    public BatchEventProcessor<EventPubSub.ChangeEventHolder> getProcessor() {
        return this.processor;
    }

    protected void sendAlert(EventResource.ChangeEventList list) throws IOException, InterruptedException {
    }

    protected void onStartDelegate() {
    }

    protected void onShutdownDelegate() {
    }

    @Override
    public void publish(EventResource.ChangeEventList list) throws EventPublisherException, IOException, InterruptedException {
        try {
            LOG.info("Sending Alert {}:{}:{}", new Object[]{this.alert.getName(), this.alertAction.getStatusDetails().getStatus(), this.batch.size()});
            this.sendAlert(list);
        }
        catch (Exception ex) {
            LOG.warn("Invalid Exception in Alert {}", (Object)this.alert.getName());
        }
    }
}

