/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import com.lmax.disruptor.BatchEventProcessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertActionStatus;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.alerts.AlertUtil;
import org.openmetadata.service.alerts.AlertsActionPublisher;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertsPublisherManager {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsPublisherManager.class);
    private static CollectionDAO daoCollection;
    private static AlertsPublisherManager INSTANCE;
    private static volatile boolean INITIALIZED;
    private static final ConcurrentHashMap<UUID, Map<UUID, AlertsActionPublisher>> alertPublisherMap;

    public static void initialize(CollectionDAO dao) {
        if (!INITIALIZED) {
            daoCollection = dao;
            INSTANCE = new AlertsPublisherManager();
            INITIALIZED = true;
        } else {
            INITIALIZED = false;
            LOG.info("Email Util is already initialized");
        }
    }

    public static AlertsPublisherManager getInstance() {
        return INSTANCE;
    }

    public void addAlertActionPublishers(Alert alert) throws IOException {
        EntityRepository alertActionEntityRepository = Entity.getEntityRepository("alertAction");
        for (EntityReference alertActionRef : alert.getAlertActions()) {
            AlertAction action = (AlertAction)alertActionEntityRepository.get(null, alertActionRef.getId(), alertActionEntityRepository.getFields("*"));
            this.addAlertActionPublisher(alert, action);
        }
    }

    public void addAlertActionPublisher(Alert alert, AlertAction alertAction) throws IOException {
        if (Boolean.FALSE.equals(alertAction.getEnabled())) {
            AlertActionStatus status = new AlertActionStatus().withStatus(AlertActionStatus.Status.DISABLED).withTimestamp(Long.valueOf(System.currentTimeMillis())).withFailureDetails(null);
            this.setStatus(alert.getId(), alertAction.getId(), status);
            alertAction.setStatusDetails(status);
            return;
        }
        if (alertAction.getAlertActionType() == AlertAction.AlertActionType.ACTIVITY_FEED) {
            LOG.info("Activity Feed Alert Action cannot be created.");
            return;
        }
        AlertsActionPublisher publisher = AlertUtil.getAlertPublisher(alert, alertAction, daoCollection);
        BatchEventProcessor<EventPubSub.ChangeEventHolder> processor = EventPubSub.addEventHandler(publisher);
        publisher.setProcessor(processor);
        LOG.info("Alert publisher started for {}", (Object)alert.getName());
        HashMap<UUID, AlertsActionPublisher> alertsActionPublisherMap = alertPublisherMap.get(alert.getId()) == null ? new HashMap<UUID, AlertsActionPublisher>() : alertPublisherMap.get(alert.getId());
        alertsActionPublisherMap.put(alertAction.getId(), publisher);
        alertPublisherMap.put(alert.getId(), alertsActionPublisherMap);
    }

    public void removeAlertStatus(UUID alertId, UUID alertActionId) {
        daoCollection.entityExtensionTimeSeriesDao().delete(alertId.toString(), alertActionId.toString());
    }

    public void removeAllAlertStatus(UUID alertId) {
        daoCollection.entityExtensionTimeSeriesDao().deleteAll(alertId.toString());
    }

    public void setStatus(UUID alertId, UUID alertActionId, AlertActionStatus status) throws IOException {
        daoCollection.entityExtensionTimeSeriesDao().insert(alertId.toString(), alertActionId.toString(), "alertActionStatus", JsonUtils.pojoToJson(status));
    }

    public void updateAlertActionPublishers(Alert alert) {
        this.deleteAlertAllPublishers(alert.getId());
        this.addAlertActionPublishers(alert);
    }

    public void updateAllAlertUsingAlertAction(AlertAction alertAction) {
        List<CollectionDAO.EntityRelationshipRecord> records = daoCollection.relationshipDAO().findFrom(alertAction.getId().toString(), "alertAction", Relationship.CONTAINS.ordinal(), "alert");
        EntityRepository alertEntityRepository = Entity.getEntityRepository("alert");
        for (CollectionDAO.EntityRelationshipRecord record : records) {
            this.deleteAlertAllPublishers(record.getId());
            Alert alert = (Alert)alertEntityRepository.get(null, record.getId(), alertEntityRepository.getFields("*"));
            this.addAlertActionPublisher(alert, alertAction);
        }
    }

    public void deleteAlertActionFromAllAlertPublisher(AlertAction alertAction) {
        List<CollectionDAO.EntityRelationshipRecord> records = daoCollection.relationshipDAO().findFrom(alertAction.getId().toString(), "alertAction", Relationship.CONTAINS.ordinal(), "alert");
        for (CollectionDAO.EntityRelationshipRecord record : records) {
            this.deleteAlertActionPublisher(record.getId(), alertAction);
        }
    }

    public void deleteAlertActionPublisher(UUID alertId, AlertAction action) throws InterruptedException {
        AlertsActionPublisher alertsActionPublisher;
        Map<UUID, AlertsActionPublisher> alertActionPublishers = alertPublisherMap.get(alertId);
        if (alertActionPublishers != null && (alertsActionPublisher = alertActionPublishers.get(action.getId())) != null) {
            alertsActionPublisher.getProcessor().halt();
            alertsActionPublisher.awaitShutdown();
            EventPubSub.removeProcessor(alertsActionPublisher.getProcessor());
            LOG.info("Alert publisher deleted for {}", (Object)alertsActionPublisher.getAlert().getName());
            alertActionPublishers.remove(action.getId());
            this.removeAlertStatus(alertId, action.getId());
            alertPublisherMap.put(alertId, alertActionPublishers);
        }
    }

    public void deleteAlertAllPublishers(UUID alertId) throws InterruptedException {
        Map<UUID, AlertsActionPublisher> alertPublishers = alertPublisherMap.get(alertId);
        if (alertPublishers != null) {
            for (AlertsActionPublisher publisher : alertPublishers.values()) {
                publisher.getProcessor().halt();
                publisher.awaitShutdown();
                EventPubSub.removeProcessor(publisher.getProcessor());
                LOG.info("Alert publisher deleted for {}", (Object)publisher.getAlert().getName());
            }
            alertPublisherMap.remove(alertId);
            this.removeAllAlertStatus(alertId);
        }
    }

    static {
        INITIALIZED = false;
        alertPublisherMap = new ConcurrentHashMap();
    }
}

