/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts;

import java.util.Set;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Function;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.ChangeEventParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertsRuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsRuleEvaluator.class);
    private final ChangeEvent changeEvent;

    public AlertsRuleEvaluator(ChangeEvent event) {
        this.changeEvent = event;
    }

    @Function(name="matchAnySource", input="List of comma separated source", description="Returns true if the change event entity being accessed has source as mentioned in condition", examples={"matchAnySource('bot', 'user')"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchAnySource(String ... originEntity) {
        if (this.changeEvent == null) {
            return false;
        }
        String changeEventEntity = this.changeEvent.getEntityType();
        for (String entityType : originEntity) {
            if (!changeEventEntity.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyOwnerName", input="List of comma separated ownerName", description="Returns true if the change event entity being accessed has following owners from the List.", examples={"matchAnyOwnerName('Owner1', 'Owner2')"}, paramInputType=Function.ParameterType.SPECIFIC_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyOwnerName(String ... ownerNameList) {
        block3: {
            EntityReference ownerReference;
            block4: {
                if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
                    return false;
                }
                EntityInterface entity = (EntityInterface)this.changeEvent.getEntity();
                ownerReference = entity.getOwner();
                if (ownerReference == null) break block3;
                if (!"user".equals(ownerReference.getType())) break block4;
                User user = SubjectCache.getInstance().getSubjectContext(ownerReference.getId()).getUser();
                for (String name : ownerNameList) {
                    if (!user.getName().equals(name)) continue;
                    return true;
                }
                break block3;
            }
            if (!"team".equals(ownerReference.getType())) break block3;
            Team team = SubjectCache.getInstance().getTeam(ownerReference.getId());
            for (String name : ownerNameList) {
                if (!team.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Function(name="matchAnyEntityFqn", input="List of comma separated entityName", description="Returns true if the change event entity being accessed has following entityName from the List.", examples={"matchAnyEntityFqn('Name1', 'Name')"}, paramInputType=Function.ParameterType.ALL_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyEntityFqn(String ... entityNames) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        EntityInterface entity = (EntityInterface)this.changeEvent.getEntity();
        for (String name : entityNames) {
            if (!entity.getFullyQualifiedName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyEntityId", input="List of comma separated entityName", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchAnyEntityId('uuid1', 'uuid2')"}, paramInputType=Function.ParameterType.ALL_INDEX_ELASTIC_SEARCH)
    public boolean matchAnyEntityId(String ... entityIds) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        EntityInterface entity = (EntityInterface)this.changeEvent.getEntity();
        for (String id : entityIds) {
            if (!entity.getId().equals(UUID.fromString(id))) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyEventType", input="List of comma separated eventType", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchAnyEventType('entityCreated', 'entityUpdated', 'entityDeleted', 'entitySoftDeleted')"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchAnyEventType(String ... eventTypesList) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        String eventType = this.changeEvent.getEventType().toString();
        for (String type : eventTypesList) {
            if (!eventType.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchTestResult", input="List of comma separated eventType", description="Returns true if the change event entity being accessed has following entityId from the List.", examples={"matchTestResult('Success', 'Failed', 'Aborted')"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchTestResult(String ... testResults) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        if (!this.changeEvent.getEntityType().equals("testCase")) {
            return true;
        }
        for (FieldChange fieldChange : this.changeEvent.getChangeDescription().getFieldsUpdated()) {
            if (!fieldChange.getName().equals("testCaseResult") || fieldChange.getNewValue() == null) continue;
            TestCaseResult testCaseResult = (TestCaseResult)fieldChange.getNewValue();
            TestCaseStatus status = testCaseResult.getTestCaseStatus();
            for (String givenStatus : testResults) {
                if (!givenStatus.equals(status.value())) continue;
                return true;
            }
        }
        return false;
    }

    @Function(name="matchUpdatedBy", input="List of comma separated updated by users", description="Returns true if the change event entity is updated by the mentioned users", examples={"matchUpdatedBy('user1', 'user2')"}, paramInputType=Function.ParameterType.READ_FROM_PARAM_CONTEXT)
    public boolean matchUpdatedBy(String ... updatedByUserList) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        String entityUpdatedBy = this.changeEvent.getUserName();
        for (String name : updatedByUserList) {
            if (!name.equals(entityUpdatedBy)) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchAnyFieldChange", input="List of comma separated fields change", description="Returns true if the change event entity is updated by the mentioned users", examples={"matchAnyFieldChange('fieldName1', 'fieldName')"}, paramInputType=Function.ParameterType.NOT_REQUIRED)
    public boolean matchAnyFieldChange(String ... fieldChangeUpdate) {
        if (this.changeEvent == null || this.changeEvent.getEntity() == null) {
            return false;
        }
        Set<String> fields = ChangeEventParser.getUpdatedField(this.changeEvent);
        for (String name : fieldChangeUpdate) {
            if (!fields.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static enum AlertRuleType {
        matchAnySource,
        matchAnyOwnerName,
        matchAnyEntityFqn,
        matchAnyEntityId,
        matchAnyEventType,
        matchTestResult,
        matchUpdatedBy,
        matchAnyFieldChange;

    }
}

