/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.alerts.msteams;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.alerts.AlertsActionPublisher;
import org.openmetadata.service.alerts.msteams.TeamsMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTeamsWebhookPublisher
extends AlertsActionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MSTeamsWebhookPublisher.class);
    private final Invocation.Builder target;
    private final Client client;

    public MSTeamsWebhookPublisher(Alert alert, AlertAction alertAction) {
        super(alert, alertAction);
        if (alertAction.getAlertActionType() != AlertAction.AlertActionType.MS_TEAMS_WEBHOOK) {
            throw new IllegalArgumentException("MsTeams Alert Invoked with Illegal Type and Settings.");
        }
        Webhook webhook = JsonUtils.convertValue(alertAction.getAlertActionConfig(), Webhook.class);
        String msTeamsWebhookURL = webhook.getEndpoint().toString();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)alertAction.getTimeout().intValue(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)alertAction.getReadTimeout().intValue(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
        this.target = this.client.target(msTeamsWebhookURL).request();
    }

    @Override
    public void onStartDelegate() {
        LOG.info("MsTeams Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void sendAlert(EventResource.ChangeEventList list) {
        for (ChangeEvent event : list.getData()) {
            long attemptTime = System.currentTimeMillis();
            try {
                TeamsMessage teamsMessage = ChangeEventParser.buildTeamsMessage(event);
                Response response = this.target.post(Entity.entity((Object)teamsMessage, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                if (response.getStatus() >= 300 && response.getStatus() < 400) {
                    this.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    continue;
                }
                if (response.getStatus() >= 300 && response.getStatus() < 600) {
                    this.setNextBackOff();
                    this.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    Thread.sleep(this.currentBackoffTime);
                    continue;
                }
                if (response.getStatus() != 200) continue;
                this.setSuccessStatus(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error("Failed to publish event {} to msteams due to {} ", (Object)event, (Object)e.getMessage());
                throw new EventPublisherException(String.format("Failed to publish event %s to msteams due to %s ", event, e.getMessage()));
            }
        }
    }
}

