/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.DailyActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public class DailyActiveUsersAggregator
extends DataInsightAggregatorInterface<DailyActiveUsers> {
    public DailyActiveUsersAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<DailyActiveUsers> data = this.aggregate();
        DataInsightChartResult dataInsightChartResult = new DataInsightChartResult();
        return dataInsightChartResult.withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    List<DailyActiveUsers> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregations.get("timestamp");
        ArrayList<DailyActiveUsers> data = new ArrayList<DailyActiveUsers>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            long activeUsers = timestampBucket.getDocCount();
            data.add(new DailyActiveUsers().withTimestamp(timestamp).withActiveUsers(Integer.valueOf((int)activeUsers)));
        }
        return data;
    }
}

