/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByType;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public class TotalEntitiesAggregator
extends DataInsightAggregatorInterface<TotalEntitiesByType> {
    public TotalEntitiesAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<TotalEntitiesByType> data = this.aggregate();
        DataInsightChartResult dataInsightChartResult = new DataInsightChartResult();
        return dataInsightChartResult.withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    List<TotalEntitiesByType> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregations.get("timestamp");
        ArrayList<TotalEntitiesByType> data = new ArrayList<TotalEntitiesByType>();
        ArrayList<Double> entityCount = new ArrayList<Double>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation entityTypeBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("entityType");
            for (MultiBucketsAggregation.Bucket entityTypeBucket : entityTypeBuckets.getBuckets()) {
                String entityType = entityTypeBucket.getKeyAsString();
                Sum sumEntityCount = (Sum)entityTypeBucket.getAggregations().get("entityCount");
                data.add(new TotalEntitiesByType().withTimestamp(timestamp).withEntityType(entityType).withEntityCount(Double.valueOf(sumEntityCount.getValue())));
                entityCount.add(sumEntityCount.getValue());
            }
        }
        double totalEntities = entityCount.stream().mapToDouble(v -> v).sum();
        for (TotalEntitiesByType el : data) {
            el.withEntityCountFraction(Double.valueOf(el.getEntityCount() / totalEntities));
        }
        return data;
    }
}

