/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class GlossaryTermIndex
implements ElasticSearchIndex {
    final GlossaryTerm glossaryTerm;
    final List<String> excludeFields = List.of("changeDescription");

    public GlossaryTermIndex(GlossaryTerm glossaryTerm) {
        this.glossaryTerm = glossaryTerm;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.glossaryTerm);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.glossaryTerm.getName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.glossaryTerm.getDisplayName()).weight(10).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "glossaryTerm");
        return doc;
    }
}

