/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class UserIndex
implements ElasticSearchIndex {
    final User user;
    final List<String> excludeFields = List.of("owns", "changeDescription");

    public UserIndex(User user) {
        this.user = user;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.user);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.user.getName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.user.getDisplayName()).weight(10).build());
        doc.remove("owns");
        doc.remove("follows");
        doc.put("suggest", suggest);
        doc.put("entityType", "user");
        return doc;
    }
}

