/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.AuditLog;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.events.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class AuditEventHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuditEventHandler.class);
    private final Marker auditMarker = MarkerFactory.getMarker((String)"AUDIT");

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi jdbi) {
    }

    @Override
    public Void process(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int responseCode = responseContext.getStatus();
        String method = requestContext.getMethod();
        if (responseContext.getEntity() != null) {
            String path = requestContext.getUriInfo().getPath();
            String username = "anonymous";
            if (requestContext.getSecurityContext().getUserPrincipal() != null) {
                username = requestContext.getSecurityContext().getUserPrincipal().getName();
            }
            try {
                EntityReference entityReference = ((EntityInterface)responseContext.getEntity()).getEntityReference();
                AuditLog auditLog = new AuditLog().withPath(path).withTimestamp(Long.valueOf(System.currentTimeMillis())).withEntityId(entityReference.getId()).withEntityType(entityReference.getType()).withMethod(AuditLog.Method.fromValue((String)method)).withUserName(username).withResponseCode(Integer.valueOf(responseCode));
                LOG.info(this.auditMarker, String.format("Added audit log entry: %s", auditLog));
            }
            catch (Exception e) {
                LOG.error(this.auditMarker, String.format("Failed to capture audit log for %s and method %s due to %s", path, method, e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public void close() {
    }
}

