/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.alerts.AlertsPublisherManager;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertActionRepository
extends EntityRepository<AlertAction> {
    private static final Logger LOG = LoggerFactory.getLogger(AlertActionRepository.class);
    private static final String UPDATE_FIELDS = "owner,description,displayName,alertActionConfig,alertActionType,batchSize,readTimeout,timeout";
    private static final String PATCH_FIELDS = "owner,description,displayName,alertActionConfig,alertActionType,batchSize,readTimeout,timeout";

    public AlertActionRepository(CollectionDAO dao) {
        super("/v1/testDefinition", "alertAction", AlertAction.class, dao.alertActionDAO(), dao, "owner,description,displayName,alertActionConfig,alertActionType,batchSize,readTimeout,timeout", "owner,description,displayName,alertActionConfig,alertActionType,batchSize,readTimeout,timeout");
    }

    @Override
    public AlertAction setFields(AlertAction entity, EntityUtil.Fields fields) throws IOException {
        entity.setOwner(fields.contains("owner") ? this.getOwner(entity) : null);
        return entity;
    }

    @Override
    public void prepare(AlertAction entity) {
        System.out.println(entity);
    }

    @Override
    public void storeEntity(AlertAction entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        entity.withOwner(null).withHref(null);
        this.store(entity, update);
        entity.withOwner(owner);
    }

    @Override
    public void storeRelationships(AlertAction entity) {
        this.storeOwner(entity, entity.getOwner());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(AlertAction original, AlertAction updated, EntityRepository.Operation operation) {
        return new AlertActionUpdater(original, updated, operation);
    }

    public class AlertActionUpdater
    extends EntityRepository.EntityUpdater {
        public AlertActionUpdater(AlertAction original, AlertAction updated, EntityRepository.Operation operation) {
            super((EntityRepository)AlertActionRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("enabled", ((AlertAction)this.original).getEnabled(), ((AlertAction)this.updated).getEnabled());
            this.recordChange("batchSize", ((AlertAction)this.original).getBatchSize(), ((AlertAction)this.updated).getBatchSize());
            this.recordChange("readTimeout", ((AlertAction)this.original).getReadTimeout(), ((AlertAction)this.updated).getReadTimeout());
            this.recordChange("timeout", ((AlertAction)this.original).getTimeout(), ((AlertAction)this.updated).getTimeout());
            this.recordChange("alertActionConfig", ((AlertAction)this.original).getAlertActionConfig(), ((AlertAction)this.updated).getAlertActionConfig());
            this.recordChange("alertActionType", ((AlertAction)this.original).getAlertActionType(), ((AlertAction)this.updated).getAlertActionType());
            AlertsPublisherManager.getInstance().updateAllAlertUsingAlertAction((AlertAction)this.updated);
        }
    }
}

