/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.alerts.Alert;
import org.openmetadata.schema.entity.alerts.AlertAction;
import org.openmetadata.schema.entity.alerts.AlertActionStatus;
import org.openmetadata.schema.entity.alerts.AlertFilterRule;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.alerts.AlertUtil;
import org.openmetadata.service.alerts.AlertsPublisherManager;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertRepository
extends EntityRepository<Alert> {
    private static final Logger LOG = LoggerFactory.getLogger(AlertRepository.class);
    public static final String COLLECTION_PATH = "/v1/alerts";
    static final String ALERT_PATCH_FIELDS = "owner,triggerConfig,filteringRules,alertActions";
    static final String ALERT_UPDATE_FIELDS = "owner,triggerConfig,filteringRules,alertActions";

    public AlertRepository(CollectionDAO dao) {
        super("v1/alerts/", "alert", Alert.class, dao.alertDAO(), dao, "owner,triggerConfig,filteringRules,alertActions", "owner,triggerConfig,filteringRules,alertActions");
    }

    @Override
    public Alert setFields(Alert entity, EntityUtil.Fields fields) throws IOException {
        entity.setAlertActions(fields.contains("alertActions") ? this.getAlertActions(entity) : null);
        entity.setOwner(fields.contains("owner") ? this.getOwner(entity) : null);
        return entity;
    }

    @Override
    public void prepare(Alert entity) throws IOException {
        this.validateAlertActions(entity.getAlertActions());
        this.validateFilterRules(entity);
    }

    private void validateFilterRules(Alert entity) {
        List rules = entity.getFilteringRules();
        for (AlertFilterRule rule : rules) {
            AlertUtil.validateExpression(rule.getCondition(), Boolean.class);
        }
        rules.sort(Comparator.comparing(AlertFilterRule::getName));
    }

    @Override
    public void storeEntity(Alert entity, boolean update) throws IOException {
        EntityReference owner = entity.getOwner();
        entity.withOwner(null).withHref(null);
        this.store(entity, update);
        entity.withOwner(owner);
    }

    @Override
    public void storeRelationships(Alert entity) {
        this.storeOwner(entity, entity.getOwner());
        for (EntityReference actionRef : entity.getAlertActions()) {
            this.addRelationship(entity.getId(), actionRef.getId(), "alert", "alertAction", Relationship.CONTAINS);
        }
    }

    public List<AlertAction> getAllAlertActionForAlert(UUID alertId) throws IOException {
        ArrayList<AlertAction> alertActionList = new ArrayList<AlertAction>();
        List<CollectionDAO.EntityRelationshipRecord> records = this.daoCollection.relationshipDAO().findTo(alertId.toString(), "alert", Relationship.CONTAINS.ordinal(), "alertAction");
        EntityRepository alertEntityRepository = Entity.getEntityRepository("alertAction");
        for (CollectionDAO.EntityRelationshipRecord record : records) {
            AlertAction alertAction = (AlertAction)alertEntityRepository.get(null, record.getId(), alertEntityRepository.getFields("*"));
            alertAction.setStatusDetails(this.getActionStatus(alertId, alertAction.getId()));
            alertActionList.add(alertAction);
        }
        return alertActionList;
    }

    public void validateAlertActions(List<EntityReference> alertRef) throws IOException {
        if (CommonUtil.nullOrEmpty(alertRef)) {
            throw new IllegalArgumentException("Alert Action cannot be null or Empty");
        }
        for (EntityReference ref : alertRef) {
            Entity.getEntityReferenceById(ref.getType(), ref.getId(), Include.NON_DELETED);
        }
    }

    public AlertActionStatus getActionStatus(UUID alertid, UUID actionId) throws IOException {
        String status = this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(alertid.toString(), actionId.toString());
        return JsonUtils.readValue(status, AlertActionStatus.class);
    }

    @Override
    public void restorePatchAttributes(Alert original, Alert updated) {
        updated.withId(original.getId()).withName(original.getName());
    }

    public AlertUpdater getUpdater(Alert original, Alert updated, EntityRepository.Operation operation) {
        return new AlertUpdater(original, updated, operation);
    }

    private List<EntityReference> getAlertActions(Alert entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> testCases = this.findTo(entity.getId(), "alert", Relationship.CONTAINS, "alertAction");
        return EntityUtil.getEntityReferences(testCases);
    }

    public AlertActionStatus getAlertActionStatus(UUID alertID, UUID alertActionId) throws IOException {
        String alertStatusString = this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(alertID.toString(), alertActionId.toString());
        return JsonUtils.readValue(alertStatusString, AlertActionStatus.class);
    }

    public class AlertUpdater
    extends EntityRepository.EntityUpdater {
        public AlertUpdater(Alert original, Alert updated, EntityRepository.Operation operation) {
            super((EntityRepository)AlertRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("triggerConfig", ((Alert)this.original).getTriggerConfig(), ((Alert)this.updated).getTriggerConfig());
            this.recordChange("filteringRules", ((Alert)this.original).getFilteringRules(), ((Alert)this.updated).getFilteringRules());
            this.updateToRelationships("alertActions", "alert", ((Alert)this.original).getId(), Relationship.CONTAINS, "alertAction", new ArrayList<EntityReference>(((Alert)this.original).getAlertActions()), new ArrayList<EntityReference>(((Alert)this.updated).getAlertActions()), false);
            AlertsPublisherManager.getInstance().updateAlertActionPublishers((Alert)this.updated);
        }
    }
}

