/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DashboardRepository
extends EntityRepository<Dashboard> {
    private static final String DASHBOARD_UPDATE_FIELDS = "owner,tags,charts,extension";
    private static final String DASHBOARD_PATCH_FIELDS = "owner,tags,charts,extension";

    public DashboardRepository(CollectionDAO dao) {
        super("v1/dashboards/", "dashboard", Dashboard.class, dao.dashboardDAO(), dao, "owner,tags,charts,extension", "owner,tags,charts,extension");
    }

    @Override
    public void setFullyQualifiedName(Dashboard dashboard) {
        dashboard.setFullyQualifiedName(FullyQualifiedName.add(dashboard.getService().getName(), dashboard.getName()));
    }

    @Override
    public Dashboard setFields(Dashboard dashboard, EntityUtil.Fields fields) throws IOException {
        dashboard.setService(this.getContainer(dashboard.getId()));
        dashboard.setFollowers(fields.contains("followers") ? this.getFollowers(dashboard) : null);
        dashboard.setCharts(fields.contains("charts") ? this.getCharts(dashboard) : null);
        dashboard.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), dashboard.getId()) : null);
        return dashboard;
    }

    @Override
    public void restorePatchAttributes(Dashboard original, Dashboard updated) {
        updated.withId(original.getId()).withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService());
    }

    private void populateService(Dashboard dashboard) throws IOException {
        DashboardService service = this.getService(dashboard.getService().getId(), dashboard.getService().getType());
        dashboard.setService(service.getEntityReference());
        dashboard.setServiceType(service.getServiceType());
    }

    private DashboardService getService(UUID serviceId, String entityType) throws IOException {
        if (entityType.equalsIgnoreCase("dashboardService")) {
            return (DashboardService)this.daoCollection.dashboardServiceDAO().findEntityById(serviceId);
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidServiceEntity(entityType, "dashboard", "dashboardService"));
    }

    public void setService(Dashboard dashboard, EntityReference service) {
        if (service != null && dashboard != null) {
            this.addRelationship(service.getId(), dashboard.getId(), service.getType(), "dashboard", Relationship.CONTAINS);
            dashboard.setService(service);
        }
    }

    @Override
    public void prepare(Dashboard dashboard) throws IOException {
        this.populateService(dashboard);
        dashboard.setCharts(this.getCharts(dashboard.getCharts()));
    }

    @Override
    public void storeEntity(Dashboard dashboard, boolean update) throws JsonProcessingException {
        EntityReference owner = dashboard.getOwner();
        List tags = dashboard.getTags();
        EntityReference service = dashboard.getService();
        dashboard.withOwner(null).withHref(null).withTags(null).withService(null);
        this.store(dashboard, update);
        dashboard.withOwner(owner).withTags(tags).withService(service);
    }

    @Override
    public void storeRelationships(Dashboard dashboard) {
        this.setService(dashboard, dashboard.getService());
        if (dashboard.getCharts() != null) {
            for (EntityReference chart : dashboard.getCharts()) {
                this.addRelationship(dashboard.getId(), chart.getId(), "dashboard", "chart", Relationship.HAS);
            }
        }
        this.storeOwner(dashboard, dashboard.getOwner());
        this.applyTags(dashboard);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
        return new DashboardUpdater(original, updated, operation);
    }

    private List<EntityReference> getCharts(Dashboard dashboard) throws IOException {
        if (dashboard == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> chartIds = this.findTo(dashboard.getId(), "dashboard", Relationship.HAS, "chart");
        return EntityUtil.populateEntityReferences(chartIds, "chart");
    }

    private List<EntityReference> getCharts(List<EntityReference> charts) throws IOException {
        if (charts == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityReference> chartRefs = new ArrayList<EntityReference>();
        for (EntityReference chart : charts) {
            EntityReference chartRef = this.daoCollection.chartDAO().findEntityReferenceById(chart.getId());
            chartRefs.add(chartRef);
        }
        return chartRefs.isEmpty() ? null : chartRefs;
    }

    public class DashboardUpdater
    extends EntityRepository.EntityUpdater {
        public DashboardUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateCharts();
        }

        private void updateCharts() throws JsonProcessingException {
            DashboardRepository.this.deleteFrom(((Dashboard)this.updated).getId(), "dashboard", Relationship.HAS, "chart");
            List updatedCharts = CommonUtil.listOrEmpty((List)((Dashboard)this.updated).getCharts());
            List origCharts = CommonUtil.listOrEmpty((List)((Dashboard)this.original).getCharts());
            for (EntityReference chart : updatedCharts) {
                DashboardRepository.this.addRelationship(((Dashboard)this.updated).getId(), chart.getId(), "dashboard", "chart", Relationship.HAS);
            }
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("charts", origCharts, updatedCharts, added, deleted, EntityUtil.entityReferenceMatch);
        }
    }
}

