/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryRepository
extends EntityRepository<Glossary> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryRepository.class);
    private static final String UPDATE_FIELDS = "owner,tags,reviewers";
    private static final String PATCH_FIELDS = "owner,tags,reviewers";

    public GlossaryRepository(CollectionDAO dao) {
        super("v1/glossaries/", "glossary", Glossary.class, dao.glossaryDAO(), dao, "owner,tags,reviewers", "owner,tags,reviewers");
    }

    @Override
    public Glossary setFields(Glossary glossary, EntityUtil.Fields fields) throws IOException {
        glossary.setReviewers(fields.contains("reviewers") ? this.getReviewers(glossary) : null);
        return glossary.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(glossary) : null);
    }

    @Override
    public void prepare(Glossary glossary) throws IOException {
        this.validateUsers(glossary.getReviewers());
    }

    @Override
    public void storeEntity(Glossary glossary, boolean update) throws IOException {
        EntityReference owner = glossary.getOwner();
        List tags = glossary.getTags();
        List reviewers = glossary.getReviewers();
        glossary.withOwner(null).withHref(null).withTags(null);
        this.store(glossary, update);
        glossary.withOwner(owner).withTags(tags).withReviewers(reviewers);
    }

    @Override
    public void storeRelationships(Glossary glossary) {
        this.storeOwner(glossary, glossary.getOwner());
        this.applyTags(glossary);
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)glossary.getReviewers())) {
            this.addRelationship(reviewer.getId(), glossary.getId(), "user", "glossary", Relationship.REVIEWS);
        }
    }

    private Integer getUsageCount(Glossary glossary) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), glossary.getName());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
        return new GlossaryUpdater(original, updated, operation);
    }

    private List<EntityReference> getReviewers(Glossary entity) throws IOException {
        List<CollectionDAO.EntityRelationshipRecord> ids = this.findFrom(entity.getId(), "glossary", Relationship.REVIEWS, "user");
        return EntityUtil.populateEntityReferences(ids, "user");
    }

    public class GlossaryUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryUpdater(Glossary original, Glossary updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateReviewers((Glossary)this.original, (Glossary)this.updated);
            this.updateName((Glossary)this.original, (Glossary)this.updated);
        }

        private void updateReviewers(Glossary origGlossary, Glossary updatedGlossary) throws JsonProcessingException {
            List origUsers = CommonUtil.listOrEmpty((List)origGlossary.getReviewers());
            List updatedUsers = CommonUtil.listOrEmpty((List)updatedGlossary.getReviewers());
            this.updateFromRelationships("reviewers", "user", origUsers, updatedUsers, Relationship.REVIEWS, "glossary", origGlossary.getId());
        }

        public void updateName(Glossary original, Glossary updated) throws IOException {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryRepository.this.entityType));
                }
                LOG.info("Glossary name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getName(), updated.getName());
                GlossaryRepository.this.daoCollection.tagUsageDAO().updateTagPrefix(original.getName(), updated.getName());
                this.recordChange("name", original.getName(), updated.getName());
            }
        }
    }
}

